/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gradle;

public enum Architecture {
    X64,
    ARM64,
    S390X;


    public static Architecture current() {
        String architecture;
        switch (architecture = System.getProperty("os.arch", "")) {
            case "amd64": 
            case "x86_64": {
                return X64;
            }
            case "aarch64": {
                return ARM64;
            }
            case "s390x": {
                return S390X;
            }
        }
        throw new IllegalArgumentException("can not determine architecture from [" + architecture + "]");
    }
}

