/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gradle.testclusters;

import groovy.lang.Closure;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildServiceRegistry;
import org.gradle.api.services.internal.BuildServiceProvider;
import org.gradle.api.services.internal.BuildServiceRegistryInternal;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.testing.Test;
import org.gradle.internal.resources.ResourceLock;
import org.gradle.internal.resources.SharedResource;
import org.opensearch.gradle.FileSystemOperationsAware;
import org.opensearch.gradle.test.Fixture;
import org.opensearch.gradle.testclusters.OpenSearchCluster;
import org.opensearch.gradle.testclusters.TestClustersAware;
import org.opensearch.gradle.testclusters.TestClustersThrottle;
import org.opensearch.gradle.util.GradleUtils;

@CacheableTask
public abstract class StandaloneRestIntegTestTask
extends Test
implements TestClustersAware,
FileSystemOperationsAware {
    private Collection<OpenSearchCluster> clusters = new HashSet<OpenSearchCluster>();
    private Closure<Void> beforeStart;

    @Inject
    public StandaloneRestIntegTestTask(Project project) {
        this.getOutputs().doNotCacheIf("Caching disabled for this task since it uses a cluster shared by other tasks", t -> project.getTasks().withType(StandaloneRestIntegTestTask.class).stream().filter(task -> task != this).anyMatch(task -> !Collections.disjoint(task.getClusters(), this.getClusters())));
        this.getOutputs().doNotCacheIf("Caching disabled for this task since it is configured to preserve data directory", t -> this.getClusters().stream().anyMatch(cluster -> cluster.isPreserveDataDir()));
    }

    public void setBeforeStart(Closure<Void> closure) {
        this.beforeStart = closure;
    }

    @Override
    public void beforeStart() {
        if (this.beforeStart != null) {
            this.beforeStart.call((Object)this);
        }
    }

    public int getMaxParallelForks() {
        return 1;
    }

    @Override
    @Nested
    public Collection<OpenSearchCluster> getClusters() {
        return this.clusters;
    }

    @Internal
    public List<ResourceLock> getSharedResources() {
        ArrayList<ResourceLock> locks = new ArrayList<ResourceLock>(super.getSharedResources());
        BuildServiceRegistryInternal serviceRegistry = (BuildServiceRegistryInternal)this.getServices().get(BuildServiceRegistryInternal.class);
        Provider throttleProvider = GradleUtils.getBuildService((BuildServiceRegistry)serviceRegistry, "testClustersThrottle");
        SharedResource resource = this.getSharedResource(serviceRegistry, throttleProvider);
        int nodeCount = this.clusters.stream().mapToInt(cluster -> cluster.getNodes().size()).sum();
        if (nodeCount > 0) {
            locks.add(this.getResourceLock(resource, Math.min(nodeCount, resource.getMaxUsages())));
        }
        return Collections.unmodifiableList(locks);
    }

    private SharedResource getSharedResource(BuildServiceRegistryInternal serviceRegistry, Provider<TestClustersThrottle> throttleProvider) {
        try {
            try {
                return MethodHandles.publicLookup().findVirtual(BuildServiceRegistryInternal.class, "forService", MethodType.methodType(SharedResource.class, Provider.class)).bindTo(serviceRegistry).invokeExact(throttleProvider);
            }
            catch (IllegalAccessException | NoSuchMethodException ex) {
                return MethodHandles.publicLookup().findVirtual(BuildServiceRegistryInternal.class, "forService", MethodType.methodType(SharedResource.class, BuildServiceProvider.class)).bindTo(serviceRegistry).invokeExact((BuildServiceProvider)throttleProvider);
            }
        }
        catch (Throwable ex) {
            throw new IllegalStateException("Unable to find suitable BuildServiceRegistryInternal::forService", ex);
        }
    }

    private ResourceLock getResourceLock(SharedResource resource, int nUsages) {
        try {
            try {
                return MethodHandles.publicLookup().findVirtual(SharedResource.class, "getResourceLock", MethodType.methodType(ResourceLock.class, Integer.TYPE)).bindTo(resource).invokeExact(nUsages);
            }
            catch (IllegalAccessException | NoSuchMethodException ex) {
                return MethodHandles.publicLookup().findVirtual(SharedResource.class, "getResourceLock", MethodType.methodType(ResourceLock.class)).bindTo(resource).invokeExact();
            }
        }
        catch (Throwable ex) {
            throw new IllegalStateException("Unable to find suitable ResourceLock::getResourceLock", ex);
        }
    }

    public Task dependsOn(Object ... dependencies) {
        super.dependsOn(dependencies);
        for (Object dependency : dependencies) {
            if (!(dependency instanceof Fixture)) continue;
            this.finalizedBy(new Object[]{((Fixture)dependency).getStopTask()});
        }
        return this;
    }

    public void setDependsOn(Iterable<?> dependencies) {
        super.setDependsOn(dependencies);
        for (Object dependency : dependencies) {
            if (!(dependency instanceof Fixture)) continue;
            this.finalizedBy(new Object[]{((Fixture)dependency).getStopTask()});
        }
    }

    @Override
    public WorkResult delete(Object ... objects) {
        return this.getFileSystemOperations().delete(d -> d.delete(objects));
    }
}

