/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gradle.test.rest;

import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.opensearch.gradle.OpenSearchJavaPlugin;
import org.opensearch.gradle.test.RestIntegTestTask;
import org.opensearch.gradle.test.RestTestBasePlugin;
import org.opensearch.gradle.test.rest.RestTestUtil;
import org.opensearch.gradle.testclusters.TestClustersPlugin;
import org.opensearch.gradle.util.GradleUtils;

public class JavaRestTestPlugin
implements Plugin<Project> {
    public static final String SOURCE_SET_NAME = "javaRestTest";

    public void apply(Project project) {
        project.getPluginManager().apply(OpenSearchJavaPlugin.class);
        project.getPluginManager().apply(RestTestBasePlugin.class);
        project.getPluginManager().apply(TestClustersPlugin.class);
        SourceSetContainer sourceSets = (SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class);
        SourceSet javaTestSourceSet = (SourceSet)sourceSets.create(SOURCE_SET_NAME);
        RestTestUtil.createTestCluster(project, javaTestSourceSet);
        Provider<RestIntegTestTask> javaRestTestTask = RestTestUtil.registerTask(project, javaTestSourceSet);
        RestTestUtil.setupDependencies(project, javaTestSourceSet);
        GradleUtils.setupIdeForTestSourceSet(project, javaTestSourceSet);
        project.getTasks().named("check").configure(check -> check.dependsOn(new Object[]{javaRestTestTask}));
    }
}

