/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gradle.test;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Specs;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.testing.Test;
import org.opensearch.gradle.Architecture;
import org.opensearch.gradle.DistributionDownloadPlugin;
import org.opensearch.gradle.JavaPackageType;
import org.opensearch.gradle.Jdk;
import org.opensearch.gradle.JdkDownloadPlugin;
import org.opensearch.gradle.OpenSearchDistribution;
import org.opensearch.gradle.SystemPropertyCommandLineArgumentProvider;
import org.opensearch.gradle.Version;
import org.opensearch.gradle.VersionProperties;
import org.opensearch.gradle.docker.DockerSupportPlugin;
import org.opensearch.gradle.docker.DockerSupportService;
import org.opensearch.gradle.info.BuildParams;
import org.opensearch.gradle.internal.InternalDistributionDownloadPlugin;
import org.opensearch.gradle.test.GradleDistroTestTask;
import org.opensearch.gradle.util.GradleUtils;
import org.opensearch.gradle.util.Util;
import org.opensearch.gradle.vagrant.VagrantBasePlugin;
import org.opensearch.gradle.vagrant.VagrantExtension;
import org.opensearch.gradle.vagrant.VagrantMachine;

public class DistroTestPlugin
implements Plugin<Project> {
    private static final String SYSTEM_JDK_VERSION = "21.0.6+7";
    private static final String SYSTEM_JDK_VENDOR = "adoptium";
    private static final String GRADLE_JDK_VERSION = "21.0.6+7";
    private static final String GRADLE_JDK_VENDOR = "adoptium";
    private static final String EXAMPLE_PLUGIN_CONFIGURATION = "examplePlugin";
    private static final String IN_VM_SYSPROP = "tests.inVM";
    private static final String DISTRIBUTION_SYSPROP = "tests.distribution";
    private static final String BWC_DISTRIBUTION_SYSPROP = "tests.bwc-distribution";
    private static final String EXAMPLE_PLUGIN_SYSPROP = "tests.example-plugin";

    public void apply(Project project) {
        project.getRootProject().getPluginManager().apply(DockerSupportPlugin.class);
        project.getPlugins().apply(InternalDistributionDownloadPlugin.class);
        project.getPlugins().apply(JdkDownloadPlugin.class);
        project.getPluginManager().apply("opensearch.build");
        Provider dockerSupport = GradleUtils.getBuildService(project.getGradle().getSharedServices(), "dockerSupportService");
        NamedDomainObjectContainer<OpenSearchDistribution> allDistributions = DistributionDownloadPlugin.getContainer(project);
        List<OpenSearchDistribution> testDistributions = this.configureDistributions(project);
        Map<OpenSearchDistribution.Type, TaskProvider<?>> lifecycleTasks = DistroTestPlugin.lifecycleTasks(project, "destructiveDistroTest");
        Map<String, TaskProvider<?>> versionTasks = DistroTestPlugin.versionTasks(project, "destructiveDistroUpgradeTest");
        TaskProvider destructiveDistroTest = project.getTasks().register("destructiveDistroTest");
        Configuration examplePlugin = DistroTestPlugin.configureExamplePlugin(project);
        ArrayList<TaskProvider<Test>> windowsTestTasks = new ArrayList<TaskProvider<Test>>();
        HashMap<OpenSearchDistribution.Type, List> linuxTestTasks = new HashMap<OpenSearchDistribution.Type, List>();
        HashMap<String, List> upgradeTestTasks = new HashMap<String, List>();
        HashMap<String, TaskProvider> depsTasks = new HashMap<String, TaskProvider>();
        for (OpenSearchDistribution distribution : testDistributions) {
            String taskname = DistroTestPlugin.destructiveDistroTestTaskName(distribution);
            TaskProvider depsTask = project.getTasks().register(taskname + "#deps");
            depsTask.configure(t -> t.dependsOn(new Object[]{distribution, examplePlugin}));
            depsTasks.put(taskname, depsTask);
            if (project.getTasksByName(taskname, false).isEmpty()) {
                TaskProvider<Test> destructiveTask = DistroTestPlugin.configureTestTask(project, taskname, distribution, (Action<? super Test>)((Action)t -> {
                    t.onlyIf(t2 -> !distribution.isDocker() || ((DockerSupportService)dockerSupport.get()).getDockerAvailability().isAvailable);
                    DistroTestPlugin.addSysprop(t, DISTRIBUTION_SYSPROP, distribution::getFilepath);
                    DistroTestPlugin.addSysprop(t, EXAMPLE_PLUGIN_SYSPROP, () -> examplePlugin.getSingleFile().toString());
                    t.exclude(new String[]{"**/PackageUpgradeTests.class"});
                }), depsTask);
                if (distribution.getPlatform() == OpenSearchDistribution.Platform.WINDOWS) {
                    windowsTestTasks.add(destructiveTask);
                } else {
                    linuxTestTasks.computeIfAbsent(distribution.getType(), k -> new ArrayList()).add(destructiveTask);
                }
                destructiveDistroTest.configure(t -> t.dependsOn(new Object[]{destructiveTask}));
                lifecycleTasks.get((Object)distribution.getType()).configure(t -> t.dependsOn(new Object[]{destructiveTask}));
            }
            if (distribution.getType() != OpenSearchDistribution.Type.DEB && distribution.getType() != OpenSearchDistribution.Type.RPM || distribution.getBundledJdk() == JavaPackageType.NONE) continue;
            for (Version version : BuildParams.getBwcVersions().getIndexCompatible()) {
                if (version.before("6.3.0")) continue;
                OpenSearchDistribution bwcDistro = version.equals(Version.fromString(distribution.getVersion())) ? distribution : DistroTestPlugin.createDistro(allDistributions, distribution.getArchitecture(), distribution.getType(), distribution.getPlatform(), distribution.getBundledJdk(), version.toString());
                String upgradeTaskname = DistroTestPlugin.destructiveDistroUpgradeTestTaskName(distribution, version.toString());
                TaskProvider upgradeDepsTask = project.getTasks().register(upgradeTaskname + "#deps");
                upgradeDepsTask.configure(t -> t.dependsOn(new Object[]{distribution, bwcDistro}));
                depsTasks.put(upgradeTaskname, upgradeDepsTask);
                TaskProvider<Test> upgradeTest = DistroTestPlugin.configureTestTask(project, upgradeTaskname, distribution, (Action<? super Test>)((Action)t -> {
                    DistroTestPlugin.addSysprop(t, DISTRIBUTION_SYSPROP, distribution::getFilepath);
                    DistroTestPlugin.addSysprop(t, BWC_DISTRIBUTION_SYSPROP, bwcDistro::getFilepath);
                    t.include(new String[]{"**/PackageUpgradeTests.class"});
                }), upgradeDepsTask);
                versionTasks.get(version.toString()).configure(t -> t.dependsOn(new Object[]{upgradeTest}));
                upgradeTestTasks.computeIfAbsent(version.toString(), k -> new ArrayList()).add(upgradeTest);
            }
        }
        TaskProvider<Copy> linuxGradleJdk = DistroTestPlugin.createJdk(project, "gradle", "adoptium", "21.0.6+7", "linux", "x64");
        TaskProvider<Copy> linuxSystemJdk = DistroTestPlugin.createJdk(project, "system", "adoptium", "21.0.6+7", "linux", "x64");
        TaskProvider<Copy> windowsGradleJdk = DistroTestPlugin.createJdk(project, "gradle", "adoptium", "21.0.6+7", "windows", "x64");
        TaskProvider<Copy> windowsSystemJdk = DistroTestPlugin.createJdk(project, "system", "adoptium", "21.0.6+7", "windows", "x64");
        project.subprojects(vmProject -> {
            vmProject.getPluginManager().apply(VagrantBasePlugin.class);
            TaskProvider gradleJdk = DistroTestPlugin.isWindows(vmProject) ? windowsGradleJdk : linuxGradleJdk;
            TaskProvider systemJdk = DistroTestPlugin.isWindows(vmProject) ? windowsSystemJdk : linuxSystemJdk;
            DistroTestPlugin.configureVM(vmProject, (TaskProvider<Copy>)gradleJdk, (TaskProvider<Copy>)systemJdk);
            List<Object> vmDependencies = Arrays.asList(gradleJdk, systemJdk, project.getConfigurations().getByName("testRuntimeClasspath"));
            Map<OpenSearchDistribution.Type, TaskProvider<?>> vmLifecyleTasks = DistroTestPlugin.lifecycleTasks(vmProject, "distroTest");
            Map<String, TaskProvider<?>> vmVersionTasks = DistroTestPlugin.versionTasks(vmProject, "distroUpgradeTest");
            TaskProvider distroTest = vmProject.getTasks().register("distroTest");
            if (DistroTestPlugin.isWindows(vmProject)) {
                DistroTestPlugin.configureVMWrapperTasks(vmProject, windowsTestTasks, depsTasks, (Action<TaskProvider<GradleDistroTestTask>>)((Action)wrapperTask -> ((TaskProvider)vmLifecyleTasks.get((Object)OpenSearchDistribution.Type.ARCHIVE)).configure(t -> t.dependsOn(new Object[]{wrapperTask}))), vmDependencies);
            } else {
                for (Map.Entry entry : linuxTestTasks.entrySet()) {
                    OpenSearchDistribution.Type type = (OpenSearchDistribution.Type)((Object)((Object)entry.getKey()));
                    TaskProvider<?> vmLifecycleTask = vmLifecyleTasks.get((Object)type);
                    DistroTestPlugin.configureVMWrapperTasks(vmProject, (List)entry.getValue(), depsTasks, (Action<TaskProvider<GradleDistroTestTask>>)((Action)wrapperTask -> {
                        boolean shouldExecute;
                        vmLifecycleTask.configure(t -> t.dependsOn(new Object[]{wrapperTask}));
                        boolean bl = shouldExecute = type != OpenSearchDistribution.Type.DOCKER || Boolean.TRUE.equals(vmProject.findProperty("shouldTestDocker"));
                        if (shouldExecute) {
                            distroTest.configure(t -> t.dependsOn(new Object[]{wrapperTask}));
                        }
                    }), vmDependencies);
                }
                for (Map.Entry entry : upgradeTestTasks.entrySet()) {
                    String version = (String)entry.getKey();
                    TaskProvider<?> vmVersionTask = vmVersionTasks.get(version);
                    DistroTestPlugin.configureVMWrapperTasks(vmProject, (List)entry.getValue(), depsTasks, (Action<TaskProvider<GradleDistroTestTask>>)((Action)wrapperTask -> vmVersionTask.configure(t -> t.dependsOn(new Object[]{wrapperTask}))), vmDependencies);
                }
            }
        });
    }

    private static Map<OpenSearchDistribution.Type, TaskProvider<?>> lifecycleTasks(Project project, String taskPrefix) {
        HashMap lifecyleTasks = new HashMap();
        lifecyleTasks.put(OpenSearchDistribution.Type.DOCKER, project.getTasks().register(taskPrefix + ".docker"));
        lifecyleTasks.put(OpenSearchDistribution.Type.ARCHIVE, project.getTasks().register(taskPrefix + ".archives"));
        lifecyleTasks.put(OpenSearchDistribution.Type.DEB, project.getTasks().register(taskPrefix + ".packages"));
        lifecyleTasks.put(OpenSearchDistribution.Type.RPM, (TaskProvider)lifecyleTasks.get((Object)OpenSearchDistribution.Type.DEB));
        return lifecyleTasks;
    }

    private static Map<String, TaskProvider<?>> versionTasks(Project project, String taskPrefix) {
        HashMap versionTasks = new HashMap();
        for (Version version : BuildParams.getBwcVersions().getIndexCompatible()) {
            versionTasks.put(version.toString(), project.getTasks().register(taskPrefix + ".v" + String.valueOf(version)));
        }
        return versionTasks;
    }

    private static TaskProvider<Copy> createJdk(Project project, String purpose, String vendor, String version, String platform, String architecture) {
        Jdk jdk = (Jdk)JdkDownloadPlugin.getContainer(project).create(platform + "-" + purpose);
        jdk.setVendor(vendor);
        jdk.setVersion(version);
        jdk.setPlatform(platform);
        jdk.setArchitecture(architecture);
        String taskname = "copy" + Util.capitalize(platform) + Util.capitalize(purpose) + "Jdk";
        TaskProvider copyTask = project.getTasks().register(taskname, Copy.class);
        copyTask.configure(t -> {
            t.from(new Object[]{jdk});
            t.into((Object)new File(project.getBuildDir(), "jdks/" + platform + "-" + architecture + "-" + vendor + "-" + version));
        });
        return copyTask;
    }

    private static void configureVM(Project project, TaskProvider<Copy> gradleJdkProvider, TaskProvider<Copy> systemJdkProvider) {
        String box = project.getName();
        VagrantExtension vagrant = (VagrantExtension)project.getExtensions().getByType(VagrantExtension.class);
        vagrant.setBox(box);
        vagrant.vmEnv("SYSTEM_JAVA_HOME", DistroTestPlugin.convertPath(project, vagrant, systemJdkProvider, "", ""));
        vagrant.vmEnv("JAVA_HOME", DistroTestPlugin.convertPath(project, vagrant, gradleJdkProvider, "", ""));
        if (System.getenv("JENKINS_URL") != null) {
            Stream.of("JOB_NAME", "JENKINS_URL", "BUILD_NUMBER", "BUILD_URL").forEach(name -> vagrant.vmEnv((String)name, System.getenv(name)));
        }
        vagrant.setIsWindowsVM(DistroTestPlugin.isWindows(project));
    }

    private static Object convertPath(Project project, VagrantExtension vagrant, TaskProvider<Copy> jdkProvider, String additionaLinux, String additionalWindows) {
        return Util.toStringable(() -> {
            String hostPath = ((Copy)jdkProvider.get()).getDestinationDir().toString();
            if (vagrant.isWindowsVM()) {
                return VagrantMachine.convertWindowsPath(project, hostPath) + additionalWindows;
            }
            return VagrantMachine.convertLinuxPath(project, hostPath) + additionaLinux;
        });
    }

    private static Configuration configureExamplePlugin(Project project) {
        Configuration examplePlugin = (Configuration)project.getConfigurations().create(EXAMPLE_PLUGIN_CONFIGURATION);
        DependencyHandler deps = project.getDependencies();
        HashMap<String, String> examplePluginProject = new HashMap<String, String>(){
            {
                this.put("path", ":example-plugins:custom-settings");
                this.put("configuration", "zip");
            }
        };
        deps.add(EXAMPLE_PLUGIN_CONFIGURATION, (Object)deps.project((Map)examplePluginProject));
        return examplePlugin;
    }

    private static void configureVMWrapperTasks(Project project, List<TaskProvider<Test>> destructiveTasks, Map<String, TaskProvider<?>> depsTasks, Action<TaskProvider<GradleDistroTestTask>> configure, Object ... additionalDeps) {
        for (TaskProvider<Test> destructiveTask : destructiveTasks) {
            String destructiveTaskName = destructiveTask.getName();
            Object taskname = destructiveTaskName.substring("destructive".length());
            taskname = ((String)taskname).substring(0, 1).toLowerCase(Locale.ROOT) + ((String)taskname).substring(1);
            TaskProvider vmTask = project.getTasks().register((String)taskname, GradleDistroTestTask.class, t -> {
                t.setGroup("verification");
                t.setDescription("Runs " + destructiveTaskName.split("\\.", 2)[1] + " tests within vagrant");
                t.setTaskName(destructiveTaskName);
                t.extraArg("-D'tests.inVM'");
                t.dependsOn(new Object[]{depsTasks.get(destructiveTaskName)});
                t.dependsOn(additionalDeps);
            });
            configure.execute((Object)vmTask);
        }
    }

    private static TaskProvider<Test> configureTestTask(Project project, String taskname, OpenSearchDistribution distribution, Action<? super Test> configure, Object ... deps) {
        return project.getTasks().register(taskname, Test.class, t -> {
            t.onlyIf(t3 -> distribution.getArchitecture() == Architecture.current());
            t.getOutputs().doNotCacheIf("Build cache is disabled for packaging tests", Specs.satisfyAll());
            t.setMaxParallelForks(1);
            t.setWorkingDir(project.getProjectDir());
            if (System.getProperty(IN_VM_SYSPROP) == null) {
                t.dependsOn(deps);
            }
            configure.execute(t);
        });
    }

    private List<OpenSearchDistribution> configureDistributions(Project project) {
        NamedDomainObjectContainer<OpenSearchDistribution> distributions = DistributionDownloadPlugin.getContainer(project);
        ArrayList<OpenSearchDistribution> currentDistros = new ArrayList<OpenSearchDistribution>();
        for (Architecture architecture : Architecture.values()) {
            for (OpenSearchDistribution.Type type : Arrays.asList(OpenSearchDistribution.Type.DEB, OpenSearchDistribution.Type.RPM, OpenSearchDistribution.Type.DOCKER)) {
                for (JavaPackageType bundledJdk : Set.of(JavaPackageType.NONE, JavaPackageType.JDK)) {
                    if (bundledJdk == JavaPackageType.NONE && (architecture == Architecture.ARM64 || type == OpenSearchDistribution.Type.DOCKER)) continue;
                    currentDistros.add(DistroTestPlugin.createDistro(distributions, architecture, type, null, bundledJdk, VersionProperties.getOpenSearch()));
                }
            }
        }
        for (Architecture architecture : Architecture.values()) {
            for (OpenSearchDistribution.Platform platform : Arrays.asList(OpenSearchDistribution.Platform.LINUX, OpenSearchDistribution.Platform.WINDOWS)) {
                for (JavaPackageType bundledJdk : Set.of(JavaPackageType.NONE, JavaPackageType.JDK)) {
                    if (bundledJdk == JavaPackageType.NONE && architecture != Architecture.X64) continue;
                    currentDistros.add(DistroTestPlugin.createDistro(distributions, architecture, OpenSearchDistribution.Type.ARCHIVE, platform, bundledJdk, VersionProperties.getOpenSearch()));
                }
            }
        }
        return currentDistros;
    }

    private static OpenSearchDistribution createDistro(NamedDomainObjectContainer<OpenSearchDistribution> distributions, Architecture architecture, OpenSearchDistribution.Type type, OpenSearchDistribution.Platform platform, JavaPackageType bundledJdk, String version) {
        String name = DistroTestPlugin.distroId(type, platform, bundledJdk, architecture) + "-" + version;
        boolean isDocker = type == OpenSearchDistribution.Type.DOCKER;
        OpenSearchDistribution distro = (OpenSearchDistribution)distributions.create(name, d -> {
            d.setArchitecture(architecture);
            d.setType(type);
            if (type == OpenSearchDistribution.Type.ARCHIVE) {
                d.setPlatform(platform);
            }
            if (!isDocker) {
                d.setBundledJdk(bundledJdk);
            }
            d.setVersion(version);
        });
        if (isDocker) {
            distro.setFailIfUnavailable(false);
        }
        return distro;
    }

    private static boolean isWindows(Project project) {
        return project.getName().contains("windows");
    }

    private static String distroId(OpenSearchDistribution.Type type, OpenSearchDistribution.Platform platform, JavaPackageType bundledJdk, Architecture architecture) {
        return (String)(type == OpenSearchDistribution.Type.ARCHIVE ? String.valueOf((Object)platform) + "-" : "") + String.valueOf((Object)type) + (bundledJdk != JavaPackageType.NONE ? (bundledJdk == JavaPackageType.JDK ? "" : "-jre") : "-no-jdk") + (String)(architecture == Architecture.X64 ? "" : "-" + architecture.toString().toLowerCase());
    }

    private static String destructiveDistroTestTaskName(OpenSearchDistribution distro) {
        OpenSearchDistribution.Type type = distro.getType();
        return "destructiveDistroTest." + DistroTestPlugin.distroId(type, distro.getPlatform(), distro.getBundledJdk(), distro.getArchitecture());
    }

    private static String destructiveDistroUpgradeTestTaskName(OpenSearchDistribution distro, String bwcVersion) {
        OpenSearchDistribution.Type type = distro.getType();
        return "destructiveDistroUpgradeTest.v" + bwcVersion + "." + DistroTestPlugin.distroId(type, distro.getPlatform(), distro.getBundledJdk(), distro.getArchitecture());
    }

    private static void addSysprop(Test task, String sysprop, Supplier<String> valueSupplier) {
        SystemPropertyCommandLineArgumentProvider props = (SystemPropertyCommandLineArgumentProvider)task.getExtensions().getByType(SystemPropertyCommandLineArgumentProvider.class);
        props.systemProperty(sysprop, valueSupplier);
    }
}

