/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gradle.precommit;

import java.io.File;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.CompileClasspath;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.JavaExecSpec;
import org.opensearch.gradle.LoggedExec;
import org.opensearch.gradle.precommit.PrecommitTask;

@CacheableTask
public class JarHellTask
extends PrecommitTask {
    private FileCollection classpath;
    private final Project project;

    @Inject
    public JarHellTask(Project project) {
        super(project);
        this.setDescription("Runs CheckJarHell on the configured classpath");
        this.project = project;
    }

    @TaskAction
    public void runJarHellCheck() {
        LoggedExec.javaexec(this.project, (Action<JavaExecSpec>)((Action)spec -> {
            spec.environment("CLASSPATH", (Object)this.getClasspath().getAsPath());
            spec.getMainClass().set((Object)"org.opensearch.bootstrap.JarHell");
        }));
    }

    @CompileClasspath
    public FileCollection getClasspath() {
        return this.classpath.filter(File::exists);
    }

    public void setClasspath(FileCollection classpath) {
        this.classpath = classpath;
    }
}

