/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gradle.precommit;

import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskProvider;
import org.opensearch.gradle.dependencies.CompileOnlyResolvePlugin;
import org.opensearch.gradle.precommit.DependencyLicensesTask;
import org.opensearch.gradle.precommit.PrecommitPlugin;
import org.opensearch.gradle.precommit.UpdateShasTask;
import org.opensearch.gradle.util.GradleUtils;

public class DependencyLicensesPrecommitPlugin
extends PrecommitPlugin {
    @Override
    public TaskProvider<? extends Task> createTask(Project project) {
        project.getPlugins().apply(CompileOnlyResolvePlugin.class);
        TaskProvider dependencyLicenses = project.getTasks().register("dependencyLicenses", DependencyLicensesTask.class);
        Configuration runtimeClasspath = project.getConfigurations().getByName("runtimeClasspath");
        Configuration compileOnly = project.getConfigurations().getByName("resolveableCompileOnly");
        Provider provider = project.provider(() -> GradleUtils.getFiles(project, runtimeClasspath, (Spec<Dependency>)((Spec)dependency -> !(dependency instanceof ProjectDependency))).minus((FileCollection)compileOnly));
        dependencyLicenses.configure(t -> t.getDependencies().set(provider));
        project.getTasks().register("updateShas", UpdateShasTask.class, t -> t.setParentTask((TaskProvider<DependencyLicensesTask>)dependencyLicenses));
        return dependencyLicenses;
    }
}

