/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gradle.internal;

import java.util.function.Function;
import org.gradle.api.GradleException;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Dependency;
import org.opensearch.gradle.Architecture;
import org.opensearch.gradle.BwcVersions;
import org.opensearch.gradle.DistributionDependency;
import org.opensearch.gradle.DistributionDownloadPlugin;
import org.opensearch.gradle.DistributionResolution;
import org.opensearch.gradle.JavaPackageType;
import org.opensearch.gradle.OpenSearchDistribution;
import org.opensearch.gradle.Version;
import org.opensearch.gradle.VersionProperties;
import org.opensearch.gradle.info.BuildParams;
import org.opensearch.gradle.info.GlobalBuildInfoPlugin;
import org.opensearch.gradle.util.GradleUtils;

public class InternalDistributionDownloadPlugin
implements Plugin<Project> {
    private BwcVersions bwcVersions = null;

    public void apply(Project project) {
        project.getRootProject().getPluginManager().apply(GlobalBuildInfoPlugin.class);
        if (!BuildParams.isInternal().booleanValue()) {
            throw new GradleException("Plugin 'opensearch.internal-distribution-download' is not supported. Use 'opensearch.distribution-download' plugin instead.");
        }
        project.getPluginManager().apply(DistributionDownloadPlugin.class);
        this.bwcVersions = BuildParams.getBwcVersions();
        this.registerInternalDistributionResolutions(DistributionDownloadPlugin.getRegistrationsContainer(project));
    }

    private void registerInternalDistributionResolutions(NamedDomainObjectContainer<DistributionResolution> resolutions) {
        resolutions.register("localBuild", distributionResolution -> distributionResolution.setResolver((project, distribution) -> {
            if (VersionProperties.getOpenSearch().equals(distribution.getVersion())) {
                return new ProjectBasedDistributionDependency(config -> GradleUtils.projectDependency(project, InternalDistributionDownloadPlugin.distributionProjectPath(distribution), config));
            }
            return null;
        }));
        resolutions.register("bwc", distributionResolution -> distributionResolution.setResolver((project, distribution) -> {
            BwcVersions.UnreleasedVersionInfo unreleasedInfo = this.bwcVersions.unreleasedInfo(Version.fromString(distribution.getVersion()));
            if (unreleasedInfo != null) {
                if (distribution.getBundledJdk() == JavaPackageType.NONE) {
                    throw new GradleException("Configuring a snapshot bwc distribution ('" + distribution.getName() + "') without a bundled JDK is not supported.");
                }
                String projectConfig = InternalDistributionDownloadPlugin.getProjectConfig(distribution, unreleasedInfo);
                return new ProjectBasedDistributionDependency(config -> GradleUtils.projectDependency(project, unreleasedInfo.gradleProjectPath, projectConfig));
            }
            return null;
        }));
    }

    private static String getProjectConfig(OpenSearchDistribution distribution, BwcVersions.UnreleasedVersionInfo info) {
        String distributionProjectName = InternalDistributionDownloadPlugin.distributionProjectName(distribution);
        if (distribution.getType().shouldExtract()) {
            return info.gradleProjectPath.equals(":distribution") || info.version.before("7.10.0") ? distributionProjectName : "expanded-" + distributionProjectName;
        }
        return distributionProjectName;
    }

    private static String distributionProjectPath(OpenSearchDistribution distribution) {
        Object projectPath = ":distribution";
        switch (distribution.getType()) {
            case INTEG_TEST_ZIP: {
                projectPath = (String)projectPath + ":archives:integ-test-zip";
                break;
            }
            case DOCKER: {
                projectPath = (String)projectPath + ":docker:";
                projectPath = (String)projectPath + InternalDistributionDownloadPlugin.distributionProjectName(distribution);
                break;
            }
            default: {
                projectPath = (String)projectPath + (distribution.getType() == OpenSearchDistribution.Type.ARCHIVE ? ":archives:" : ":packages:");
                projectPath = (String)projectPath + InternalDistributionDownloadPlugin.distributionProjectName(distribution);
            }
        }
        return projectPath;
    }

    private static String distributionProjectName(OpenSearchDistribution distribution) {
        String archString;
        OpenSearchDistribution.Platform platform = distribution.getPlatform();
        Architecture architecture = distribution.getArchitecture();
        Object projectName = "";
        String string = archString = platform == OpenSearchDistribution.Platform.WINDOWS || architecture == Architecture.X64 ? "" : "-" + architecture.toString().toLowerCase();
        if (distribution.getBundledJdk() == JavaPackageType.NONE) {
            projectName = (String)projectName + "no-jdk-";
        } else if (distribution.getBundledJdk() == JavaPackageType.JRE) {
            projectName = (String)projectName + "jre-";
        }
        switch (distribution.getType()) {
            case ARCHIVE: {
                if (Version.fromString(distribution.getVersion()).onOrAfter("7.0.0")) {
                    projectName = (String)projectName + platform.toString() + archString + (platform == OpenSearchDistribution.Platform.WINDOWS ? "-zip" : "-tar");
                    break;
                }
                projectName = "zip";
                break;
            }
            case DOCKER: {
                projectName = (String)projectName + "docker" + archString + "-export";
                break;
            }
            default: {
                projectName = (String)projectName + String.valueOf((Object)distribution.getType());
            }
        }
        return projectName;
    }

    private static class ProjectBasedDistributionDependency
    implements DistributionDependency {
        private Function<String, Dependency> function;

        ProjectBasedDistributionDependency(Function<String, Dependency> function) {
            this.function = function;
        }

        @Override
        public Object getDefaultNotation() {
            return this.function.apply("default");
        }

        @Override
        public Object getExtractedNotation() {
            return this.function.apply("extracted");
        }
    }
}

