/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gradle.vagrant;

import java.util.function.UnaryOperator;

public class VagrantProgressLogger
implements UnaryOperator<String> {
    private static final String HEADING_PREFIX = "==> ";
    private final String squashedPrefix;
    private String lastLine = "";
    private String heading = "";
    private boolean inProgressReport = false;

    public VagrantProgressLogger(String squashedPrefix) {
        this.squashedPrefix = squashedPrefix;
    }

    @Override
    public String apply(String line) {
        if (((String)line).startsWith("\r\u001b")) {
            if ("[K".equals(line = ((String)line).substring(2))) {
                this.inProgressReport = true;
            }
            return null;
        }
        if (((String)line).startsWith(this.squashedPrefix)) {
            line = ((String)line).substring(this.squashedPrefix.length());
            this.inProgressReport = false;
            this.lastLine = line;
            if (((String)line).startsWith(HEADING_PREFIX)) {
                line = ((String)line).substring(HEADING_PREFIX.length());
                this.heading = (String)line + " > ";
            } else {
                line = this.heading + (String)line;
            }
        } else if (this.inProgressReport) {
            this.inProgressReport = false;
            line = this.lastLine + (String)line;
        } else {
            return null;
        }
        return line;
    }
}

