/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gradle.vagrant;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.execution.TaskActionListener;
import org.gradle.api.execution.TaskExecutionListener;
import org.gradle.api.tasks.TaskState;
import org.opensearch.gradle.ReaperPlugin;
import org.opensearch.gradle.ReaperService;
import org.opensearch.gradle.vagrant.VagrantExtension;
import org.opensearch.gradle.vagrant.VagrantMachine;
import org.opensearch.gradle.vagrant.VagrantShellTask;

public class VagrantBasePlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.getRootProject().getPluginManager().apply(VagrantSetupCheckerPlugin.class);
        project.getRootProject().getPluginManager().apply(VagrantManagerPlugin.class);
        project.getRootProject().getPluginManager().apply(ReaperPlugin.class);
        ReaperService reaper = (ReaperService)project.getRootProject().getExtensions().getByType(ReaperService.class);
        VagrantExtension extension = (VagrantExtension)project.getExtensions().create("vagrant", VagrantExtension.class, new Object[]{project});
        VagrantMachine service = (VagrantMachine)project.getExtensions().create("vagrantService", VagrantMachine.class, new Object[]{project, extension, reaper});
        project.getGradle().getTaskGraph().whenReady(graph -> {
            service.refs = graph.getAllTasks().stream().filter(t -> t instanceof VagrantShellTask).filter(t -> t.getProject() == project).count();
        });
    }

    static class VagrantSetupCheckerPlugin
    implements Plugin<Project> {
        private static final Pattern VAGRANT_VERSION = Pattern.compile("Vagrant (\\d+\\.\\d+\\.\\d+)");
        private static final Pattern VIRTUAL_BOX_VERSION = Pattern.compile("(\\d+\\.\\d+)");

        VagrantSetupCheckerPlugin() {
        }

        public void apply(Project project) {
            if (project != project.getRootProject()) {
                throw new IllegalArgumentException("VagrantSetupCheckerPlugin can only be applied to the root project of a build");
            }
            project.getGradle().getTaskGraph().whenReady(graph -> {
                boolean needsVagrant = graph.getAllTasks().stream().anyMatch(t -> t instanceof VagrantShellTask);
                if (needsVagrant) {
                    this.checkVersion(project, "vagrant", VAGRANT_VERSION, 1, 8, 6);
                    this.checkVersion(project, "vboxmanage", VIRTUAL_BOX_VERSION, 5, 1);
                }
            });
        }

        void checkVersion(Project project, String tool, Pattern versionRegex, int ... minVersion) {
            int found;
            ByteArrayOutputStream pipe = new ByteArrayOutputStream();
            project.exec(spec -> {
                spec.setCommandLine(new Object[]{tool, "--version"});
                spec.setStandardOutput((OutputStream)pipe);
            });
            String output = pipe.toString(StandardCharsets.UTF_8).trim();
            Matcher matcher = versionRegex.matcher(output);
            if (!matcher.find()) {
                throw new IllegalStateException(tool + " version output [" + output + "] did not match regex [" + versionRegex.pattern() + "]");
            }
            String version = matcher.group(1);
            List versionParts = Stream.of(version.split("\\.")).map(Integer::parseInt).collect(Collectors.toList());
            for (int i = 0; i < minVersion.length && (found = ((Integer)versionParts.get(i)).intValue()) <= minVersion[i]; ++i) {
                if (found >= minVersion[i]) continue;
                String exceptionMessage = String.format("Unsupported version of %s. Found [%s], expected [%s+", tool, version, Stream.of(minVersion).map(String::valueOf).collect(Collectors.joining(".")));
                throw new IllegalStateException(exceptionMessage);
            }
        }
    }

    static class VagrantManagerPlugin
    implements Plugin<Project>,
    TaskActionListener,
    TaskExecutionListener {
        VagrantManagerPlugin() {
        }

        public void apply(Project project) {
            if (project != project.getRootProject()) {
                throw new IllegalArgumentException("VagrantManagerPlugin can only be applied to the root project of a build");
            }
            project.getGradle().addListener((Object)this);
        }

        private void callIfVagrantTask(Task task, Consumer<VagrantMachine> method) {
            if (task instanceof VagrantShellTask) {
                VagrantMachine service = (VagrantMachine)task.getProject().getExtensions().getByType(VagrantMachine.class);
                method.accept(service);
            }
        }

        public void beforeExecute(Task task) {
        }

        public void afterActions(Task task) {
        }

        public void beforeActions(Task task) {
            this.callIfVagrantTask(task, VagrantMachine::maybeStartVM);
        }

        public void afterExecute(Task task, TaskState state) {
            this.callIfVagrantTask(task, service -> service.maybeStopVM(state.getFailure() != null));
        }
    }
}

