/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gradle.precommit;

import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.opensearch.gradle.info.BuildParams;
import org.opensearch.gradle.precommit.JarHellTask;
import org.opensearch.gradle.precommit.PrecommitPlugin;
import org.opensearch.gradle.util.Util;

public class JarHellPrecommitPlugin
extends PrecommitPlugin {
    @Override
    public TaskProvider<? extends Task> createTask(Project project) {
        Configuration jarHellConfig = (Configuration)project.getConfigurations().create("jarHell");
        if (BuildParams.isInternal().booleanValue() && !project.getPath().equals(":libs:opensearch-common")) {
            project.getDependencies().add("jarHell", (Object)project.project(":libs:opensearch-common"));
        }
        TaskProvider jarHell = project.getTasks().register("jarHell", JarHellTask.class);
        jarHell.configure(t -> {
            Task testClassesTask = project.getTasks().getByName("testClasses");
            SourceSet testSourceSet = Util.getJavaTestSourceSet(project).get();
            t.setClasspath(testSourceSet.getRuntimeClasspath().plus((FileCollection)jarHellConfig));
            t.dependsOn(new Object[]{jarHellConfig, testClassesTask});
            project.getPluginManager().withPlugin("opensearch.opensearchplugin", plugin -> {
                Task propertiesTask = project.getTasks().getByName("pluginProperties");
                t.dependsOn(new Object[]{jarHellConfig, testClassesTask, propertiesTask});
            });
        });
        return jarHell;
    }
}

