/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gradle;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Version
implements Comparable<Version> {
    private final int major;
    private final int minor;
    private final int revision;
    private final int id;
    public static final int MASK = 0x8000000;
    private static final Pattern pattern = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)(-alpha\\d+|-beta\\d+|-rc\\d+)?(-SNAPSHOT)?");
    private static final Pattern relaxedPattern = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)(-[a-zA-Z0-9_]+|\\+[a-zA-Z0-9_]+)*?");

    public Version(int major, int minor, int revision) {
        Objects.requireNonNull(Integer.valueOf(major), "major version can't be null");
        Objects.requireNonNull(Integer.valueOf(minor), "minor version can't be null");
        Objects.requireNonNull(Integer.valueOf(revision), "revision version can't be null");
        this.major = major;
        this.minor = minor;
        this.revision = revision;
        int id = major * 10000000 + minor * 100000 + revision * 1000;
        this.id = major == 1 || major == 2 ? id ^ 0x8000000 : id;
    }

    private static int parseSuffixNumber(String substring) {
        if (substring.isEmpty()) {
            throw new IllegalArgumentException("Invalid suffix, must contain a number e.x. alpha2");
        }
        return Integer.parseInt(substring);
    }

    public static Version fromString(String s) {
        return Version.fromString(s, Mode.STRICT);
    }

    public static Version fromString(String s, Mode mode) {
        Matcher matcher;
        Objects.requireNonNull(s);
        Matcher matcher2 = matcher = mode == Mode.STRICT ? pattern.matcher(s) : relaxedPattern.matcher(s);
        if (!matcher.matches()) {
            String expected = mode == Mode.STRICT ? "major.minor.revision[-(alpha|beta|rc)Number][-SNAPSHOT]" : "major.minor.revision[-extra]";
            throw new IllegalArgumentException("Invalid version format: '" + s + "'. Should be " + expected);
        }
        return new Version(Integer.parseInt(matcher.group(1)), Version.parseSuffixNumber(matcher.group(2)), Version.parseSuffixNumber(matcher.group(3)));
    }

    public String toString() {
        return String.valueOf(this.getMajor()) + "." + String.valueOf(this.getMinor()) + "." + String.valueOf(this.getRevision());
    }

    public boolean before(Version compareTo) {
        return this.id < compareTo.getId();
    }

    public boolean before(String compareTo) {
        return this.before(Version.fromString(compareTo));
    }

    public boolean onOrBefore(Version compareTo) {
        return this.id <= compareTo.getId();
    }

    public boolean onOrBefore(String compareTo) {
        return this.onOrBefore(Version.fromString(compareTo));
    }

    public boolean onOrAfter(Version compareTo) {
        return this.id >= compareTo.getId();
    }

    public boolean onOrAfter(String compareTo) {
        return this.onOrAfter(Version.fromString(compareTo));
    }

    public boolean after(Version compareTo) {
        return this.id > compareTo.getId();
    }

    public boolean after(String compareTo) {
        return this.after(Version.fromString(compareTo));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version version = (Version)o;
        return this.major == version.major && this.minor == version.minor && this.revision == version.revision;
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor, this.revision, this.id);
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getRevision() {
        return this.revision;
    }

    protected int getId() {
        return this.id;
    }

    @Override
    public int compareTo(Version other) {
        return Integer.compare(this.getId(), other.getId());
    }

    public static enum Mode {
        STRICT,
        RELAXED;

    }
}

