/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gradle;

import com.github.jengelman.gradle.plugins.shadow.ShadowExtension;
import groovy.util.Node;
import groovy.util.NodeList;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.XmlProvider;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.plugins.BasePluginExtension;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.api.publish.maven.tasks.GenerateMavenPom;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.Jar;
import org.opensearch.gradle.info.BuildParams;
import org.opensearch.gradle.precommit.PomValidationPrecommitPlugin;
import org.opensearch.gradle.util.GradleUtils;
import org.opensearch.gradle.util.Util;

public class PublishPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.getPluginManager().apply("com.netflix.nebula.maven-base-publish");
        project.getPluginManager().apply("com.netflix.nebula.maven-nebula-publish");
        project.getPluginManager().apply(PomValidationPrecommitPlugin.class);
        PublishPlugin.configureJavadocJar(project);
        PublishPlugin.configureSourcesJar(project);
        PublishPlugin.configurePomGeneration(project);
    }

    private static String getArchivesBaseName(Project project) {
        return (String)((BasePluginExtension)project.getExtensions().getByType(BasePluginExtension.class)).getArchivesName().get();
    }

    private static void configurePomGeneration(final Project project) {
        TaskProvider generatePomTask = project.getTasks().register("generatePom");
        GradleUtils.maybeConfigure(project.getTasks(), "assemble", (Action<? super Task>)((Action)assemble -> assemble.dependsOn(new Object[]{generatePomTask})));
        project.getTasks().withType(GenerateMavenPom.class).configureEach(pomTask -> pomTask.setDestination((Object)new Callable<String>(){

            @Override
            public String call() throws Exception {
                return String.format("%s/distributions/%s-%s.pom", project.getBuildDir(), pomTask.getName().toLowerCase().contains("zip") ? project.getName() : PublishPlugin.getArchivesBaseName(project), project.getVersion());
            }
        }));
        PublishingExtension publishing = (PublishingExtension)project.getExtensions().getByType(PublishingExtension.class);
        project.getPluginManager().withPlugin("com.github.johnrengelman.shadow", plugin -> {
            MavenPublication publication = (MavenPublication)publishing.getPublications().maybeCreate("shadow", MavenPublication.class);
            ShadowExtension shadow = (ShadowExtension)project.getExtensions().getByType(ShadowExtension.class);
            shadow.component(publication);
            publication.getPom().withXml(xml -> {
                Node root = xml.asNode();
                if (((NodeList)root.get("name")).isEmpty()) {
                    root.appendNode((Object)"name", (Object)project.getName());
                }
                if (((NodeList)root.get("description")).isEmpty()) {
                    root.appendNode((Object)"description", (Object)project.getDescription());
                }
                Node dependenciesNode = (Node)((NodeList)root.get("dependencies")).get(0);
                project.getConfigurations().getByName("shadow").getAllDependencies().all(dependency -> {
                    if (dependency instanceof ProjectDependency) {
                        Node dependencyNode = dependenciesNode.appendNode((Object)"dependency");
                        dependencyNode.appendNode((Object)"groupId", (Object)dependency.getGroup());
                        ProjectDependency projectDependency = (ProjectDependency)dependency;
                        String artifactId = PublishPlugin.getArchivesBaseName(projectDependency.getDependencyProject());
                        dependencyNode.appendNode((Object)"artifactId", (Object)artifactId);
                        dependencyNode.appendNode((Object)"version", (Object)dependency.getVersion());
                        dependencyNode.appendNode((Object)"scope", (Object)"compile");
                    }
                });
            });
        });
        publishing.getPublications().withType(MavenPublication.class, publication -> {
            publication.getPom().withXml(PublishPlugin::addScmInfo);
            if (!publication.getName().toLowerCase().contains("zip")) {
                project.afterEvaluate(p -> publication.setArtifactId(PublishPlugin.getArchivesBaseName(project)));
                if (project.getPluginManager().hasPlugin("opensearch.java")) {
                    publication.artifact((Object)project.getTasks().getByName("sourcesJar"));
                    publication.artifact((Object)project.getTasks().getByName("javadocJar"));
                }
            } else {
                project.afterEvaluate(p -> publication.setArtifactId(project.getName()));
            }
            generatePomTask.configure(t -> t.dependsOn(new Object[]{String.format("generatePomFileFor%sPublication", Util.capitalize(publication.getName()))}));
        });
    }

    private static void addScmInfo(XmlProvider xml) {
        Node root = xml.asNode();
        Node url = null;
        Node scm = null;
        for (Object child : root.children()) {
            if (!(child instanceof Node)) continue;
            Node node = (Node)child;
            Object name = node.name();
            try {
                if (name != null && name.getClass().getSimpleName().equals("QName")) {
                    MethodHandle handle = MethodHandles.publicLookup().findVirtual(name.getClass(), "matches", MethodType.methodType(Boolean.TYPE, Object.class)).bindTo(name);
                    if (handle.invoke("url")) {
                        url = node;
                    } else if (handle.invoke("scm")) {
                        scm = node;
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if ("url".equals(name)) {
                url = node;
                continue;
            }
            if (!"scm".equals(name)) continue;
            scm = node;
        }
        if (url == null) {
            root.appendNode((Object)"url", (Object)Util.urlFromOrigin(BuildParams.getGitOrigin()));
        }
        if (scm == null) {
            Node scmNode = root.appendNode((Object)"scm");
            scmNode.appendNode((Object)"url", (Object)BuildParams.getGitOrigin());
        }
    }

    private static void configureJavadocJar(Project project) {
        project.getPlugins().withId("opensearch.java", p -> {
            TaskProvider javadocJarTask = project.getTasks().register("javadocJar", Jar.class);
            javadocJarTask.configure(jar -> {
                jar.getArchiveClassifier().set((Object)"javadoc");
                jar.setGroup("build");
                jar.setDescription("Assembles a jar containing javadocs.");
                jar.from(new Object[]{project.getTasks().named("javadoc")});
            });
            GradleUtils.maybeConfigure(project.getTasks(), "assemble", (Action<? super Task>)((Action)t -> t.dependsOn(new Object[]{javadocJarTask})));
        });
    }

    static void configureSourcesJar(Project project) {
        project.getPlugins().withId("opensearch.java", p -> {
            TaskProvider sourcesJarTask = project.getTasks().register("sourcesJar", Jar.class);
            sourcesJarTask.configure(jar -> {
                jar.getArchiveClassifier().set((Object)"sources");
                jar.setGroup("build");
                jar.setDescription("Assembles a jar containing source files.");
                SourceSet mainSourceSet = Util.getJavaMainSourceSet(project).get();
                jar.from(new Object[]{mainSourceSet.getAllSource()});
            });
            GradleUtils.maybeConfigure(project.getTasks(), "assemble", (Action<? super Task>)((Action)t -> t.dependsOn(new Object[]{sourcesJarTask})));
        });
    }
}

