/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gradle;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Supplier;

public enum OS {
    FREEBSD,
    LINUX,
    MAC,
    WINDOWS;


    public static OS current() {
        String os = System.getProperty("os.name", "");
        if (os.startsWith("FreeBSD")) {
            return FREEBSD;
        }
        if (os.startsWith("Linux") || os.startsWith("LINUX")) {
            return LINUX;
        }
        if (os.startsWith("Mac")) {
            return MAC;
        }
        if (os.startsWith("Windows")) {
            return WINDOWS;
        }
        throw new IllegalStateException("Can't determine OS from: " + os);
    }

    public static <T> Conditional<T> conditional() {
        return new Conditional();
    }

    public static Conditional<String> conditionalString() {
        return OS.conditional();
    }

    public static class Conditional<T> {
        private final Map<OS, Supplier<T>> conditions = new HashMap<OS, Supplier<T>>();

        public Conditional<T> onLinux(Supplier<T> supplier) {
            this.conditions.put(LINUX, supplier);
            return this;
        }

        public Conditional<T> onFreeBSD(Supplier<T> supplier) {
            this.conditions.put(FREEBSD, supplier);
            return this;
        }

        public Conditional<T> onMac(Supplier<T> supplier) {
            this.conditions.put(MAC, supplier);
            return this;
        }

        public Conditional<T> onUnix(Supplier<T> supplier) {
            this.conditions.put(FREEBSD, supplier);
            this.conditions.put(LINUX, supplier);
            this.conditions.put(MAC, supplier);
            return this;
        }

        public Conditional<T> onWindows(Supplier<T> supplier) {
            this.conditions.put(WINDOWS, supplier);
            return this;
        }

        public T supply() {
            HashSet<OS> missingOS = new HashSet<OS>(Arrays.asList(OS.values()));
            missingOS.removeAll(this.conditions.keySet());
            if (!missingOS.isEmpty()) {
                throw new IllegalArgumentException("No condition specified for " + String.valueOf(missingOS));
            }
            return this.conditions.get((Object)OS.current()).get();
        }
    }
}

