/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gradle.testclusters;

import java.util.Collection;
import org.gradle.api.Task;
import org.gradle.api.tasks.Nested;
import org.opensearch.gradle.testclusters.OpenSearchCluster;
import org.opensearch.gradle.testclusters.TestClustersException;

public interface TestClustersAware
extends Task {
    @Nested
    public Collection<OpenSearchCluster> getClusters();

    default public void useCluster(OpenSearchCluster cluster) {
        if (!cluster.getPath().equals(this.getProject().getPath())) {
            throw new TestClustersException("Task " + this.getPath() + " can't use test cluster from another project " + String.valueOf(cluster));
        }
        cluster.getNodes().stream().flatMap(node -> node.getDistributions().stream()).forEach(distro -> this.dependsOn(new Object[]{distro.getExtracted()}));
        cluster.getNodes().stream().map(node -> node::getBwcJdk).forEach(xva$0 -> this.dependsOn(new Object[]{xva$0}));
        cluster.getNodes().forEach(node -> {
            Object[] objectArray = new Object[1];
            objectArray[0] = node::getPluginAndModuleConfigurations;
            this.dependsOn(objectArray);
        });
        this.getClusters().add(cluster);
    }

    default public void beforeStart() {
    }
}

