/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gradle.test;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.options.Option;
import org.opensearch.gradle.vagrant.VagrantMachine;
import org.opensearch.gradle.vagrant.VagrantShellTask;

public class GradleDistroTestTask
extends VagrantShellTask {
    private String taskName;
    private String testClass;
    private List<String> extraArgs = new ArrayList<String>();

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    @Input
    public String getTaskName() {
        return this.taskName;
    }

    @Option(option="tests", description="Sets test class or method name to be included, '*' is supported.")
    public void setTestClass(String testClass) {
        this.testClass = testClass;
    }

    @Input
    public List<String> getExtraArgs() {
        return this.extraArgs;
    }

    public void extraArg(String arg) {
        this.extraArgs.add(arg);
    }

    @Override
    protected List<String> getWindowsScript() {
        return this.getScript(true);
    }

    @Override
    protected List<String> getLinuxScript() {
        return this.getScript(false);
    }

    private List<String> getScript(boolean isWindows) {
        String cacheDir = String.valueOf(this.getProject().getBuildDir()) + "/gradle-cache";
        StringBuilder line = new StringBuilder();
        line.append(isWindows ? "& .\\gradlew " : "./gradlew ");
        line.append(this.taskName);
        line.append(" --project-cache-dir ");
        line.append(isWindows ? VagrantMachine.convertWindowsPath(this.getProject(), cacheDir) : VagrantMachine.convertLinuxPath(this.getProject(), cacheDir));
        line.append(" -S");
        line.append(" --parallel");
        line.append(" -D'org.gradle.logging.level'=" + String.valueOf(this.getProject().getGradle().getStartParameter().getLogLevel()));
        if (this.testClass != null) {
            line.append(" --tests=");
            line.append(this.testClass);
        }
        this.extraArgs.stream().map(s -> " " + s).forEach(line::append);
        return Collections.singletonList(line.toString());
    }
}

