/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gradle.precommit;

import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.opensearch.gradle.precommit.PrecommitTaskPlugin;
import org.opensearch.gradle.util.GradleUtils;

public abstract class PrecommitPlugin
implements Plugin<Project> {
    public static final String PRECOMMIT_TASK_NAME = "precommit";

    public final void apply(Project project) {
        project.getPluginManager().apply(PrecommitTaskPlugin.class);
        TaskProvider<? extends Task> task = this.createTask(project);
        TaskProvider precommit = project.getTasks().named(PRECOMMIT_TASK_NAME);
        precommit.configure(t -> t.dependsOn(new Object[]{task}));
        project.getPluginManager().withPlugin("java", p -> {
            for (SourceSet sourceSet : GradleUtils.getJavaSourceSets(project)) {
                task.configure(t -> t.shouldRunAfter(new Object[]{sourceSet.getClassesTaskName()}));
            }
        });
    }

    public abstract TaskProvider<? extends Task> createTask(Project var1);
}

