/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gradle.precommit;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.tasks.IgnoreEmptyDirectories;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.StopExecutionException;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.opensearch.gradle.util.GradleUtils;

public class FilePermissionsTask
extends DefaultTask {
    private final PatternFilterable filesFilter = new PatternSet().include(new String[]{"**"}).exclude(new String[]{"**/*.sh"});
    private File outputMarker = new File(this.getProject().getBuildDir(), "markers/filePermissions");

    public FilePermissionsTask() {
        this.setDescription("Checks java source files for correct file permissions");
    }

    private static boolean isExecutableFile(File file) {
        try {
            Set<PosixFilePermission> permissions = Files.getFileAttributeView(file.toPath(), PosixFileAttributeView.class, new LinkOption[0]).readAttributes().permissions();
            return permissions.contains((Object)PosixFilePermission.OTHERS_EXECUTE) || permissions.contains((Object)PosixFilePermission.OWNER_EXECUTE) || permissions.contains((Object)PosixFilePermission.GROUP_EXECUTE);
        }
        catch (IOException e) {
            throw new IllegalStateException("unable to read the file " + String.valueOf(file) + " attributes", e);
        }
    }

    @InputFiles
    @SkipWhenEmpty
    @IgnoreEmptyDirectories
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getFiles() {
        return (FileCollection)GradleUtils.getJavaSourceSets(this.getProject()).stream().map(sourceSet -> sourceSet.getAllSource().matching(this.filesFilter)).reduce(FileTree::plus).orElse(this.getProject().files(new Object[0]).getAsFileTree());
    }

    @TaskAction
    public void checkInvalidPermissions() throws IOException {
        if (Os.isFamily((String)"windows")) {
            throw new StopExecutionException();
        }
        List failures = this.getFiles().getFiles().stream().filter(FilePermissionsTask::isExecutableFile).map(file -> "Source file is executable: " + String.valueOf(file)).collect(Collectors.toList());
        if (!failures.isEmpty()) {
            throw new GradleException("Found invalid file permissions:\n" + String.join((CharSequence)"\n", failures));
        }
        this.outputMarker.getParentFile().mkdirs();
        Files.write(this.outputMarker.toPath(), "done".getBytes("UTF-8"), new OpenOption[0]);
    }

    @OutputFile
    public File getOutputMarker() {
        return this.outputMarker;
    }
}

