/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gradle.precommit;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Hex;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.opensearch.gradle.precommit.LicenseAnalyzer;

public class DependencyLicensesTask
extends DefaultTask {
    private final Pattern regex = Pattern.compile("-v?\\d+.*");
    private final Logger logger = Logging.getLogger(((Object)((Object)this)).getClass());
    private static final String SHA_EXTENSION = ".sha1";
    private FileCollection dependencies;
    private File licensesDir = new File(this.getProject().getProjectDir(), "licenses");
    private Map<String, String> mappings = new LinkedHashMap<String, String>();
    private Set<String> ignoreShas = new HashSet<String>();

    public void mapping(Map<String, String> props) {
        String from = props.remove("from");
        if (from == null) {
            throw new InvalidUserDataException("Missing \"from\" setting for license name mapping");
        }
        String to = props.remove("to");
        if (to == null) {
            throw new InvalidUserDataException("Missing \"to\" setting for license name mapping");
        }
        if (!props.isEmpty()) {
            throw new InvalidUserDataException("Unknown properties for mapping on dependencyLicenses: " + String.valueOf(props.keySet()));
        }
        this.mappings.put(from, to);
    }

    @InputFiles
    public FileCollection getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(FileCollection dependencies) {
        this.dependencies = dependencies;
    }

    @Optional
    @InputDirectory
    public File getLicensesDir() {
        if (this.licensesDir.exists()) {
            return this.licensesDir;
        }
        return null;
    }

    public void setLicensesDir(File licensesDir) {
        this.licensesDir = licensesDir;
    }

    public void ignoreSha(String dep) {
        this.ignoreShas.add(dep);
    }

    @TaskAction
    public void checkDependencies() throws IOException, NoSuchAlgorithmException {
        if (this.dependencies == null) {
            throw new GradleException("No dependencies variable defined.");
        }
        if (this.dependencies.isEmpty()) {
            if (this.licensesDir.exists()) {
                throw new GradleException("Licenses dir " + String.valueOf(this.licensesDir) + " exists, but there are no dependencies");
            }
            return;
        }
        if (!this.licensesDir.exists()) {
            Object deps = "";
            for (File file : this.dependencies) {
                deps = (String)deps + file.getName() + "\n";
            }
            throw new GradleException("Licences dir " + String.valueOf(this.licensesDir) + " does not exist, but there are dependencies: " + (String)deps);
        }
        HashMap<String, Boolean> licenses = new HashMap<String, Boolean>();
        HashMap<String, Boolean> notices = new HashMap<String, Boolean>();
        HashMap<String, Boolean> sources = new HashMap<String, Boolean>();
        HashSet<File> shaFiles = new HashSet<File>();
        for (File file : this.licensesDir.listFiles()) {
            String name = file.getName();
            if (name.endsWith(SHA_EXTENSION)) {
                shaFiles.add(file);
                continue;
            }
            if (name.endsWith("-LICENSE") || name.endsWith("-LICENSE.txt")) {
                licenses.put(name, false);
                continue;
            }
            if (name.contains("-NOTICE") || name.contains("-NOTICE.txt")) {
                notices.put(name, false);
                continue;
            }
            if (!name.contains("-SOURCES") && !name.contains("-SOURCES.txt")) continue;
            sources.put(name, false);
        }
        this.checkDependencies(licenses, notices, sources, shaFiles);
        licenses.forEach((item, exists) -> this.failIfAnyMissing((String)item, (Boolean)exists, "license"));
        notices.forEach((item, exists) -> this.failIfAnyMissing((String)item, (Boolean)exists, "notice"));
        sources.forEach((item, exists) -> this.failIfAnyMissing((String)item, (Boolean)exists, "sources"));
        if (!shaFiles.isEmpty()) {
            throw new GradleException("Unused sha files found: \n" + this.joinFilenames(shaFiles));
        }
    }

    @OutputDirectory
    public File getOutputMarker() {
        return new File(this.getProject().getBuildDir(), "dependencyLicense");
    }

    private void failIfAnyMissing(String item, Boolean exists, String type) {
        if (!exists.booleanValue()) {
            throw new GradleException("Unused " + type + " " + item);
        }
    }

    private void checkDependencies(Map<String, Boolean> licenses, Map<String, Boolean> notices, Map<String, Boolean> sources, Set<File> shaFiles) throws NoSuchAlgorithmException, IOException {
        for (File dependency : this.dependencies) {
            String jarName = dependency.getName();
            String depName = this.regex.matcher(jarName).replaceFirst("");
            this.validateSha(shaFiles, dependency, jarName, depName);
            String dependencyName = DependencyLicensesTask.getDependencyName(this.mappings, depName);
            this.logger.info("mapped dependency name {} to {} for license/notice check", (Object)depName, (Object)dependencyName);
            this.checkFile(dependencyName, jarName, licenses, "LICENSE");
            this.checkFile(dependencyName, jarName, notices, "NOTICE");
            File licenseFile = new File(this.licensesDir, this.getFileName(dependencyName, licenses, "LICENSE"));
            LicenseAnalyzer.LicenseInfo licenseInfo = LicenseAnalyzer.licenseType(licenseFile);
            if (!licenseInfo.isSourceRedistributionRequired()) continue;
            this.checkFile(dependencyName, jarName, sources, "SOURCES");
        }
    }

    private void validateSha(Set<File> shaFiles, File dependency, String jarName, String depName) throws NoSuchAlgorithmException, IOException {
        if (this.ignoreShas.contains(depName)) {
            if (this.getShaFile(jarName).exists()) {
                throw new GradleException("SHA file " + String.valueOf(this.getShaFile(jarName)) + " exists for ignored dependency " + depName);
            }
        } else {
            this.logger.info("Checking sha for {}", (Object)jarName);
            this.checkSha(dependency, jarName, shaFiles);
        }
    }

    private String joinFilenames(Set<File> shaFiles) {
        List names = shaFiles.stream().map(File::getName).collect(Collectors.toList());
        return String.join((CharSequence)"\n", names);
    }

    public static String getDependencyName(Map<String, String> mappings, String dependencyName) {
        ArrayList<String> mapped = new ArrayList<String>(mappings.values());
        Pattern mappingsPattern = Pattern.compile("(" + String.join((CharSequence)")|(", mappings.keySet()) + ")");
        Matcher match = mappingsPattern.matcher(dependencyName);
        if (match.matches()) {
            int i;
            for (i = 0; i < match.groupCount() && match.group(i + 1) == null; ++i) {
            }
            return (String)mapped.get(i);
        }
        return dependencyName;
    }

    private void checkSha(File jar, String jarName, Set<File> shaFiles) throws NoSuchAlgorithmException, IOException {
        String sha;
        File shaFile = this.getShaFile(jarName);
        if (!shaFile.exists()) {
            throw new GradleException("Missing SHA for " + jarName + ". Run \"gradle updateSHAs\" to create them");
        }
        byte[] fileBytes = Files.readAllBytes(shaFile.toPath());
        String expectedSha = new String(fileBytes, StandardCharsets.UTF_8).trim();
        if (!expectedSha.equals(sha = this.getSha1(jar))) {
            String exceptionMessage = String.format(Locale.ROOT, "SHA has changed! Expected %s for %s but got %s.\nThis usually indicates a corrupt dependency cache or artifacts changed upstream.\nEither wipe your cache, fix the upstream artifact, or delete %s and run updateShas", expectedSha, jarName, sha, shaFile);
            throw new GradleException(exceptionMessage);
        }
        shaFiles.remove(shaFile);
    }

    private void checkFile(String name, String jarName, Map<String, Boolean> counters, String type) {
        String fileName = this.getFileName(name, counters, type);
        if (!counters.containsKey(fileName)) {
            throw new GradleException("Missing " + type + " for " + jarName + ", expected in " + fileName);
        }
        counters.put(fileName, true);
    }

    private String getFileName(String name, Map<String, ?> counters, String type) {
        String fileName = name + "-" + type;
        if (!counters.containsKey(fileName)) {
            return fileName + ".txt";
        }
        return fileName;
    }

    @Input
    public LinkedHashMap<String, String> getMappings() {
        return new LinkedHashMap<String, String>(this.mappings);
    }

    File getShaFile(String jarName) {
        return new File(this.licensesDir, jarName + SHA_EXTENSION);
    }

    @Internal
    Set<File> getShaFiles() {
        File[] array = this.licensesDir.listFiles();
        if (array == null) {
            throw new GradleException("\"" + this.licensesDir.getPath() + "\" isn't a valid directory");
        }
        return Arrays.stream(array).filter(file -> file.getName().endsWith(SHA_EXTENSION)).collect(Collectors.toSet());
    }

    String getSha1(File file) throws IOException, NoSuchAlgorithmException {
        byte[] bytes = Files.readAllBytes(file.toPath());
        MessageDigest digest = MessageDigest.getInstance("SHA-1");
        char[] encoded = Hex.encodeHex((byte[])digest.digest(bytes));
        return String.copyValueOf(encoded);
    }
}

