/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gradle;

import org.gradle.api.GradleException;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.IvyArtifactRepository;
import org.gradle.api.artifacts.type.ArtifactTypeDefinition;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.internal.artifacts.ArtifactAttributes;
import org.opensearch.gradle.Jre;
import org.opensearch.gradle.transform.SymbolicLinkPreservingUntarTransform;
import org.opensearch.gradle.transform.UnzipTransform;

public class JreDownloadPlugin
implements Plugin<Project> {
    public static final String VENDOR_ADOPTIUM = "adoptium";
    private static final String REPO_NAME_PREFIX = "jre_repo_";
    private static final String EXTENSION_NAME = "jres";
    public static final String JRE_TRIMMED_PREFIX = "jdk-?\\d.*-jre";

    public void apply(Project project) {
        Attribute jreAttribute = Attribute.of((String)"jre", Boolean.class);
        project.getDependencies().getAttributesSchema().attribute(jreAttribute);
        project.getDependencies().getArtifactTypes().maybeCreate("zip");
        project.getDependencies().registerTransform(UnzipTransform.class, transformSpec -> {
            transformSpec.getFrom().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)"zip").attribute(jreAttribute, (Object)true);
            transformSpec.getTo().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)"directory").attribute(jreAttribute, (Object)true);
            transformSpec.parameters(parameters -> parameters.setTrimmedPrefixPattern(JRE_TRIMMED_PREFIX));
        });
        ArtifactTypeDefinition tarArtifactTypeDefinition = (ArtifactTypeDefinition)project.getDependencies().getArtifactTypes().maybeCreate("tar.gz");
        project.getDependencies().registerTransform(SymbolicLinkPreservingUntarTransform.class, transformSpec -> {
            transformSpec.getFrom().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)tarArtifactTypeDefinition.getName()).attribute(jreAttribute, (Object)true);
            transformSpec.getTo().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)"directory").attribute(jreAttribute, (Object)true);
            transformSpec.parameters(parameters -> parameters.setTrimmedPrefixPattern(JRE_TRIMMED_PREFIX));
        });
        NamedDomainObjectContainer jresContainer = project.container(Jre.class, name -> {
            Configuration configuration = (Configuration)project.getConfigurations().create("jre_" + name);
            configuration.setCanBeConsumed(false);
            configuration.getAttributes().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)"directory");
            configuration.getAttributes().attribute(jreAttribute, (Object)true);
            Jre jre = new Jre(name, configuration, project.getObjects());
            configuration.defaultDependencies(dependencies -> {
                jre.finalizeValues();
                this.setupRepository(project, jre);
                dependencies.add((Object)project.getDependencies().create((Object)JreDownloadPlugin.dependencyNotation(jre)));
            });
            return jre;
        });
        project.getExtensions().add(EXTENSION_NAME, (Object)jresContainer);
    }

    private void setupRepository(Project project, Jre jre) {
        String artifactPattern;
        String repoUrl;
        RepositoryHandler repositories = project.getRepositories();
        String repoName = REPO_NAME_PREFIX + jre.getVendor() + "_" + jre.getVersion();
        if (jre.getVendor().equals(VENDOR_ADOPTIUM)) {
            repoUrl = "https://github.com/adoptium/temurin" + jre.getMajor() + "-binaries/releases/download/";
            artifactPattern = jre.getMajor().equals("8") ? "jdk" + jre.getBaseVersion() + "-" + jre.getBuild() + "/OpenJDK" + jre.getMajor() + "U-jre_[classifier]_[module]_hotspot_" + jre.getBaseVersion() + jre.getBuild() + ".[ext]" : "jdk-" + jre.getBaseVersion() + "+" + jre.getBuild() + "/OpenJDK" + jre.getMajor() + (jre.getBaseVersion().contains(".") || jre.getBaseVersion().matches("^2\\d+$") ? "U" : "") + "-jre_[classifier]_[module]_hotspot_" + jre.getBaseVersion() + "_" + jre.getBuild() + ".[ext]";
        } else {
            throw new GradleException("Unknown JDK vendor [" + jre.getVendor() + "]");
        }
        if (repositories.findByName(repoName) == null) {
            repositories.ivy(repo -> {
                repo.setName(repoName);
                repo.setUrl((Object)repoUrl);
                repo.metadataSources(IvyArtifactRepository.MetadataSources::artifact);
                repo.patternLayout(layout -> layout.artifact(artifactPattern));
                repo.content(repositoryContentDescriptor -> repositoryContentDescriptor.includeGroup(JreDownloadPlugin.groupName(jre)));
            });
        }
    }

    public static NamedDomainObjectContainer<Jre> getContainer(Project project) {
        return (NamedDomainObjectContainer)project.getExtensions().getByName(EXTENSION_NAME);
    }

    private static String dependencyNotation(Jre jre) {
        String platformDep = jre.getPlatform().equals("darwin") || jre.getPlatform().equals("mac") ? "mac" : jre.getPlatform();
        String extension = jre.getPlatform().equals("windows") ? "zip" : "tar.gz";
        return JreDownloadPlugin.groupName(jre) + ":" + platformDep + ":" + jre.getBaseVersion() + ":" + jre.getArchitecture() + "@" + extension;
    }

    private static String groupName(Jre jre) {
        return jre.getVendor() + "_" + jre.getMajor() + "_jre";
    }
}

