/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gradle.vagrant;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.TaskAction;
import org.opensearch.gradle.vagrant.VagrantExtension;
import org.opensearch.gradle.vagrant.VagrantMachine;

public abstract class VagrantShellTask
extends DefaultTask {
    private final VagrantExtension extension;
    private final VagrantMachine service;
    private UnaryOperator<String> progressHandler = UnaryOperator.identity();

    public VagrantShellTask() {
        this.extension = (VagrantExtension)this.getProject().getExtensions().findByType(VagrantExtension.class);
        if (this.extension == null) {
            throw new IllegalStateException("opensearch.vagrant-base must be applied to create " + ((Object)((Object)this)).getClass().getName());
        }
        this.service = (VagrantMachine)this.getProject().getExtensions().getByType(VagrantMachine.class);
    }

    @Input
    protected abstract List<String> getWindowsScript();

    @Input
    protected abstract List<String> getLinuxScript();

    @Input
    public UnaryOperator<String> getProgressHandler() {
        return this.progressHandler;
    }

    public void setProgressHandler(UnaryOperator<String> progressHandler) {
        this.progressHandler = progressHandler;
    }

    @TaskAction
    public void runScript() {
        String rootDir = this.getProject().getRootDir().toString();
        if (this.extension.isWindowsVM()) {
            this.service.execute((Action<VagrantMachine.VagrantExecSpec>)((Action)spec -> {
                spec.setCommand("winrm");
                ArrayList<Object> script = new ArrayList<Object>();
                script.add("try {");
                script.add("cd " + VagrantMachine.convertWindowsPath(this.getProject(), rootDir));
                this.extension.getVmEnv().forEach((k, v) -> script.add("$Env:" + k + " = \"" + v + "\""));
                script.addAll(this.getWindowsScript().stream().map(s -> "    " + s).collect(Collectors.toList()));
                script.addAll(Arrays.asList("    exit $LASTEXITCODE", "} catch {", "    echo $_.Exception.Message", "    exit 1", "}"));
                spec.setArgs("--elevated", "--command", String.join((CharSequence)"\n", script));
                spec.setProgressHandler(this.progressHandler);
            }));
        } else {
            this.service.execute((Action<VagrantMachine.VagrantExecSpec>)((Action)spec -> {
                spec.setCommand("ssh");
                ArrayList<Object> script = new ArrayList<Object>();
                script.add("sudo bash -c '");
                script.add("pwd");
                script.add("cd " + VagrantMachine.convertLinuxPath(this.getProject(), rootDir));
                this.extension.getVmEnv().forEach((k, v) -> script.add("export " + k + "=" + v));
                script.addAll(this.getLinuxScript());
                script.add("'");
                spec.setArgs("--command", String.join((CharSequence)"\n", script));
                spec.setProgressHandler(this.progressHandler);
            }));
        }
    }
}

