/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gradle.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.UnknownTaskException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceRegistration;
import org.gradle.api.services.BuildServiceRegistry;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.testing.Test;
import org.gradle.plugins.ide.eclipse.model.EclipseModel;
import org.gradle.plugins.ide.idea.model.IdeaModel;
import org.opensearch.gradle.OpenSearchJavaPlugin;

public abstract class GradleUtils {
    public static <T> Action<T> noop() {
        return t -> {};
    }

    public static SourceSetContainer getJavaSourceSets(Project project) {
        return ((JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class)).getSourceSets();
    }

    public static <T extends Task> TaskProvider<T> maybeRegister(TaskContainer tasks, String name, Class<T> clazz, Action<T> action) {
        try {
            return tasks.named(name, clazz);
        }
        catch (UnknownTaskException e) {
            return tasks.register(name, clazz, action);
        }
    }

    public static void maybeConfigure(TaskContainer tasks, String name, Action<? super Task> config) {
        TaskProvider task;
        try {
            task = tasks.named(name);
        }
        catch (UnknownTaskException e) {
            return;
        }
        task.configure(config);
    }

    public static <T extends Task> void maybeConfigure(TaskContainer tasks, String name, Class<? extends T> type, Action<? super T> config) {
        tasks.withType(type).configureEach(task -> {
            if (task.getName().equals(name)) {
                config.execute(task);
            }
        });
    }

    public static TaskProvider<?> findByName(TaskContainer tasks, String name) {
        TaskProvider task;
        try {
            task = tasks.named(name);
        }
        catch (UnknownTaskException e) {
            return null;
        }
        return task;
    }

    public static <T extends BuildService<?>> Provider<T> getBuildService(BuildServiceRegistry registry, String name) {
        BuildServiceRegistration registration = (BuildServiceRegistration)registry.getRegistrations().findByName(name);
        if (registration == null) {
            throw new GradleException("Unable to find build service with name '" + name + "'.");
        }
        return registration.getService();
    }

    public static TaskProvider<?> addTestSourceSet(Project project, String sourceSetName) {
        project.getPluginManager().apply(OpenSearchJavaPlugin.class);
        SourceSetContainer sourceSets = (SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class);
        SourceSet testSourceSet = (SourceSet)sourceSets.create(sourceSetName);
        TaskProvider testTask = project.getTasks().register(sourceSetName, Test.class);
        testTask.configure(task -> {
            task.setGroup("verification");
            task.setTestClassesDirs(testSourceSet.getOutput().getClassesDirs());
            task.setClasspath(testSourceSet.getRuntimeClasspath());
            task.mustRunAfter(new Object[]{project.getTasks().named("test")});
        });
        Configuration testCompileConfig = project.getConfigurations().getByName(testSourceSet.getCompileClasspathConfigurationName());
        Configuration testRuntimeConfig = project.getConfigurations().getByName(testSourceSet.getRuntimeClasspathConfigurationName());
        testSourceSet.setCompileClasspath((FileCollection)testCompileConfig);
        testSourceSet.setRuntimeClasspath((FileCollection)project.getObjects().fileCollection().from(new Object[]{testSourceSet.getOutput(), testRuntimeConfig}));
        GradleUtils.extendSourceSet(project, "main", sourceSetName);
        GradleUtils.setupIdeForTestSourceSet(project, testSourceSet);
        project.getTasks().named("check").configure(check -> check.dependsOn(new Object[]{testTask}));
        return testTask;
    }

    public static void setupIdeForTestSourceSet(Project project, SourceSet testSourceSet) {
        String runtimeClasspathName = testSourceSet.getRuntimeClasspathConfigurationName();
        final Configuration runtimeClasspathConfiguration = project.getConfigurations().getByName(runtimeClasspathName);
        project.getPluginManager().withPlugin("idea", p -> {
            IdeaModel idea = (IdeaModel)project.getExtensions().getByType(IdeaModel.class);
            idea.getModule().setTestSourceDirs(testSourceSet.getJava().getSrcDirs());
            idea.getModule().getScopes().put(testSourceSet.getName(), new HashMap<String, Collection<Configuration>>(){
                {
                    this.put("plus", Arrays.asList(runtimeClasspathConfiguration));
                }
            });
        });
        project.getPluginManager().withPlugin("eclipse", p -> {
            EclipseModel eclipse = (EclipseModel)project.getExtensions().getByType(EclipseModel.class);
            ArrayList<SourceSet> eclipseSourceSets = new ArrayList<SourceSet>();
            for (SourceSet old : eclipse.getClasspath().getSourceSets()) {
                eclipseSourceSets.add(old);
            }
            eclipseSourceSets.add(testSourceSet);
            eclipse.getClasspath().setSourceSets((Iterable)project.getExtensions().getByType(SourceSetContainer.class));
            eclipse.getClasspath().getPlusConfigurations().add(runtimeClasspathConfiguration);
        });
    }

    public static void extendSourceSet(Project project, String parentSourceSetName, String childSourceSetName) {
        List<Function> configNameFunctions = Arrays.asList(SourceSet::getCompileClasspathConfigurationName, SourceSet::getImplementationConfigurationName, SourceSet::getRuntimeClasspathConfigurationName, SourceSet::getRuntimeOnlyConfigurationName);
        SourceSetContainer sourceSets = (SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class);
        SourceSet parent = (SourceSet)sourceSets.getByName(parentSourceSetName);
        SourceSet child = (SourceSet)sourceSets.getByName(childSourceSetName);
        for (Function configNameFunction : configNameFunctions) {
            String parentConfigName = (String)configNameFunction.apply(parent);
            String childConfigName = (String)configNameFunction.apply(child);
            Configuration parentConfig = project.getConfigurations().getByName(parentConfigName);
            Configuration childConfig = project.getConfigurations().getByName(childConfigName);
            childConfig.extendsFrom(new Configuration[]{parentConfig});
        }
        child.setCompileClasspath((FileCollection)project.getObjects().fileCollection().from(new Object[]{child.getCompileClasspath(), parent.getOutput()}));
        child.setRuntimeClasspath((FileCollection)project.getObjects().fileCollection().from(new Object[]{child.getRuntimeClasspath(), parent.getOutput()}));
    }

    public static void extendSourceSet(Project project, String parentSourceSetName, String childSourceSetName, Test test) {
        GradleUtils.extendSourceSet(project, parentSourceSetName, childSourceSetName);
        if (test != null) {
            SourceSetContainer sourceSets = (SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class);
            SourceSet child = (SourceSet)sourceSets.getByName(childSourceSetName);
            test.setClasspath(child.getRuntimeClasspath());
        }
    }

    public static Dependency projectDependency(Project project, String projectPath, String projectConfig) {
        if (project.findProject(projectPath) == null) {
            throw new GradleException("no project [" + projectPath + "], project names: " + project.getRootProject().getAllprojects());
        }
        HashMap<String, String> depConfig = new HashMap<String, String>();
        depConfig.put("path", projectPath);
        depConfig.put("configuration", projectConfig);
        return project.getDependencies().project(depConfig);
    }

    public static String getProjectPathFromTask(String taskPath) {
        int lastDelimiterIndex = taskPath.lastIndexOf(":");
        return lastDelimiterIndex == 0 ? ":" : taskPath.substring(0, lastDelimiterIndex);
    }
}

