/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gradle.testclusters;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.gradle.api.GradleException;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import org.opensearch.gradle.testclusters.DefaultTestClustersTask;
import org.opensearch.gradle.testclusters.OpenSearchCluster;
import org.opensearch.gradle.testclusters.OpenSearchNode;

public class RunTask
extends DefaultTestClustersTask {
    private static final Logger logger = Logging.getLogger(RunTask.class);
    public static final String CUSTOM_SETTINGS_PREFIX = "tests.opensearch.";
    private static final int DEFAULT_HTTP_PORT = 9200;
    private static final int DEFAULT_TRANSPORT_PORT = 9300;
    private static final int DEFAULT_DEBUG_PORT = 5005;
    public static final String LOCALHOST_ADDRESS_PREFIX = "127.0.0.1:";
    private Boolean debug = false;
    private Boolean debugServer = false;
    private Boolean preserveData = false;
    private Path dataDir = null;
    private String keystorePassword = "";

    @Option(option="debug-jvm", description="Run OpenSearch as a debug client, where it will try to connect to a debugging server at startup.")
    public void setDebug(boolean enabled) {
        if (this.debugServer != null && this.debugServer.booleanValue()) {
            throw new IllegalStateException("Either --debug-jvm or --debug-server-jvm option should be specified (but not both)");
        }
        this.debug = enabled;
    }

    @Option(option="debug-server-jvm", description="Run OpenSearch as a debug server that will accept connections from a debugging client.")
    public void setDebugServer(boolean enabled) {
        if (this.debug != null && this.debug.booleanValue()) {
            throw new IllegalStateException("Either --debug-jvm or --debug-server-jvm option should be specified (but not both)");
        }
        this.debugServer = enabled;
    }

    @Input
    public Boolean getDebug() {
        return this.debug;
    }

    @Input
    public Boolean getDebugServer() {
        return this.debugServer;
    }

    @Option(option="data-dir", description="Override the base data directory used by the testcluster")
    public void setDataDir(String dataDirStr) {
        this.dataDir = Paths.get(dataDirStr, new String[0]).toAbsolutePath();
    }

    @Input
    public Boolean getPreserveData() {
        return this.preserveData;
    }

    @Option(option="preserve-data", description="Preserves data directory contents (path provided to --data-dir is always preserved)")
    public void setPreserveData(Boolean preserveData) {
        this.preserveData = preserveData;
    }

    @Option(option="keystore-password", description="Set the opensearch keystore password")
    public void setKeystorePassword(String password) {
        this.keystorePassword = password;
    }

    @Input
    @Optional
    public String getKeystorePassword() {
        return this.keystorePassword;
    }

    @Input
    @Optional
    public String getDataDir() {
        if (this.dataDir == null) {
            return null;
        }
        return this.dataDir.toString();
    }

    @Override
    public void beforeStart() {
        int debugPort = 5005;
        int httpPort = 9200;
        int transportPort = 9300;
        Map<String, String> additionalSettings = System.getProperties().entrySet().stream().filter(entry -> entry.getKey().toString().startsWith(CUSTOM_SETTINGS_PREFIX)).collect(Collectors.toMap(entry -> entry.getKey().toString().substring(CUSTOM_SETTINGS_PREFIX.length()), entry -> entry.getValue().toString()));
        boolean singleNode = this.getClusters().stream().flatMap(c -> c.getNodes().stream()).count() == 1L;
        Function<OpenSearchNode, Path> getDataPath = singleNode ? n -> this.dataDir : n -> this.dataDir.resolve(n.getName());
        for (OpenSearchCluster cluster : this.getClusters()) {
            OpenSearchNode firstNode = cluster.getFirstNode();
            firstNode.setHttpPort(String.valueOf(httpPort));
            ++httpPort;
            firstNode.setTransportPort(String.valueOf(transportPort));
            ++transportPort;
            firstNode.setting("discovery.seed_hosts", "127.0.0.1:9300");
            cluster.setPreserveDataDir(this.preserveData);
            for (OpenSearchNode node : cluster.getNodes()) {
                if (node != firstNode) {
                    node.setHttpPort(String.valueOf(httpPort));
                    ++httpPort;
                    node.setTransportPort(String.valueOf(transportPort));
                    ++transportPort;
                    node.setting("discovery.seed_hosts", "127.0.0.1:9300");
                }
                additionalSettings.forEach(node::setting);
                if (this.dataDir != null) {
                    node.setDataPath(getDataPath.apply(node));
                }
                if (this.debug.booleanValue()) {
                    logger.lifecycle("Running opensearch in debug mode (client), {} expecting running debug server on port {}", new Object[]{node, debugPort});
                    node.jvmArgs("-agentlib:jdwp=transport=dt_socket,server=n,suspend=y,address=" + debugPort);
                    ++debugPort;
                } else if (this.debugServer.booleanValue()) {
                    logger.lifecycle("Running opensearch in debug mode (server), {} running server with debug port {}", new Object[]{node, debugPort});
                    node.jvmArgs("-agentlib:jdwp=transport=dt_socket,server=y,suspend=n,address=" + debugPort);
                    ++debugPort;
                }
                if (this.keystorePassword.length() <= 0) continue;
                node.keystorePassword(this.keystorePassword);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public void runAndWait() throws IOException {
        ArrayList<BufferedReader> toRead = new ArrayList<BufferedReader>();
        ArrayList<BooleanSupplier> aliveChecks = new ArrayList<BooleanSupplier>();
        try {
            for (OpenSearchCluster openSearchCluster : this.getClusters()) {
                for (Object node : openSearchCluster.getNodes()) {
                    BufferedReader reader = Files.newBufferedReader(((OpenSearchNode)node).getOpensearchStdoutFile());
                    toRead.add(reader);
                    aliveChecks.add(((OpenSearchNode)node)::isProcessAlive);
                }
            }
            while (!Thread.currentThread().isInterrupted()) {
                boolean readData = false;
                for (BufferedReader bufferedReader : toRead) {
                    if (!bufferedReader.ready()) continue;
                    readData = true;
                    logger.lifecycle(bufferedReader.readLine());
                }
                if (!aliveChecks.stream().allMatch(BooleanSupplier::getAsBoolean)) {
                    throw new GradleException("OpenSearch cluster died");
                }
                if (readData) continue;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    Exception thrown = null;
                    for (Closeable closeable : toRead) {
                        try {
                            closeable.close();
                        }
                        catch (Exception e) {
                            if (thrown == null) {
                                thrown = e;
                                continue;
                            }
                            thrown.addSuppressed(e);
                        }
                    }
                    if (thrown != null) {
                        logger.debug("exception occurred during close of stdout file readers", thrown);
                    }
                    return;
                }
            }
        }
        finally {
            Exception thrown = null;
            for (Closeable closeable : toRead) {
                try {
                    closeable.close();
                }
                catch (Exception e) {
                    if (thrown == null) {
                        thrown = e;
                        continue;
                    }
                    thrown.addSuppressed(e);
                }
            }
            if (thrown != null) {
                logger.debug("exception occurred during close of stdout file readers", thrown);
            }
        }
    }
}

