/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gradle.precommit;

import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.testing.Test;
import org.opensearch.gradle.util.GradleUtils;

public class PrecommitTaskPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        TaskProvider precommit = project.getTasks().register("precommit", t -> {
            t.setGroup("verification");
            t.setDescription("Runs all non-test checks");
        });
        project.getPluginManager().withPlugin("lifecycle-base", p -> project.getTasks().named("check").configure(t -> t.dependsOn(new Object[]{precommit})));
        project.getPluginManager().withPlugin("java", p -> {
            for (SourceSet sourceSet : GradleUtils.getJavaSourceSets(project)) {
                precommit.configure(t -> t.dependsOn(new Object[]{sourceSet.getClassesTaskName()}));
            }
            project.getTasks().withType(Test.class).configureEach(t -> t.mustRunAfter(new Object[]{precommit}));
        });
    }
}

