/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gradle.precommit;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.tasks.IgnoreEmptyDirectories;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;

public class ForbiddenPatternsTask
extends DefaultTask {
    private final PatternFilterable filesFilter = new PatternSet().include(new String[]{"**"}).exclude(new String[]{"**/*.gz"}).exclude(new String[]{"**/*.ico"}).exclude(new String[]{"**/*.jar"}).exclude(new String[]{"**/*.zip"}).exclude(new String[]{"**/*.jks"}).exclude(new String[]{"**/*.crt"}).exclude(new String[]{"**/*.keystore"}).exclude(new String[]{"**/*.png"});
    private final Map<String, String> patterns = new HashMap<String, String>();

    public ForbiddenPatternsTask() {
        this.setDescription("Checks source files for invalid patterns like nocommits or tabs");
        this.getInputs().property("excludes", (Object)this.filesFilter.getExcludes());
        this.getInputs().property("rules", this.patterns);
        this.patterns.put("nocommit", "nocommit|NOCOMMIT");
        this.patterns.put("nocommit should be all lowercase or all uppercase", "((?i)nocommit)(?<!(nocommit|NOCOMMIT))");
        this.patterns.put("tab", "\t");
    }

    @InputFiles
    @SkipWhenEmpty
    @IgnoreEmptyDirectories
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getFiles() {
        return (FileCollection)((JavaPluginExtension)this.getProject().getExtensions().getByType(JavaPluginExtension.class)).getSourceSets().stream().map(sourceSet -> sourceSet.getAllSource().matching(this.filesFilter)).reduce(FileTree::plus).orElse(this.getProject().files(new Object[0]).getAsFileTree());
    }

    @TaskAction
    public void checkInvalidPatterns() throws IOException {
        Pattern allPatterns = Pattern.compile("(" + String.join((CharSequence)")|(", this.getPatterns().values()) + ")");
        ArrayList failures = new ArrayList();
        for (File f : this.getFiles()) {
            List lines;
            try (Stream<String> stream = Files.lines(f.toPath(), StandardCharsets.UTF_8);){
                lines = stream.collect(Collectors.toList());
            }
            catch (UncheckedIOException e) {
                throw new IllegalArgumentException("Failed to read " + f + " as UTF_8", e);
            }
            List invalidLines = IntStream.range(0, lines.size()).filter(i -> allPatterns.matcher((CharSequence)lines.get(i)).find()).boxed().collect(Collectors.toList());
            String path = this.getProject().getRootProject().getProjectDir().toURI().relativize(f.toURI()).toString();
            failures.addAll(invalidLines.stream().map(l -> new AbstractMap.SimpleEntry<Integer, String>(l + 1, (String)lines.get((int)l))).flatMap(kv -> this.patterns.entrySet().stream().filter(p -> Pattern.compile((String)p.getValue()).matcher((CharSequence)kv.getValue()).find()).map(p -> "- " + (String)p.getKey() + " on line " + kv.getKey() + " of " + path)).collect(Collectors.toList()));
        }
        if (!failures.isEmpty()) {
            throw new GradleException("Found invalid patterns:\n" + String.join((CharSequence)"\n", failures));
        }
        File outputMarker = this.getOutputMarker();
        outputMarker.getParentFile().mkdirs();
        Files.write(outputMarker.toPath(), "done".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    @OutputFile
    public File getOutputMarker() {
        return new File(this.getProject().getBuildDir(), "markers/" + this.getName());
    }

    @Input
    public Map<String, String> getPatterns() {
        return Collections.unmodifiableMap(this.patterns);
    }

    public void exclude(String ... excludes) {
        this.filesFilter.exclude(excludes);
    }

    public void rule(Map<String, String> props) {
        String name = props.remove("name");
        if (name == null) {
            throw new InvalidUserDataException("Missing [name] for invalid pattern rule");
        }
        String pattern = props.remove("pattern");
        if (pattern == null) {
            throw new InvalidUserDataException("Missing [pattern] for invalid pattern rule");
        }
        if (!props.isEmpty()) {
            throw new InvalidUserDataException("Unknown arguments for ForbiddenPatterns rule mapping: " + props.keySet().toString());
        }
        this.patterns.put(name, pattern);
    }
}

