/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gradle.http;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

public class WaitForHttpResource {
    private static final Logger logger = Logging.getLogger(WaitForHttpResource.class);
    private Set<Integer> validResponseCodes = Collections.singleton(200);
    private URL url;
    private Set<File> certificateAuthorities;
    private File trustStoreFile;
    private String trustStorePassword;
    private String username;
    private String password;

    public WaitForHttpResource(String protocol, String host, int numberOfNodes) throws MalformedURLException {
        this(new URL(protocol + "://" + host + "/_cluster/health?wait_for_nodes=>=" + numberOfNodes + "&wait_for_status=yellow"));
    }

    public WaitForHttpResource(String protocol, String host, String username, String password, int numberOfNodes) throws MalformedURLException {
        this(new URL(protocol + "://" + username + ":" + password + "@" + host + "/_cluster/health?wait_for_nodes=>=" + numberOfNodes + "&wait_for_status=yellow"));
    }

    public WaitForHttpResource(URL url) {
        this.url = url;
    }

    public void setValidResponseCodes(int ... validResponseCodes) {
        this.validResponseCodes = new HashSet<Integer>(validResponseCodes.length);
        for (int rc : validResponseCodes) {
            this.validResponseCodes.add(rc);
        }
    }

    public void setCertificateAuthorities(File ... certificateAuthorities) {
        this.certificateAuthorities = new HashSet<File>(Arrays.asList(certificateAuthorities));
    }

    public void setTrustStoreFile(File trustStoreFile) {
        this.trustStoreFile = trustStoreFile;
    }

    public void setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean wait(int durationInMs) throws GeneralSecurityException, InterruptedException, IOException {
        long waitUntil = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(durationInMs);
        long sleep = Long.max(durationInMs / 10, 100L);
        KeyStore trustStore = this.buildTrustStore();
        SSLContext ssl = trustStore != null ? this.createSslContext(trustStore) : null;
        IOException failure = null;
        while (true) {
            try {
                this.checkResource(ssl);
                return true;
            }
            catch (IOException e) {
                logger.debug("Failed to access resource [{}]", (Object)this.url, (Object)e);
                failure = e;
                if (System.nanoTime() < waitUntil) {
                    Thread.sleep(sleep);
                    continue;
                }
                throw failure;
            }
            break;
        }
    }

    protected void checkResource(SSLContext ssl) throws IOException {
        HttpURLConnection connection = this.buildConnection(ssl);
        connection.connect();
        Integer response = connection.getResponseCode();
        if (this.validResponseCodes.contains(response)) {
            logger.info("Got successful response [{}] from URL [{}]", (Object)response, (Object)this.url);
            return;
        }
        throw new IOException(response + " " + connection.getResponseMessage());
    }

    HttpURLConnection buildConnection(SSLContext ssl) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)this.url.openConnection();
        this.configureSslContext(connection, ssl);
        this.configureBasicAuth(connection);
        connection.setRequestMethod("GET");
        return connection;
    }

    private void configureSslContext(HttpURLConnection connection, SSLContext ssl) {
        if (ssl != null) {
            if (connection instanceof HttpsURLConnection) {
                ((HttpsURLConnection)connection).setSSLSocketFactory(ssl.getSocketFactory());
            } else {
                throw new IllegalStateException("SSL trust has been configured, but [" + this.url + "] is not a 'https' URL");
            }
        }
    }

    private void configureBasicAuth(HttpURLConnection connection) {
        if (this.username != null) {
            if (this.password == null) {
                throw new IllegalStateException("Basic Auth user [" + this.username + "] has been set, but no password has been configured");
            }
            connection.setRequestProperty("Authorization", "Basic " + Base64.getEncoder().encodeToString((this.username + ":" + this.password).getBytes(StandardCharsets.UTF_8)));
        }
    }

    KeyStore buildTrustStore() throws GeneralSecurityException, IOException {
        if (this.certificateAuthorities != null) {
            if (this.trustStoreFile != null) {
                throw new IllegalStateException("Cannot specify both truststore and CAs");
            }
            return this.buildTrustStoreFromCA();
        }
        if (this.trustStoreFile != null) {
            return this.buildTrustStoreFromFile();
        }
        return null;
    }

    private KeyStore buildTrustStoreFromFile() throws GeneralSecurityException, IOException {
        KeyStore keyStore = KeyStore.getInstance(this.trustStoreFile.getName().endsWith(".jks") ? "JKS" : "PKCS12");
        try (FileInputStream input = new FileInputStream(this.trustStoreFile);){
            keyStore.load(input, this.trustStorePassword == null ? null : this.trustStorePassword.toCharArray());
        }
        return keyStore;
    }

    private KeyStore buildTrustStoreFromCA() throws GeneralSecurityException, IOException {
        KeyStore store = KeyStore.getInstance(KeyStore.getDefaultType());
        store.load(null, null);
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
        int counter = 0;
        for (File ca : this.certificateAuthorities) {
            try (FileInputStream input = new FileInputStream(ca);){
                for (Certificate certificate : certFactory.generateCertificates(input)) {
                    store.setCertificateEntry("cert-" + counter, certificate);
                    ++counter;
                }
            }
        }
        return store;
    }

    private SSLContext createSslContext(KeyStore trustStore) throws GeneralSecurityException {
        this.checkForTrustEntry(trustStore);
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(trustStore);
        SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
        sslContext.init(new KeyManager[0], tmf.getTrustManagers(), new SecureRandom());
        return sslContext;
    }

    private void checkForTrustEntry(KeyStore trustStore) throws KeyStoreException {
        Enumeration<String> enumeration = trustStore.aliases();
        while (enumeration.hasMoreElements()) {
            if (!trustStore.isCertificateEntry(enumeration.nextElement())) continue;
            return;
        }
        throw new IllegalStateException("Trust-store does not contain any trusted certificate entries");
    }
}

