/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gradle;

import java.net.MalformedURLException;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.artifacts.repositories.IvyArtifactRepository;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.opensearch.gradle.VersionProperties;

public class RepositoriesSetupPlugin
implements Plugin<Project> {
    private static final List<String> SECURE_URL_SCHEMES = Arrays.asList("file", "https", "s3");
    private static final Pattern LUCENE_SNAPSHOT_REGEX = Pattern.compile("\\w+-snapshot-([a-z0-9]+)");

    public void apply(Project project) {
        RepositoriesSetupPlugin.configureRepositories(project);
    }

    public static void configureRepositories(Project project) {
        project.getRepositories().all(repository -> {
            if (repository instanceof MavenArtifactRepository) {
                MavenArtifactRepository maven = (MavenArtifactRepository)repository;
                RepositoriesSetupPlugin.assertRepositoryURIIsSecure(maven.getName(), project.getPath(), maven.getUrl());
                for (URI uri : maven.getArtifactUrls()) {
                    RepositoriesSetupPlugin.assertRepositoryURIIsSecure(maven.getName(), project.getPath(), uri);
                }
            } else if (repository instanceof IvyArtifactRepository) {
                IvyArtifactRepository ivy = (IvyArtifactRepository)repository;
                RepositoriesSetupPlugin.assertRepositoryURIIsSecure(ivy.getName(), project.getPath(), ivy.getUrl());
            }
        });
        RepositoryHandler repos = project.getRepositories();
        if (System.getProperty("repos.mavenLocal") != null) {
            repos.mavenLocal();
        }
        repos.mavenCentral();
        String luceneVersion = VersionProperties.getLucene();
        if (luceneVersion.contains("-snapshot")) {
            Matcher matcher = LUCENE_SNAPSHOT_REGEX.matcher(luceneVersion);
            if (!matcher.find()) {
                throw new GradleException("Malformed lucene snapshot version: " + luceneVersion);
            }
            String revision = matcher.group(1);
            MavenArtifactRepository luceneRepo = repos.maven(repo -> {
                repo.setName("lucene-snapshots");
                repo.setUrl((Object)"https://d1nvenhzbhpy0q.cloudfront.net/snapshots/lucene/");
            });
            repos.exclusiveContent(exclusiveRepo -> {
                exclusiveRepo.filter(descriptor -> descriptor.includeVersionByRegex("org\\.apache\\.lucene", ".*", ".*-snapshot-" + revision));
                exclusiveRepo.forRepositories(new ArtifactRepository[]{luceneRepo});
            });
        }
    }

    private static void assertRepositoryURIIsSecure(String repositoryName, String projectPath, URI uri) {
        if (uri != null && !SECURE_URL_SCHEMES.contains(uri.getScheme())) {
            String url;
            try {
                url = uri.toURL().toString();
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException(e);
            }
            String message = String.format(Locale.ROOT, "repository [%s] on project with path [%s] is not using a secure protocol for artifacts on [%s]", repositoryName, projectPath, url);
            throw new GradleException(message);
        }
    }
}

