/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.structgen.stochastic.operator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openscience.cdk.graph.matrix.ConnectionMatrix;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.math.RandomNumbersTool;

public class ChemGraph {
    protected final int acount;
    protected int numAtoms;
    protected double[][] contab;
    protected int travIndex;
    protected boolean[] visited;
    protected List<Integer> subGraph;

    public ChemGraph(IAtomContainer chrom) {
        this.acount = chrom.getAtomCount();
        this.numAtoms = this.acount / 2;
        this.contab = new double[this.acount][this.acount];
        this.contab = ConnectionMatrix.getMatrix((IAtomContainer)chrom);
    }

    public List<Integer> pickDFgraph() {
        if (this.acount == 0) {
            return Collections.emptyList();
        }
        this.travIndex = 0;
        this.subGraph = new ArrayList<Integer>();
        this.visited = new boolean[this.acount];
        for (int atom = 0; atom < this.acount; ++atom) {
            this.visited[atom] = false;
        }
        int seedAtom = RandomNumbersTool.randomInt((int)0, (int)(this.acount - 1));
        this.recursiveDFT(seedAtom);
        return this.subGraph;
    }

    private void recursiveDFT(int atom) {
        if (this.travIndex < this.numAtoms && !this.visited[atom]) {
            this.subGraph.add(atom);
            ++this.travIndex;
            this.visited[atom] = true;
            ArrayList<Integer> adjSet = new ArrayList<Integer>();
            for (int nextAtom = 0; nextAtom < this.acount; ++nextAtom) {
                if ((int)this.contab[atom][nextAtom] == 0) continue;
                adjSet.add(nextAtom);
            }
            while (adjSet.size() > 0) {
                int adjIndex = RandomNumbersTool.randomInt((int)0, (int)(adjSet.size() - 1));
                this.recursiveDFT((Integer)adjSet.get(adjIndex));
                adjSet.remove(adjIndex);
            }
        }
    }

    public List<Integer> pickBFgraph() {
        if (this.acount == 0) {
            return Collections.emptyList();
        }
        this.travIndex = 0;
        this.subGraph = new ArrayList<Integer>();
        this.visited = new boolean[this.acount];
        for (int atom = 0; atom < this.acount; ++atom) {
            this.visited[atom] = false;
        }
        int seedAtom = RandomNumbersTool.randomInt((int)0, (int)(this.acount - 1));
        ArrayList<Integer> atomQueue = new ArrayList<Integer>();
        atomQueue.add(seedAtom);
        this.visited[seedAtom] = true;
        while (!atomQueue.isEmpty() && this.subGraph.size() < this.numAtoms) {
            int foreAtom = (Integer)atomQueue.get(0);
            this.subGraph.add(foreAtom);
            atomQueue.remove(0);
            ++this.travIndex;
            ArrayList<Integer> adjSet = new ArrayList<Integer>();
            for (int nextAtom = 0; nextAtom < this.acount; ++nextAtom) {
                if ((int)this.contab[foreAtom][nextAtom] == 0 || this.visited[nextAtom]) continue;
                adjSet.add(nextAtom);
            }
            while (adjSet.size() > 0) {
                int adjIndex = RandomNumbersTool.randomInt((int)0, (int)(adjSet.size() - 1));
                atomQueue.add((Integer)adjSet.get(adjIndex));
                this.visited[((Integer)adjSet.get((int)adjIndex)).intValue()] = true;
                adjSet.remove(adjIndex);
            }
        }
        return this.subGraph;
    }

    public List<Integer> getSubgraph() {
        return this.subGraph;
    }

    public void setSubgraph(List<Integer> subgraph) {
        this.subGraph = subgraph;
    }

    public int getNumAtoms() {
        return this.numAtoms;
    }

    public void setNumAtoms(int numatoms) {
        this.numAtoms = numatoms;
    }
}

