/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.structgen;

import org.openscience.cdk.graph.ConnectivityChecker;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.structgen.MathTools;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.BondManipulator;

public class RandomGenerator {
    final ILoggingTool logger = LoggingToolFactory.createLoggingTool(RandomGenerator.class);
    private IAtomContainer proposedStructure = null;
    private IAtomContainer molecule = null;
    private IAtomContainer trial = null;

    public RandomGenerator(IAtomContainer molecule) {
        this.setMolecule(molecule);
    }

    public IAtomContainer proposeStructure() {
        this.logger.debug((Object)"RandomGenerator->proposeStructure() Start");
        do {
            int f;
            try {
                this.trial = this.molecule.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new IllegalStateException("Could not clone IAtomContainer!" + e.getMessage());
            }
            this.mutate(this.trial);
            if (!this.logger.isDebugEnabled()) continue;
            String s = "BondCounts:    ";
            for (f = 0; f < this.trial.getAtomCount(); ++f) {
                s = s + this.trial.getConnectedBondsCount(this.trial.getAtom(f)) + " ";
            }
            this.logger.debug((Object)s);
            s = "BondOrderSums: ";
            for (f = 0; f < this.trial.getAtomCount(); ++f) {
                s = s + this.trial.getBondOrderSum(this.trial.getAtom(f)) + " ";
            }
            this.logger.debug((Object)s);
        } while (this.trial == null || !ConnectivityChecker.isConnected((IAtomContainer)this.trial));
        this.proposedStructure = this.trial;
        return this.proposedStructure;
    }

    public void acceptStructure() {
        if (this.proposedStructure != null) {
            this.molecule = this.proposedStructure;
        }
    }

    public void mutate(IAtomContainer ac) {
        double a22;
        IBond b4;
        double a21;
        IBond b3;
        double a12;
        IBond b2;
        double a11;
        IBond b1;
        IAtom ay2;
        IAtom ax2;
        IAtom ay1;
        IAtom ax1;
        this.logger.debug((Object)"RandomGenerator->mutate() Start");
        int nrOfAtoms = ac.getAtomCount();
        double b11 = 0.0;
        int[] choices = new int[3];
        while (true) {
            int y2;
            int y1;
            int x2;
            int x1;
            int nonZeroBondsCounter = 0;
            do {
                x1 = (int)(Math.random() * (double)nrOfAtoms);
                x2 = (int)(Math.random() * (double)nrOfAtoms);
                y1 = (int)(Math.random() * (double)nrOfAtoms);
                y2 = (int)(Math.random() * (double)nrOfAtoms);
                this.logger.debug((Object)("RandomGenerator->mutate(): x1, x2, y1, y2: " + x1 + ", " + x2 + ", " + y1 + ", " + y2));
            } while (x1 == x2 || x1 == y1 || x1 == y2 || x2 == y1 || x2 == y2 || y1 == y2);
            ax1 = ac.getAtom(x1);
            ay1 = ac.getAtom(y1);
            ax2 = ac.getAtom(x2);
            ay2 = ac.getAtom(y2);
            b1 = ac.getBond(ax1, ay1);
            if (b1 != null) {
                a11 = b1.getOrder().numeric().intValue();
                ++nonZeroBondsCounter;
            } else {
                a11 = 0.0;
            }
            b2 = ac.getBond(ax1, ay2);
            if (b2 != null) {
                a12 = b2.getOrder().numeric().intValue();
                ++nonZeroBondsCounter;
            } else {
                a12 = 0.0;
            }
            b3 = ac.getBond(ax2, ay1);
            if (b3 != null) {
                a21 = b3.getOrder().numeric().intValue();
                ++nonZeroBondsCounter;
            } else {
                a21 = 0.0;
            }
            b4 = ac.getBond(ax2, ay2);
            if (b4 != null) {
                a22 = b4.getOrder().numeric().intValue();
                ++nonZeroBondsCounter;
            } else {
                a22 = 0.0;
            }
            this.logger.debug((Object)("RandomGenerator->mutate()->The old bond orders: a11, a12, a21, a22: " + a11 + ", " + a12 + ", " + a21 + ", " + a22));
            if (nonZeroBondsCounter < 2) continue;
            double[] cmax = new double[]{0.0, a11 - a22, a11 + a12 - 3.0, a11 + a21 - 3.0};
            double[] cmin = new double[]{3.0, a11 + a12, a11 + a21, a11 - a22 + 3.0};
            double lowerborder = MathTools.max(cmax);
            double upperborder = MathTools.min(cmin);
            this.logger.debug((Object)"*** New Try ***");
            this.logger.debug((Object)"a11 = ", new Object[]{a11});
            this.logger.debug((Object)"upperborder = ", new Object[]{upperborder});
            this.logger.debug((Object)"lowerborder = ", new Object[]{lowerborder});
            int choiceCounter = 0;
            for (double f = lowerborder; f <= upperborder; f += 1.0) {
                if (f == a11) continue;
                choices[choiceCounter] = (int)f;
                ++choiceCounter;
            }
            if (choiceCounter > 0) {
                b11 = choices[(int)(Math.random() * (double)choiceCounter)];
            }
            this.logger.debug((Object)("b11 = " + b11));
            if (b11 != a11 && b11 >= lowerborder && b11 <= upperborder) break;
        }
        double b12 = a11 + a12 - b11;
        double b21 = a11 + a21 - b11;
        double b22 = a22 - a11 + b11;
        if (b11 > 0.0) {
            if (b1 == null) {
                b1 = (IBond)ac.getBuilder().newInstance(IBond.class, new Object[]{ax1, ay1, BondManipulator.createBondOrder((double)b11)});
                ac.addBond(b1);
            } else {
                b1.setOrder(BondManipulator.createBondOrder((double)b11));
            }
        } else if (b1 != null) {
            ac.removeBond(b1);
        }
        if (b12 > 0.0) {
            if (b2 == null) {
                b2 = (IBond)ac.getBuilder().newInstance(IBond.class, new Object[]{ax1, ay2, BondManipulator.createBondOrder((double)b12)});
                ac.addBond(b2);
            } else {
                b2.setOrder(BondManipulator.createBondOrder((double)b12));
            }
        } else if (b2 != null) {
            ac.removeBond(b2);
        }
        if (b21 > 0.0) {
            if (b3 == null) {
                b3 = (IBond)ac.getBuilder().newInstance(IBond.class, new Object[]{ax2, ay1, BondManipulator.createBondOrder((double)b21)});
                ac.addBond(b3);
            } else {
                b3.setOrder(BondManipulator.createBondOrder((double)b21));
            }
        } else if (b3 != null) {
            ac.removeBond(b3);
        }
        if (b22 > 0.0) {
            if (b4 == null) {
                b4 = (IBond)ac.getBuilder().newInstance(IBond.class, new Object[]{ax2, ay2, BondManipulator.createBondOrder((double)b22)});
                ac.addBond(b4);
            } else {
                b4.setOrder(BondManipulator.createBondOrder((double)b22));
            }
        } else if (b4 != null) {
            ac.removeBond(b4);
        }
        this.logger.debug((Object)("a11 a12 a21 a22: " + a11 + " " + a12 + " " + a21 + " " + a22));
        this.logger.debug((Object)("b11 b12 b21 b22: " + b11 + " " + b12 + " " + b21 + " " + b22));
    }

    public void setMolecule(IAtomContainer molecule) {
        this.molecule = molecule;
    }

    public IAtomContainer getMolecule() {
        return this.molecule;
    }
}

