/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.aromaticity;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.openscience.cdk.aromaticity.AromaticTypeModel;
import org.openscience.cdk.aromaticity.AtomTypeModel;
import org.openscience.cdk.aromaticity.ElectronDonation;
import org.openscience.cdk.aromaticity.PiBondModel;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.exception.Intractable;
import org.openscience.cdk.graph.CycleFinder;
import org.openscience.cdk.graph.Cycles;
import org.openscience.cdk.graph.GraphUtil;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.tools.LoggingToolFactory;

public final class Aromaticity {
    private static final int ALLOWED_STATE_COUNT = 0x100000;
    private final ElectronDonation model;
    private final CycleFinder cycles;
    private final boolean backtracking;
    private int maxRingSize;
    private static final Aromaticity CDK_LEGACY = new Aromaticity(ElectronDonation.cdk(), Cycles.cdkAromaticSet());

    public Aromaticity(ElectronDonation model, CycleFinder cycles) {
        this.model = Objects.requireNonNull(model);
        this.cycles = Objects.requireNonNull(cycles);
        if (this.cycles instanceof Enum && ((Enum)this.cycles).name().equals("ALL")) {
            this.backtracking = true;
        } else if (this.cycles.getClass().getName().equals("org.openscience.cdk.graph.Cycles$AllUpToLength")) {
            this.backtracking = true;
            try {
                Class<?> cls = this.cycles.getClass();
                Field fld = cls.getDeclaredField("predefinedLength");
                fld.setAccessible(true);
                this.maxRingSize = fld.getInt(this.cycles);
            }
            catch (Exception ex) {
                LoggingToolFactory.createLoggingTool(Aromaticity.class).error((Object)"Warning: could not access Cycles.all({length}) use aromaticity.applyAllCycles(,{length})");
            }
        } else {
            this.backtracking = false;
        }
    }

    private static boolean isFusionOrBridgeAtom(IAtom atom, int[] contrib) {
        if (atom.getBondCount() < 3 || contrib[atom.getIndex()] < 0) {
            return false;
        }
        int count = 0;
        for (IBond bond : atom.bonds()) {
            if (!bond.isInRing() || contrib[bond.getOther(atom).getIndex()] == -1) continue;
            ++count;
        }
        return count >= 3;
    }

    private static void pruneTerminalAromaticAtoms(int[] contrib, IAtom atom) {
        while (atom != null) {
            IAtom next = null;
            for (IBond bond : atom.bonds()) {
                IAtom nbor;
                if (!bond.isInRing() || contrib[(nbor = bond.getOther(atom)).getIndex()] == -1) continue;
                if (next != null) {
                    return;
                }
                next = nbor;
            }
            contrib[atom.getIndex()] = -1;
            atom = next;
        }
    }

    private static void pruneTerminalAromaticAtoms(int[] contrib, IAtomContainer mol) {
        for (IAtom atom : mol.atoms()) {
            if (contrib[atom.getIndex()] == -1) continue;
            Aromaticity.pruneTerminalAromaticAtoms(contrib, atom);
        }
    }

    private static void floodFill(int[] visit, IAtom atom, IBond prev, int label) {
        visit[atom.getIndex()] = label;
        for (IBond bond : atom.bonds()) {
            IAtom nbor;
            if (bond == prev || !bond.isInRing() || visit[(nbor = bond.getOther(atom)).getIndex()] != 0) continue;
            Aromaticity.floodFill(visit, nbor, bond, label);
        }
    }

    private static void makeAromatic(IBond bond) {
        bond.set(32);
        bond.getBegin().set(32);
        bond.getEnd().set(32);
    }

    private static void updateMolFlag(IAtomContainer molecule) {
        for (IAtom atom : molecule.atoms()) {
            if (!atom.getFlag(32)) continue;
            molecule.set(32);
            break;
        }
    }

    private static void processSimpleRings(IAtomContainer molecule, int[] visit, int[] contrib) {
        ArrayList<IBond> ring = new ArrayList<IBond>(molecule.getBondCount());
        for (IAtom atom : molecule.atoms()) {
            if (visit[atom.getIndex()] != 0) continue;
            ring.clear();
            int sum = 0;
            IBond prev = null;
            while (atom != null) {
                IAtom next = null;
                visit[atom.getIndex()] = 1;
                sum += contrib[atom.getIndex()];
                for (IBond bond : atom.bonds()) {
                    IAtom nbor;
                    if (bond == prev || !bond.isInRing() || visit[(nbor = bond.getOther(atom)).getIndex()] != 0) continue;
                    ring.add(bond);
                    prev = bond;
                    next = nbor;
                }
                atom = next;
            }
            if (!Aromaticity.checkHuckelSum(sum)) continue;
            for (IBond bond : ring) {
                Aromaticity.makeAromatic(bond);
            }
        }
    }

    public static boolean apply(ElectronDonation model, IAtomContainer molecule) {
        return Aromaticity.apply(model, molecule, Math.max(3, molecule.getAtomCount()));
    }

    public static boolean apply(ElectronDonation model, IAtomContainer molecule, int maxRingSize) {
        Aromaticity.clear(molecule);
        if (maxRingSize < 3) {
            throw new IllegalArgumentException("maxRingSize=" + maxRingSize + " <3 doesn't make sense");
        }
        int[] contrib = model.contribution(molecule);
        Aromaticity.pruneTerminalAromaticAtoms(contrib, molecule);
        int[] visit = new int[molecule.getAtomCount()];
        for (int i = 0; i < contrib.length; ++i) {
            if (contrib[i] >= 0) continue;
            visit[i] = 1;
        }
        ArrayList<IAtom> d3Atoms = new ArrayList<IAtom>();
        for (IAtom atom : molecule.atoms()) {
            if (!Aromaticity.isFusionOrBridgeAtom(atom, contrib)) continue;
            d3Atoms.add(atom);
            Aromaticity.floodFill(visit, atom, null, 2);
        }
        Aromaticity.processSimpleRings(molecule, visit, contrib);
        if (d3Atoms.isEmpty()) {
            return true;
        }
        for (int i = 0; i < visit.length; ++i) {
            if (visit[i] != 2) continue;
            visit[i] = 0;
        }
        AllCyclesState state = new AllCyclesState(visit, contrib);
        state.setMaxStates(0);
        if (maxRingSize > 6) {
            state.processComplexRings(d3Atoms, 6);
        }
        if (maxRingSize > 10) {
            state.processComplexRings(d3Atoms, 10);
        }
        state.setMaxStates(0x100000);
        state.processComplexRings(d3Atoms, maxRingSize);
        return !state.error;
    }

    public Set<IBond> findBonds(IAtomContainer molecule) throws CDKException {
        GraphUtil.EdgeToBondMap bondMap = GraphUtil.EdgeToBondMap.withSpaceFor((IAtomContainer)molecule);
        int[][] graph = GraphUtil.toAdjList((IAtomContainer)molecule, (GraphUtil.EdgeToBondMap)bondMap);
        Cycles.markRingAtomsAndBonds((IAtomContainer)molecule);
        int[] electrons = this.model.contribution(molecule);
        HashSet<IBond> bonds = new HashSet<IBond>(2 * molecule.getBondCount());
        int[] subset = Aromaticity.subset(electrons);
        int[][] subgraph = GraphUtil.subgraph((int[][])graph, (int[])subset);
        for (int[] cycle : this.cycles.find(molecule, subgraph, subgraph.length).paths()) {
            if (!Aromaticity.checkElectronSum(cycle, electrons, subset)) continue;
            for (int i = 1; i < cycle.length; ++i) {
                bonds.add(bondMap.get(subset[cycle[i]], subset[cycle[i - 1]]));
            }
        }
        return bonds;
    }

    public boolean apply(IAtomContainer molecule) throws CDKException {
        if (this.backtracking) {
            Cycles.markRingAtomsAndBonds((IAtomContainer)molecule);
            if (!Aromaticity.apply(this.model, molecule, this.maxRingSize == 0 ? Math.max(molecule.getAtomCount(), 3) : this.maxRingSize)) {
                throw new Intractable("Molecule is too complex to fully verify aromaticity of all bonds, smaller cycles are been marked");
            }
            Aromaticity.updateMolFlag(molecule);
        } else {
            Aromaticity.clear(molecule);
            Set<IBond> bonds = this.findBonds(molecule);
            for (IBond bond : bonds) {
                Aromaticity.makeAromatic(bond);
            }
            if (!bonds.isEmpty()) {
                molecule.set(32);
            }
        }
        return molecule.getFlag(32);
    }

    private static boolean checkElectronSum(int[] cycle, int[] contributions, int[] subset) {
        return Aromaticity.checkHuckelSum(Aromaticity.electronSum(cycle, contributions, subset));
    }

    static int electronSum(int[] cycle, int[] contributions, int[] subset) {
        int sum = 0;
        for (int i = 1; i < cycle.length; ++i) {
            sum += contributions[subset[cycle[i]]];
        }
        return sum;
    }

    static boolean checkHuckelSum(int sum) {
        return (sum - 2) % 4 == 0;
    }

    private static int[] subset(int[] electrons) {
        int[] vs = new int[electrons.length];
        int n = 0;
        for (int i = 0; i < electrons.length; ++i) {
            if (electrons[i] < 0) continue;
            vs[n++] = i;
        }
        return Arrays.copyOf(vs, n);
    }

    public static void clear(IAtomContainer mol) {
        mol.clear(32);
        for (IBond bond : mol.bonds()) {
            bond.clear(32);
        }
        for (IAtom atom : mol.atoms()) {
            atom.clear(32);
        }
    }

    @Deprecated
    public static Aromaticity cdkLegacy() {
        return CDK_LEGACY;
    }

    private static final class AllCyclesState {
        private final int[] visit;
        private final int[] contrib;
        private int numStates = 0;
        private int maxStates = 0;
        private boolean error = false;

        private AllCyclesState(int[] visit, int[] contrib) {
            this.visit = visit;
            this.contrib = contrib;
        }

        private void setMaxStates(int limit) {
            this.maxStates = limit;
        }

        private boolean markPath(IAtom atom, IBond prev, int limit, int pi, int depth) {
            if (limit != 0 && depth > limit) {
                return false;
            }
            if (this.maxStates != 0 && ++this.numStates >= this.maxStates) {
                return false;
            }
            pi += this.contrib[atom.getIndex()];
            this.visit[atom.getIndex()] = 1;
            for (IBond bond : atom.bonds()) {
                if (bond == prev || !bond.isInRing()) continue;
                IAtom nbor = bond.getOther(atom);
                if (this.visit[nbor.getIndex()] == 2) {
                    if (!Aromaticity.checkHuckelSum(pi)) continue;
                    Aromaticity.makeAromatic(bond);
                    this.visit[atom.getIndex()] = 0;
                    return true;
                }
                if (this.visit[nbor.getIndex()] != 0 || !this.markPath(nbor, bond, limit, pi, depth + 1)) continue;
                Aromaticity.makeAromatic(bond);
                this.visit[atom.getIndex()] = 0;
                return true;
            }
            this.visit[atom.getIndex()] = 0;
            return false;
        }

        private void processComplexRings(List<IAtom> d3Atoms, int limit) {
            for (IAtom atom : d3Atoms) {
                int pi = this.contrib[atom.getIndex()];
                this.visit[atom.getIndex()] = 2;
                for (IBond bond : atom.bonds()) {
                    IAtom nbor;
                    if (bond.isAromatic() || !bond.isInRing() || this.visit[(nbor = bond.getOther(atom)).getIndex()] != 0) continue;
                    this.numStates = 0;
                    if (this.markPath(nbor, bond, limit, pi, 2)) {
                        Aromaticity.makeAromatic(bond);
                    }
                    if (this.maxStates == 0 || this.numStates < this.maxStates) continue;
                    this.error = true;
                    return;
                }
                this.visit[atom.getIndex()] = 0;
            }
        }
    }

    public static class Model {
        public static ElectronDonation Daylight = new AromaticTypeModel(AromaticTypeModel.DAYLIGHT);
        public static ElectronDonation PiBonds = new PiBondModel();
        public static ElectronDonation Mdl = new AromaticTypeModel(AromaticTypeModel.MDL);
        public static ElectronDonation OpenSmiles = new AromaticTypeModel(AromaticTypeModel.OPEN_SMILES);
        public static ElectronDonation CDK_1x = new AromaticTypeModel(AromaticTypeModel.CDK_1x);
        public static ElectronDonation CDK_2x = new AromaticTypeModel(AromaticTypeModel.CDK_2x);
        public static ElectronDonation CDK_AtomTypes = new AtomTypeModel(false);

        private Model() {
        }
    }
}

