/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.aromaticity;

import org.openscience.cdk.aromaticity.AromaticType;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IBond;

final class AromaticTypeMatcher {
    private static int charge(IAtom atom) {
        return atom.getFormalCharge() != null ? atom.getFormalCharge() : 0;
    }

    private AromaticTypeMatcher() {
    }

    private static int hcount(IAtom atom) {
        return atom.getImplicitHydrogenCount() != null ? atom.getImplicitHydrogenCount() : 0;
    }

    private static int binfo(IAtom atom) {
        int binfo = atom.getImplicitHydrogenCount();
        if (atom.getBondCount() + binfo > 15) {
            return 4096;
        }
        block4: for (IBond bond : atom.bonds()) {
            switch (bond.getOrder()) {
                case SINGLE: {
                    ++binfo;
                    continue block4;
                }
                case DOUBLE: {
                    binfo += bond.isInRing() ? 16 : 256;
                    continue block4;
                }
            }
            binfo += 4096;
        }
        return binfo;
    }

    private static boolean hasExoHet(IAtom atom) {
        for (IBond bond : atom.bonds()) {
            if (bond.isInRing() || bond.getOrder() != IBond.Order.DOUBLE) continue;
            return bond.getOther(atom).getAtomicNumber() != 6;
        }
        return false;
    }

    private static boolean hasOxide(IAtom atom) {
        for (IBond bond : atom.bonds()) {
            if (bond.isInRing()) continue;
            IAtom nbor = bond.getOther(atom);
            if (nbor.getAtomicNumber() != 8) {
                return false;
            }
            if (bond.getOrder() == IBond.Order.DOUBLE) {
                return true;
            }
            return bond.getOrder() == IBond.Order.SINGLE && AromaticTypeMatcher.charge(atom) == 1 && AromaticTypeMatcher.charge(nbor) == -1;
        }
        return false;
    }

    static AromaticType getType(IAtom atom) {
        if (!atom.isInRing()) {
            return AromaticType.UNKNOWN;
        }
        if (atom.getBondCount() > 3 && atom.getAtomicNumber() != 15) {
            return AromaticType.UNKNOWN;
        }
        if (AromaticTypeMatcher.hcount(atom) > 1 && atom.getAtomicNumber() != 15) {
            return AromaticType.UNKNOWN;
        }
        switch (atom.getAtomicNumber()) {
            case 5: {
                if (AromaticTypeMatcher.charge(atom) != 0) break;
                switch (AromaticTypeMatcher.binfo(atom)) {
                    case 17: {
                        return AromaticType.B2;
                    }
                    case 3: {
                        return AromaticType.B3;
                    }
                }
                break;
            }
            case 6: {
                switch (AromaticTypeMatcher.charge(atom)) {
                    case -1: {
                        switch (AromaticTypeMatcher.binfo(atom)) {
                            case 17: {
                                return AromaticType.C2_MINUS;
                            }
                            case 3: {
                                return AromaticType.C3_MINUS;
                            }
                        }
                        break;
                    }
                    case 0: {
                        switch (AromaticTypeMatcher.binfo(atom)) {
                            case 18: {
                                return AromaticType.C3;
                            }
                            case 258: {
                                if (AromaticTypeMatcher.hasExoHet(atom)) {
                                    return AromaticType.C3_ENEG_EXO;
                                }
                                return AromaticType.C3_EXO;
                            }
                        }
                        break;
                    }
                    case 1: {
                        switch (AromaticTypeMatcher.binfo(atom)) {
                            case 17: {
                                return AromaticType.C2_PLUS;
                            }
                            case 3: {
                                return AromaticType.C3_PLUS;
                            }
                        }
                    }
                }
                break;
            }
            case 14: {
                switch (AromaticTypeMatcher.charge(atom)) {
                    case -1: {
                        switch (AromaticTypeMatcher.binfo(atom)) {
                            case 17: {
                                return AromaticType.Si2_MINUS;
                            }
                            case 3: {
                                return AromaticType.Si3_MINUS;
                            }
                        }
                        break;
                    }
                    case 0: {
                        switch (AromaticTypeMatcher.binfo(atom)) {
                            case 18: {
                                return AromaticType.Si3;
                            }
                            case 258: {
                                return AromaticType.Si3_EXO;
                            }
                        }
                        break;
                    }
                    case 1: {
                        switch (AromaticTypeMatcher.binfo(atom)) {
                            case 17: {
                                return AromaticType.Si2_PLUS;
                            }
                            case 3: {
                                return AromaticType.Si3_PLUS;
                            }
                        }
                    }
                }
                break;
            }
            case 7: {
                int q = AromaticTypeMatcher.charge(atom);
                if (q == -1 && AromaticTypeMatcher.binfo(atom) == 2) {
                    return AromaticType.N2_MINUS;
                }
                if (q == 0) {
                    switch (AromaticTypeMatcher.binfo(atom)) {
                        case 3: {
                            return AromaticType.N3;
                        }
                        case 17: {
                            return AromaticType.N2;
                        }
                        case 273: {
                            if (!AromaticTypeMatcher.hasOxide(atom)) break;
                            return AromaticType.N3_OXIDE;
                        }
                    }
                    break;
                }
                if (q != 1 || AromaticTypeMatcher.binfo(atom) != 18) break;
                if (AromaticTypeMatcher.hasOxide(atom)) {
                    return AromaticType.N3_OXIDE_PLUS;
                }
                return AromaticType.N3_PLUS;
            }
            case 15: {
                int q = AromaticTypeMatcher.charge(atom);
                if (q == -1 && AromaticTypeMatcher.binfo(atom) == 2) {
                    return AromaticType.P2_MINUS;
                }
                if (q == 0) {
                    switch (AromaticTypeMatcher.binfo(atom)) {
                        case 19: {
                            return AromaticType.P4;
                        }
                        case 3: {
                            return AromaticType.P3;
                        }
                        case 17: {
                            return AromaticType.P2;
                        }
                        case 273: {
                            if (!AromaticTypeMatcher.hasOxide(atom)) break;
                            return AromaticType.P3_OXIDE;
                        }
                    }
                    break;
                }
                if (q != 1 || AromaticTypeMatcher.binfo(atom) != 18) break;
                if (AromaticTypeMatcher.hasOxide(atom)) {
                    return AromaticType.P3_OXIDE_PLUS;
                }
                return AromaticType.P3_PLUS;
            }
            case 33: {
                int q = AromaticTypeMatcher.charge(atom);
                if (q == -1 && AromaticTypeMatcher.binfo(atom) == 2) {
                    return AromaticType.As2_MINUS;
                }
                if (q == 0) {
                    switch (AromaticTypeMatcher.binfo(atom)) {
                        case 3: {
                            return AromaticType.As3;
                        }
                        case 17: {
                            return AromaticType.As2;
                        }
                    }
                    break;
                }
                if (q != 1) break;
                switch (AromaticTypeMatcher.binfo(atom)) {
                    case 18: 
                    case 258: {
                        return AromaticType.As3_PLUS;
                    }
                }
                break;
            }
            case 8: {
                int q = AromaticTypeMatcher.charge(atom);
                if (q == 0 && AromaticTypeMatcher.binfo(atom) == 2) {
                    return AromaticType.O2;
                }
                if (q != 1 || AromaticTypeMatcher.binfo(atom) != 17) break;
                return AromaticType.O2_PLUS;
            }
            case 16: {
                int q = AromaticTypeMatcher.charge(atom);
                if (q == 0) {
                    switch (AromaticTypeMatcher.binfo(atom)) {
                        case 18: {
                            return AromaticType.S3;
                        }
                        case 2: {
                            return AromaticType.S2;
                        }
                        case 32: {
                            return AromaticType.S2_CUML;
                        }
                        case 258: {
                            if (!AromaticTypeMatcher.hasOxide(atom)) break;
                            return AromaticType.S3_OXIDE;
                        }
                    }
                }
                if (q != 1) break;
                switch (AromaticTypeMatcher.binfo(atom)) {
                    case 17: {
                        return AromaticType.S2_PLUS;
                    }
                    case 3: {
                        if (AromaticTypeMatcher.hasOxide(atom)) {
                            return AromaticType.S3_OXIDE_PLUS;
                        }
                        return AromaticType.S3_PLUS;
                    }
                }
                break;
            }
            case 34: {
                int q = AromaticTypeMatcher.charge(atom);
                if (q == 0) {
                    switch (AromaticTypeMatcher.binfo(atom)) {
                        case 2: {
                            return AromaticType.Se2;
                        }
                        case 18: {
                            return AromaticType.Se3;
                        }
                        case 258: {
                            if (!AromaticTypeMatcher.hasOxide(atom)) break;
                            return AromaticType.Se3_OXIDE;
                        }
                    }
                }
                if (q != 1) break;
                switch (AromaticTypeMatcher.binfo(atom)) {
                    case 17: {
                        return AromaticType.Se2_PLUS;
                    }
                    case 3: {
                        if (!AromaticTypeMatcher.hasOxide(atom)) break;
                        return AromaticType.Se3_OXIDE_PLUS;
                    }
                }
                break;
            }
            case 52: {
                int q = AromaticTypeMatcher.charge(atom);
                if (q == 0 && AromaticTypeMatcher.binfo(atom) == 2) {
                    return AromaticType.Te2;
                }
                if (q != 1 || AromaticTypeMatcher.binfo(atom) != 17) break;
                return AromaticType.Te2_PLUS;
            }
        }
        return AromaticType.UNKNOWN;
    }
}

