/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.elements;

import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import org.openscience.cdk.renderer.elements.IRenderingElement;
import org.openscience.cdk.renderer.elements.IRenderingVisitor;
import org.openscience.cdk.renderer.elements.path.Close;
import org.openscience.cdk.renderer.elements.path.CubicTo;
import org.openscience.cdk.renderer.elements.path.LineTo;
import org.openscience.cdk.renderer.elements.path.MoveTo;
import org.openscience.cdk.renderer.elements.path.PathElement;
import org.openscience.cdk.renderer.elements.path.QuadTo;

public class GeneralPath
implements IRenderingElement {
    public final Color color;
    public final double stroke;
    public final boolean fill;
    public final List<PathElement> elements;
    public final int winding;
    public static final int WIND_EVEN_ODD = 0;
    public static final int WIND_NON_ZERO = 1;

    public GeneralPath(List<PathElement> elements, Color color) {
        this(elements, color, 0, 1.0, true);
    }

    private GeneralPath(List<PathElement> elements, Color color, int winding, double stroke, boolean fill) {
        this.elements = elements;
        this.color = color;
        this.winding = winding;
        this.fill = fill;
        this.stroke = stroke;
    }

    public GeneralPath recolor(Color newColor) {
        return new GeneralPath(this.elements, newColor, this.winding, this.stroke, this.fill);
    }

    public GeneralPath outline(double newStroke) {
        return new GeneralPath(this.elements, this.color, this.winding, newStroke, false);
    }

    public void accept(IRenderingVisitor v) {
        v.visit((IRenderingElement)this);
    }

    public static GeneralPath shapeOf(Shape shape, Color color) {
        ArrayList<PathElement> elements = new ArrayList<PathElement>();
        PathIterator pathIt = shape.getPathIterator(new AffineTransform());
        double[] data = new double[6];
        while (!pathIt.isDone()) {
            switch (pathIt.currentSegment(data)) {
                case 0: {
                    elements.add(new MoveTo(data));
                    break;
                }
                case 1: {
                    elements.add(new LineTo(data));
                    break;
                }
                case 4: {
                    elements.add(new Close());
                    break;
                }
                case 2: {
                    elements.add(new QuadTo(data));
                    break;
                }
                case 3: {
                    elements.add(new CubicTo(data));
                }
            }
            pathIt.next();
        }
        return new GeneralPath(elements, color, pathIt.getWindingRule(), 0.0, true);
    }

    public static GeneralPath outlineOf(Shape shape, double stroke, Color color) {
        ArrayList<PathElement> elements = new ArrayList<PathElement>();
        PathIterator pathIt = shape.getPathIterator(new AffineTransform());
        double[] data = new double[6];
        while (!pathIt.isDone()) {
            switch (pathIt.currentSegment(data)) {
                case 0: {
                    elements.add(new MoveTo(data));
                    break;
                }
                case 1: {
                    elements.add(new LineTo(data));
                    break;
                }
                case 4: {
                    elements.add(new Close());
                    break;
                }
                case 2: {
                    elements.add(new QuadTo(data));
                    break;
                }
                case 3: {
                    elements.add(new CubicTo(data));
                }
            }
            pathIt.next();
        }
        return new GeneralPath(elements, color, pathIt.getWindingRule(), stroke, false);
    }

    private PathIterator getAwtPathIterator() {
        final ArrayDeque<PathElement> queue = new ArrayDeque<PathElement>(this.elements);
        return new PathIterator(){

            @Override
            public int getWindingRule() {
                return GeneralPath.this.winding;
            }

            @Override
            public boolean isDone() {
                return queue.isEmpty();
            }

            @Override
            public void next() {
                queue.pop();
            }

            @Override
            public int currentSegment(float[] coords) {
                PathElement e = (PathElement)queue.peek();
                assert (e != null);
                e.points(coords);
                return e.type().ordinal();
            }

            @Override
            public int currentSegment(double[] coords) {
                PathElement e = (PathElement)queue.peek();
                assert (e != null);
                e.points(coords);
                return e.type().ordinal();
            }
        };
    }

    public Area toArea() {
        Path2D.Double path = new Path2D.Double();
        ((Path2D)path).append(this.getAwtPathIterator(), true);
        return new Area(path);
    }
}

