/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.generators.standard;

import java.awt.Font;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openscience.cdk.config.Elements;
import org.openscience.cdk.config.Isotopes;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IIsotope;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.renderer.generators.standard.AbbreviationLabel;
import org.openscience.cdk.renderer.generators.standard.AtomSymbol;
import org.openscience.cdk.renderer.generators.standard.HydrogenPosition;
import org.openscience.cdk.renderer.generators.standard.TextOutline;

final class StandardAtomGenerator {
    private static final double DEFAULT_ADJUNCT_SPACING_RATIO = 0.15;
    private static final double DEFAULT_SUBSCRIPT_SIZE = 0.6;
    private final Font font;
    private final double scriptSize;
    private final double padding;
    private final TextOutline defaultHydrogenLabel;
    private static final char BULLET = '\u2022';
    private static final char PLUS = '+';
    private static final char MINUS = '\u2212';

    StandardAtomGenerator(Font font) {
        this(font, 0.15, 0.6);
    }

    private StandardAtomGenerator(Font font, double adjunctSpacing, double scriptSize) {
        this.font = font;
        this.scriptSize = scriptSize;
        this.defaultHydrogenLabel = new TextOutline("H", font);
        this.padding = adjunctSpacing * this.defaultHydrogenLabel.getBounds().getWidth();
    }

    AtomSymbol generateSymbol(IAtomContainer container, IAtom atom, HydrogenPosition position) {
        if (atom instanceof IPseudoAtom) {
            IPseudoAtom pAtom = (IPseudoAtom)atom;
            if (pAtom.getAttachPointNum() <= 0) {
                return this.generatePseudoSymbol(StandardAtomGenerator.accessPseudoLabel(pAtom, "?"), position);
            }
            return null;
        }
        int number = StandardAtomGenerator.unboxSafely(atom.getAtomicNumber(), Elements.ofString((String)atom.getSymbol()).number());
        if (number == 0) {
            return this.generatePseudoSymbol("?", position);
        }
        Integer mass = atom.getMassNumber();
        if (mass != null && this.isMajorIsotope(number, mass)) {
            mass = null;
        }
        return this.generatePeriodicSymbol(number, StandardAtomGenerator.unboxSafely(atom.getImplicitHydrogenCount(), 0), StandardAtomGenerator.unboxSafely(mass, -1), StandardAtomGenerator.unboxSafely(atom.getFormalCharge(), 0), container.getConnectedSingleElectronsCount(atom), position);
    }

    AtomSymbol generatePseudoSymbol(String label, HydrogenPosition position) {
        int pos;
        Font italicFont = this.font.deriveFont(1).deriveFont(2);
        ArrayList<TextOutline> outlines = new ArrayList<TextOutline>(3);
        int beg = 0;
        int len = label.length();
        for (pos = 0; pos < len && this.isUpperCase(label.charAt(pos)); ++pos) {
        }
        if (label.charAt(0) != 'R') {
            while (pos < len && this.isLowerCase(label.charAt(pos))) {
                ++pos;
            }
        }
        if (pos > beg) {
            outlines.add(new TextOutline(label.substring(beg, pos), italicFont));
            beg = pos;
            while (pos < len && this.isDigit(label.charAt(pos))) {
                ++pos;
            }
            while (pos < len && this.isLowerCase(label.charAt(pos))) {
                ++pos;
            }
            if (pos > beg) {
                TextOutline outline = new TextOutline(label.substring(beg, pos), italicFont);
                outline = outline.resize(this.scriptSize, this.scriptSize);
                outline = this.positionSuperscript((TextOutline)outlines.get(0), outline);
                outlines.add(outline);
            }
            int numPrimes = 0;
            block31: while (pos < len) {
                switch (label.charAt(pos)) {
                    case '\'': {
                        ++numPrimes;
                        break;
                    }
                    case '`': {
                        ++numPrimes;
                        break;
                    }
                    case '\u2018': {
                        ++numPrimes;
                        break;
                    }
                    case '\u2019': {
                        ++numPrimes;
                        break;
                    }
                    case '\u201b': {
                        ++numPrimes;
                        break;
                    }
                    case '\u201c': {
                        numPrimes += 2;
                        break;
                    }
                    case '\u201d': {
                        numPrimes += 2;
                        break;
                    }
                    case '\u2032': {
                        ++numPrimes;
                        break;
                    }
                    case '\u2033': {
                        numPrimes += 2;
                        break;
                    }
                    case '\u2034': {
                        numPrimes += 3;
                        break;
                    }
                    case '\u2057': {
                        numPrimes += 4;
                        break;
                    }
                    case '\u2035': {
                        ++numPrimes;
                        break;
                    }
                    case '\u2036': {
                        numPrimes += 2;
                        break;
                    }
                    case '\u2037': {
                        numPrimes += 3;
                        break;
                    }
                    case '\u00b4': {
                        ++numPrimes;
                        break;
                    }
                    case '\u02ca': {
                        ++numPrimes;
                        break;
                    }
                    case '\u0301': {
                        ++numPrimes;
                        break;
                    }
                    case '\u02dd': {
                        numPrimes += 2;
                        break;
                    }
                    case '\u030b': {
                        numPrimes += 2;
                        break;
                    }
                    default: {
                        break block31;
                    }
                }
                ++pos;
            }
            if (pos < len) {
                return new AtomSymbol(new TextOutline(label, italicFont), Collections.emptyList());
            }
            TextOutline outline = null;
            TextOutline ref = (TextOutline)outlines.get(outlines.size() - 1);
            switch (numPrimes) {
                case 0: {
                    break;
                }
                case 1: {
                    outline = new TextOutline("\u2032", this.font);
                    break;
                }
                case 2: {
                    outline = new TextOutline("\u2033", this.font);
                    break;
                }
                case 3: {
                    outline = new TextOutline("\u2034", this.font);
                    break;
                }
                default: {
                    String lab = "";
                    while (numPrimes-- > 0) {
                        lab = lab + "\u2032";
                    }
                    outline = new TextOutline(lab, this.font);
                }
            }
            if (outline != null) {
                if (outlines.size() > 1) {
                    outline = outline.resize(this.scriptSize, this.scriptSize);
                }
                outline = this.positionSuperscript(ref, outline);
                outlines.add(outline);
            }
            for (int i = 1; i < outlines.size(); ++i) {
                ref = (TextOutline)outlines.get(i - 1);
                TextOutline curr = (TextOutline)outlines.get(i);
                outlines.set(i, this.positionAfter(ref, curr));
            }
            return new AtomSymbol((TextOutline)outlines.get(0), outlines.subList(1, outlines.size()));
        }
        return new AtomSymbol(new TextOutline(label, italicFont), Collections.emptyList());
    }

    private boolean isUpperCase(char c) {
        return c >= 'A' && c <= 'Z';
    }

    private boolean isLowerCase(char c) {
        return c >= 'a' && c <= 'z';
    }

    private boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    AtomSymbol generateAbbreviatedSymbol(String label, HydrogenPosition position) {
        ArrayList<String> tokens = new ArrayList<String>();
        if (AbbreviationLabel.parse(label, tokens)) {
            return this.generateAbbreviationSymbol(tokens, position);
        }
        return new AtomSymbol(new TextOutline(label, this.font), Collections.emptyList());
    }

    AtomSymbol generateAbbreviationSymbol(List<String> tokens, HydrogenPosition position) {
        int index;
        if (position == HydrogenPosition.Left) {
            AbbreviationLabel.reverse(tokens);
        }
        TextOutline tmpRefPoint = new TextOutline("H", this.font);
        List<AbbreviationLabel.FormattedText> fTexts = AbbreviationLabel.format(tokens);
        Font italicFont = this.font.deriveFont(2);
        if (position == HydrogenPosition.Below || position == HydrogenPosition.Above) {
            AbbreviationLabel.reduce(fTexts, 1, fTexts.size());
        } else {
            AbbreviationLabel.reduce(fTexts, 0, fTexts.size());
        }
        ArrayList<TextOutline> outlines = new ArrayList<TextOutline>(fTexts.size());
        for (AbbreviationLabel.FormattedText fText : fTexts) {
            TextOutline outline;
            TextOutline textOutline = outline = fText.style == AbbreviationLabel.STYLE_ITALIC ? new TextOutline(fText.text, italicFont) : new TextOutline(fText.text, this.font);
            if (fText.style == AbbreviationLabel.STYLE_SUBSCRIPT) {
                outline = outline.resize(this.scriptSize, this.scriptSize);
                outline = this.positionSubscript(tmpRefPoint, outline);
            } else if (fText.style == AbbreviationLabel.STYLE_SUPSCRIPT) {
                outline = outline.resize(this.scriptSize, this.scriptSize);
                outline = this.positionSuperscript(tmpRefPoint, outline);
            }
            outlines.add(outline);
        }
        for (int i = 1; i < outlines.size(); ++i) {
            TextOutline ref = (TextOutline)outlines.get(i - 1);
            TextOutline curr = (TextOutline)outlines.get(i);
            if (fTexts.get((int)i).style == AbbreviationLabel.STYLE_SUPSCRIPT && fTexts.get((int)(i - 1)).style == AbbreviationLabel.STYLE_SUBSCRIPT && i > 1) {
                ref = (TextOutline)outlines.get(i - 2);
            }
            outlines.set(i, this.positionAfter(ref, curr));
        }
        if (position == HydrogenPosition.Left) {
            for (index = outlines.size() - 1; index >= 0 && (fTexts.get((int)index).style & 1) != 0; --index) {
            }
        } else {
            for (index = 0; index < outlines.size() && (fTexts.get((int)index).style & 1) != 0; ++index) {
            }
        }
        TextOutline primary = (TextOutline)outlines.remove(index);
        if (position == HydrogenPosition.Below || position == HydrogenPosition.Above) {
            double offsetX = primary.getBounds().getX() - ((TextOutline)outlines.get(0)).getBounds().getX();
            double offsetY = position == HydrogenPosition.Below ? this.padding + primary.getBounds().getHeight() : -primary.getBounds().getHeight() - this.padding;
            for (int i = 0; i < outlines.size(); ++i) {
                outlines.set(i, ((TextOutline)outlines.get(i)).translate(offsetX, offsetY));
            }
        }
        return new AtomSymbol(primary, outlines);
    }

    AtomSymbol generatePeriodicSymbol(int number, int hydrogens, int mass, int charge, int unpaired, HydrogenPosition position) {
        TextOutline element = new TextOutline(Elements.ofNumber((int)number).symbol(), this.font);
        TextOutline hydrogenAdjunct = this.defaultHydrogenLabel;
        TextOutline hydrogenCount = new TextOutline(Integer.toString(hydrogens), this.font).resize(this.scriptSize, this.scriptSize);
        TextOutline chargeAdjunct = new TextOutline(StandardAtomGenerator.chargeAdjunctText(charge, unpaired), this.font).resize(this.scriptSize, this.scriptSize);
        TextOutline massAdjunct = new TextOutline(Integer.toString(mass), this.font).resize(this.scriptSize, this.scriptSize);
        hydrogenAdjunct = this.positionHydrogenLabel(position, element, hydrogenAdjunct);
        hydrogenCount = this.positionSubscript(hydrogenAdjunct, hydrogenCount);
        chargeAdjunct = this.positionChargeLabel(hydrogens, position, chargeAdjunct, element, hydrogenAdjunct);
        massAdjunct = this.positionMassLabel(massAdjunct, element);
        if (position == HydrogenPosition.Left) {
            double nudgeX = this.hydrogenXDodge(hydrogens, mass, element, hydrogenAdjunct, hydrogenCount, massAdjunct);
            hydrogenAdjunct = hydrogenAdjunct.translate(nudgeX, 0.0);
            hydrogenCount = hydrogenCount.translate(nudgeX, 0.0);
        }
        ArrayList<TextOutline> adjuncts = new ArrayList<TextOutline>(4);
        if (hydrogens > 0) {
            adjuncts.add(hydrogenAdjunct);
        }
        if (hydrogens > 1) {
            adjuncts.add(hydrogenCount);
        }
        if (charge != 0 || unpaired > 0) {
            adjuncts.add(chargeAdjunct);
        }
        if (mass >= 0) {
            adjuncts.add(massAdjunct);
        }
        return new AtomSymbol(element, adjuncts);
    }

    TextOutline positionHydrogenLabel(HydrogenPosition position, TextOutline element, TextOutline hydrogen) {
        Rectangle2D elementBounds = element.getBounds();
        Rectangle2D hydrogenBounds = hydrogen.getBounds();
        switch (position) {
            case Above: {
                return hydrogen.translate(0.0, elementBounds.getMinY() - this.padding - hydrogenBounds.getMaxY());
            }
            case Right: {
                return hydrogen.translate(elementBounds.getMaxX() + this.padding - hydrogenBounds.getMinX(), 0.0);
            }
            case Below: {
                return hydrogen.translate(0.0, elementBounds.getMaxY() + this.padding - hydrogenBounds.getMinY());
            }
            case Left: {
                return hydrogen.translate(elementBounds.getMinX() - this.padding - hydrogenBounds.getMaxX(), 0.0);
            }
        }
        return hydrogen;
    }

    TextOutline positionSubscript(TextOutline label, TextOutline subscript) {
        Rectangle2D hydrogenBounds = label.getBounds();
        Rectangle2D hydrogenCountBounds = subscript.getBounds();
        subscript = subscript.translate(hydrogenBounds.getMaxX() + this.padding - hydrogenCountBounds.getMinX(), hydrogenBounds.getMaxY() + hydrogenCountBounds.getHeight() / 2.0 - hydrogenCountBounds.getMaxY());
        return subscript;
    }

    TextOutline positionSuperscript(TextOutline label, TextOutline superscript) {
        Rectangle2D labelBounds = label.getBounds();
        Rectangle2D superscriptBounds = superscript.getBounds();
        superscript = superscript.translate(labelBounds.getMaxX() + this.padding - superscriptBounds.getMinX(), labelBounds.getMinY() - superscriptBounds.getHeight() / 2.0 - superscriptBounds.getMinY());
        return superscript;
    }

    TextOutline positionAfter(TextOutline before, TextOutline after) {
        Rectangle2D fixedBounds = before.getBounds();
        Rectangle2D movableBounds = after.getBounds();
        after = after.translate(fixedBounds.getMaxX() + this.padding - movableBounds.getMinX(), 0.0);
        return after;
    }

    TextOutline positionChargeLabel(int hydrogens, HydrogenPosition position, TextOutline charge, TextOutline element, TextOutline hydrogen) {
        Rectangle2D chargeBounds = charge.getBounds();
        Rectangle2D referenceBounds = element.getBounds();
        if (hydrogens > 0 && position == HydrogenPosition.Right) {
            referenceBounds = hydrogen.getBounds();
        } else if (hydrogens > 1 && position == HydrogenPosition.Above) {
            referenceBounds = hydrogen.getBounds();
        }
        return charge.translate(referenceBounds.getMaxX() + this.padding - chargeBounds.getMinX(), referenceBounds.getMinY() - chargeBounds.getHeight() / 2.0 - chargeBounds.getMinY());
    }

    TextOutline positionMassLabel(TextOutline massLabel, TextOutline elementLabel) {
        Rectangle2D elementBounds = elementLabel.getBounds();
        Rectangle2D massBounds = massLabel.getBounds();
        return massLabel.translate(elementBounds.getMinX() - this.padding - massBounds.getMaxX(), elementBounds.getMinY() - massBounds.getHeight() / 2.0 - massBounds.getMinY());
    }

    private double hydrogenXDodge(int hydrogens, int mass, TextOutline elementLabel, TextOutline hydrogenLabel, TextOutline hydrogenCount, TextOutline massLabel) {
        if (mass < 0 && hydrogens > 1) {
            return elementLabel.getBounds().getMinX() - this.padding - hydrogenCount.getBounds().getMaxX();
        }
        if (mass >= 0) {
            if (hydrogens > 1) {
                return massLabel.getBounds().getMinX() + this.padding - hydrogenCount.getBounds().getMaxX();
            }
            if (hydrogens > 0) {
                return massLabel.getBounds().getMinX() - this.padding - hydrogenLabel.getBounds().getMaxX();
            }
        }
        return 0.0;
    }

    private boolean isMajorIsotope(int number, int mass) {
        try {
            IIsotope isotope = Isotopes.getInstance().getMajorIsotope(number);
            return isotope != null && isotope.getMassNumber().equals(mass);
        }
        catch (IOException e) {
            return false;
        }
    }

    private static int unboxSafely(Integer value, int defaultValue) {
        return value != null ? value : defaultValue;
    }

    static String chargeAdjunctText(int charge, int unpaired) {
        StringBuilder sb = new StringBuilder();
        if (unpaired == 1) {
            if (charge != 0) {
                sb.append('(').append('\u2022').append(')');
            } else {
                sb.append('\u2022');
            }
        } else if (unpaired > 1) {
            if (charge != 0) {
                sb.append('(').append(unpaired).append('\u2022').append(')');
            } else {
                sb.append(unpaired).append('\u2022');
            }
        }
        char sign = charge < 0 ? (char)'\u2212' : '+';
        int coefficient = Math.abs(charge);
        if (coefficient > 1) {
            sb.append(coefficient);
        }
        if (coefficient > 0) {
            sb.append(sign);
        }
        return sb.toString();
    }

    static String accessPseudoLabel(IPseudoAtom atom, String defaultLabel) {
        String label = atom.getLabel();
        if (label != null && !label.isEmpty()) {
            return label;
        }
        return defaultLabel;
    }
}

