/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.isomorphism.matchers;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IChemObjectChangeEvent;
import org.openscience.cdk.interfaces.IChemObjectListener;

public class QueryChemObject
implements IChemObject {
    private List<IChemObjectListener> chemObjectListeners = null;
    private Map<Object, Object> properties = null;
    private String identifier = null;
    private int flags;
    private final IChemObjectBuilder builder;
    private boolean doNotification = true;

    public QueryChemObject(IChemObjectBuilder builder) {
        this.builder = builder;
    }

    private List<IChemObjectListener> lazyChemObjectListeners() {
        if (this.chemObjectListeners == null) {
            this.chemObjectListeners = new ArrayList<IChemObjectListener>();
        }
        return this.chemObjectListeners;
    }

    public void addListener(IChemObjectListener col) {
        List<IChemObjectListener> listeners = this.lazyChemObjectListeners();
        if (!listeners.contains(col)) {
            listeners.add(col);
        }
    }

    public int getListenerCount() {
        if (this.chemObjectListeners == null) {
            return 0;
        }
        return this.lazyChemObjectListeners().size();
    }

    public void removeListener(IChemObjectListener col) {
        if (this.chemObjectListeners == null) {
            return;
        }
        List<IChemObjectListener> listeners = this.lazyChemObjectListeners();
        if (listeners.contains(col)) {
            listeners.remove(col);
        }
    }

    public void notifyChanged() {
        if (this.getNotification() && this.getListenerCount() > 0) {
            List<IChemObjectListener> listeners = this.lazyChemObjectListeners();
            for (IChemObjectListener listener : listeners) {
                listener.stateChanged((IChemObjectChangeEvent)new QueryChemObjectChangeEvent(this));
            }
        }
    }

    public void notifyChanged(IChemObjectChangeEvent evt) {
        if (this.getNotification() && this.getListenerCount() > 0) {
            List<IChemObjectListener> listeners = this.lazyChemObjectListeners();
            for (IChemObjectListener listener : listeners) {
                listener.stateChanged(evt);
            }
        }
    }

    private Map<Object, Object> lazyProperties() {
        if (this.properties == null) {
            this.properties = new HashMap<Object, Object>();
        }
        return this.properties;
    }

    public void setProperty(Object description, Object property) {
        this.lazyProperties().put(description, property);
        this.notifyChanged();
    }

    public void removeProperty(Object description) {
        if (this.properties == null) {
            return;
        }
        if (this.lazyProperties().remove(description) != null) {
            this.notifyChanged();
        }
    }

    public <T> T getProperty(Object description) {
        Object value = this.lazyProperties().get(description);
        return (T)value;
    }

    public <T> T getProperty(Object description, Class<T> c) {
        Object value = this.lazyProperties().get(description);
        if (c.isInstance(value)) {
            Object typed = value;
            return (T)typed;
        }
        if (value != null) {
            throw new IllegalArgumentException("attempted to access a property of incorrect type, expected " + c.getSimpleName() + " got " + value.getClass().getSimpleName());
        }
        return null;
    }

    public Map<Object, Object> getProperties() {
        return this.lazyProperties();
    }

    public String getID() {
        return this.identifier;
    }

    public void setID(String identifier) {
        this.identifier = identifier;
        this.notifyChanged();
    }

    public void setFlag(int mask, boolean value) {
        this.flags = value ? (this.flags |= mask) : (this.flags &= ~mask);
        this.notifyChanged();
    }

    public boolean getFlag(int mask) {
        return (this.flags & mask) != 0;
    }

    public void setProperties(Map<Object, Object> properties) {
        this.properties = null;
        if (properties != null) {
            this.addProperties(properties);
        }
    }

    public void addProperties(Map<Object, Object> properties) {
        if (properties == null) {
            return;
        }
        this.lazyProperties().putAll(properties);
        this.notifyChanged();
    }

    public void setFlags(boolean[] flagsNew) {
        for (int i = 0; i < flagsNew.length; ++i) {
            this.setFlag(CDKConstants.FLAG_MASKS[i], flagsNew[i]);
        }
    }

    public boolean[] getFlags() {
        boolean[] flagArray = new boolean[14];
        for (int i = 0; i < CDKConstants.FLAG_MASKS.length; ++i) {
            int mask = CDKConstants.FLAG_MASKS[i];
            flagArray[i] = this.getFlag(mask);
        }
        return flagArray;
    }

    public Integer getFlagValue() {
        return this.flags;
    }

    public void set(int flags) {
        this.flags |= flags;
    }

    public void clear(int flags) {
        this.flags &= ~flags;
    }

    public boolean is(int flags) {
        return (this.flags & flags) == flags;
    }

    public int flags() {
        return this.flags;
    }

    public void setNotification(boolean bool) {
        this.doNotification = bool;
    }

    public boolean getNotification() {
        return this.doNotification;
    }

    public IChemObjectBuilder getBuilder() {
        return this.builder;
    }

    public boolean matches(IAtom atom) {
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    class QueryChemObjectChangeEvent
    extends EventObject
    implements IChemObjectChangeEvent {
        private static final long serialVersionUID = 8060005185140623245L;

        public QueryChemObjectChangeEvent(Object source) {
            super(source);
        }
    }
}

