/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IChemSequence;
import org.openscience.cdk.interfaces.IMapping;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.interfaces.IReactionSet;
import org.openscience.cdk.io.DefaultChemObjectReader;
import org.openscience.cdk.io.IChemObjectReader;
import org.openscience.cdk.io.MDLV2000Reader;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.formats.MDLRXNFormat;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class MDLRXNV2000Reader
extends DefaultChemObjectReader {
    BufferedReader input = null;
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(MDLRXNV2000Reader.class);

    public MDLRXNV2000Reader(Reader in) {
        this(in, IChemObjectReader.Mode.RELAXED);
    }

    public MDLRXNV2000Reader(Reader in, IChemObjectReader.Mode mode) {
        this.input = in instanceof BufferedReader ? (BufferedReader)in : new BufferedReader(in);
        this.mode = mode;
    }

    public MDLRXNV2000Reader(InputStream input) {
        this(input, IChemObjectReader.Mode.RELAXED);
    }

    public MDLRXNV2000Reader(InputStream input, IChemObjectReader.Mode mode) {
        this(new InputStreamReader(input), mode);
    }

    public MDLRXNV2000Reader() {
        this(new StringReader(""));
    }

    public IResourceFormat getFormat() {
        return MDLRXNFormat.getInstance();
    }

    public void setReader(Reader input) throws CDKException {
        this.input = input instanceof BufferedReader ? (BufferedReader)input : new BufferedReader(input);
    }

    public void setReader(InputStream input) throws CDKException {
        this.setReader(new InputStreamReader(input));
    }

    public boolean accepts(Class<? extends IChemObject> classObject) {
        if (IChemFile.class.equals(classObject)) {
            return true;
        }
        if (IChemModel.class.equals(classObject)) {
            return true;
        }
        if (IReaction.class.equals(classObject)) {
            return true;
        }
        Class<?>[] interfaces = classObject.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (IChemModel.class.equals(interfaces[i])) {
                return true;
            }
            if (IChemFile.class.equals(interfaces[i])) {
                return true;
            }
            if (!IReaction.class.equals(interfaces[i])) continue;
            return true;
        }
        Class<? extends IChemObject> superClass = classObject.getSuperclass();
        if (superClass != null) {
            return this.accepts(superClass);
        }
        return false;
    }

    public <T extends IChemObject> T read(T object) throws CDKException {
        if (object instanceof IReaction) {
            return (T)this.readReaction(object.getBuilder());
        }
        if (object instanceof IReactionSet) {
            IReactionSet reactionSet = (IReactionSet)object.getBuilder().newInstance(IReactionSet.class, new Object[0]);
            reactionSet.addReaction(this.readReaction(object.getBuilder()));
            return (T)reactionSet;
        }
        if (object instanceof IChemModel) {
            IChemModel model = (IChemModel)object.getBuilder().newInstance(IChemModel.class, new Object[0]);
            IReactionSet reactionSet = (IReactionSet)object.getBuilder().newInstance(IReactionSet.class, new Object[0]);
            reactionSet.addReaction(this.readReaction(object.getBuilder()));
            model.setReactionSet(reactionSet);
            return (T)model;
        }
        if (object instanceof IChemFile) {
            IChemFile chemFile = (IChemFile)object.getBuilder().newInstance(IChemFile.class, new Object[0]);
            IChemSequence sequence = (IChemSequence)object.getBuilder().newInstance(IChemSequence.class, new Object[0]);
            sequence.addChemModel((IChemModel)this.read((IChemObject)object.getBuilder().newInstance(IChemModel.class, new Object[0])));
            chemFile.addChemSequence(sequence);
            return (T)chemFile;
        }
        throw new CDKException("Only supported are Reaction and ChemModel, and not " + object.getClass().getName() + ".");
    }

    public boolean accepts(IChemObject object) {
        if (object instanceof IReaction) {
            return true;
        }
        if (object instanceof IChemModel) {
            return true;
        }
        if (object instanceof IChemFile) {
            return true;
        }
        return object instanceof IReactionSet;
    }

    private IReaction readReaction(IChemObjectBuilder builder) throws CDKException {
        MDLV2000Reader reader;
        String molFileLine;
        StringBuffer molFile;
        int i;
        IReaction reaction = (IReaction)builder.newInstance(IReaction.class, new Object[0]);
        try {
            this.input.readLine();
            this.input.readLine();
            this.input.readLine();
            this.input.readLine();
        }
        catch (IOException exception) {
            logger.debug((Object)exception);
            throw new CDKException("Error while reading header of RXN file", (Throwable)exception);
        }
        int reactantCount = 0;
        int productCount = 0;
        try {
            String countsLine = this.input.readLine();
            StringTokenizer tokenizer = new StringTokenizer(countsLine);
            reactantCount = Integer.valueOf(tokenizer.nextToken());
            logger.info((Object)("Expecting " + reactantCount + " reactants in file"));
            productCount = Integer.valueOf(tokenizer.nextToken());
            logger.info((Object)("Expecting " + productCount + " products in file"));
        }
        catch (IOException | NumberFormatException exception) {
            logger.debug((Object)exception);
            throw new CDKException("Error while counts line of RXN file", (Throwable)exception);
        }
        try {
            for (i = 1; i <= reactantCount; ++i) {
                molFile = new StringBuffer();
                this.input.readLine();
                molFileLine = "";
                do {
                    molFileLine = this.input.readLine();
                    molFile.append(molFileLine);
                    molFile.append(System.getProperty("line.separator"));
                } while (!molFileLine.equals("M  END"));
                reader = new MDLV2000Reader(new StringReader(molFile.toString()), this.mode);
                IAtomContainer reactant = (IAtomContainer)reader.read((IChemObject)builder.newInstance(IAtomContainer.class, new Object[0]));
                reader.close();
                reaction.addReactant(reactant);
            }
        }
        catch (CDKException exception) {
            throw exception;
        }
        catch (IOException | IllegalArgumentException exception) {
            logger.debug((Object)exception);
            throw new CDKException("Error while reading reactant", (Throwable)exception);
        }
        try {
            for (i = 1; i <= productCount; ++i) {
                molFile = new StringBuffer();
                this.input.readLine();
                molFileLine = "";
                do {
                    molFileLine = this.input.readLine();
                    molFile.append(molFileLine);
                    molFile.append(System.getProperty("line.separator"));
                } while (!molFileLine.equals("M  END"));
                reader = new MDLV2000Reader(new StringReader(molFile.toString()));
                IAtomContainer product = (IAtomContainer)reader.read((IChemObject)builder.newInstance(IAtomContainer.class, new Object[0]));
                reader.close();
                reaction.addProduct(product);
            }
        }
        catch (CDKException exception) {
            throw exception;
        }
        catch (IOException | IllegalArgumentException exception) {
            logger.debug((Object)exception);
            throw new CDKException("Error while reading products", (Throwable)exception);
        }
        logger.info((Object)"Reading atom-atom mapping from file");
        IAtomContainer reactingSide = (IAtomContainer)builder.newInstance(IAtomContainer.class, new Object[0]);
        Iterator molecules = reaction.getReactants().atomContainers().iterator();
        while (molecules.hasNext()) {
            reactingSide.add((IAtomContainer)molecules.next());
        }
        IAtomContainer producedSide = (IAtomContainer)builder.newInstance(IAtomContainer.class, new Object[0]);
        molecules = reaction.getProducts().atomContainers().iterator();
        while (molecules.hasNext()) {
            producedSide.add((IAtomContainer)molecules.next());
        }
        int mappingCount = 0;
        block16: for (int i2 = 0; i2 < reactingSide.getAtomCount(); ++i2) {
            for (int j = 0; j < producedSide.getAtomCount(); ++j) {
                IAtom eductAtom = reactingSide.getAtom(i2);
                IAtom productAtom = producedSide.getAtom(j);
                if (eductAtom.getProperty((Object)"cdk:AtomAtomMapping") == null || !eductAtom.getProperty((Object)"cdk:AtomAtomMapping").equals(productAtom.getProperty((Object)"cdk:AtomAtomMapping"))) continue;
                reaction.addMapping((IMapping)builder.newInstance(IMapping.class, new Object[]{eductAtom, productAtom}));
                ++mappingCount;
                continue block16;
            }
        }
        logger.info((Object)("Mapped atom pairs: " + mappingCount));
        return reaction;
    }

    public void close() throws IOException {
        this.input.close();
    }
}

