/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.fragment;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openscience.cdk.config.Elements;
import org.openscience.cdk.graph.ConnectivityChecker;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.ILonePair;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.interfaces.ISingleElectron;

public class FunctionalGroupsFinder {
    private static final String CARBONYL_C_MARKER = "FGF-Carbonyl-C";
    private final Environment mode;

    FunctionalGroupsFinder(Environment mode) {
        Objects.requireNonNull(mode, "Given environment mode cannot be null.");
        this.mode = mode;
    }

    public static FunctionalGroupsFinder withGeneralEnvironment() {
        return new FunctionalGroupsFinder(Environment.GENERAL);
    }

    public static FunctionalGroupsFinder withFullEnvironment() {
        return new FunctionalGroupsFinder(Environment.FULL);
    }

    public static FunctionalGroupsFinder withNoEnvironment() {
        return new FunctionalGroupsFinder(Environment.NONE);
    }

    public List<IAtomContainer> extract(IAtomContainer mol) {
        return this.extract(mol, false);
    }

    public int find(int[] funGroups, IAtomContainer mol) {
        if (funGroups.length < mol.getAtomCount()) {
            throw new IllegalArgumentException("Not enough space allocated in: funGroups!");
        }
        State state = new State();
        state.markAtoms(mol);
        Arrays.fill(funGroups, -1);
        return state.markGroups(funGroups, mol);
    }

    public List<IAtomContainer> extract(IAtomContainer mol, boolean strict) {
        if (mol == null) {
            throw new NullPointerException("No molecule provided");
        }
        if (strict && !FunctionalGroupsFinder.checkConstraints(mol) || mol.isEmpty()) {
            return Collections.emptyList();
        }
        State state = new State();
        state.markAtoms(mol);
        int[] funGroups = new int[mol.getAtomCount()];
        Arrays.fill(funGroups, -1);
        int nFunGroups = state.markGroups(funGroups, mol);
        List parts = state.partitionIntoGroups(mol, funGroups, nFunGroups);
        if (this.mode == Environment.GENERAL) {
            state.expandGeneralizedEnvironments(parts);
        } else if (this.mode == Environment.FULL) {
            state.expandFullEnvironments(parts);
        }
        return parts;
    }

    public static boolean checkConstraints(IAtomContainer mol) {
        if (mol == null) {
            throw new NullPointerException("No molecule provided");
        }
        if (mol.isEmpty()) {
            return true;
        }
        for (IAtom atom : mol.atoms()) {
            if (atom.getFormalCharge() != null && atom.getFormalCharge() != 0) {
                return false;
            }
            if (State.isAllowedElement(atom)) continue;
            return false;
        }
        return ConnectivityChecker.isConnected((IAtomContainer)mol);
    }

    static enum Environment {
        NONE,
        GENERAL,
        FULL;

    }

    private static final class State {
        private final Map<IAtom, IAtom> amap = new HashMap<IAtom, IAtom>();
        private int[] hCounts;
        private HashSet<Integer> markedAtomsCache;
        private HashMap<Integer, Boolean> aromaticHeteroAtomIndicesToIsInGroupBoolMapCache;
        private HashMap<IAtom, List<EnvironmentalC>> markedAtomToConnectedEnvCMapCache;

        private State() {
        }

        private static boolean isSaturated(IAtom atom) {
            for (IBond bond : atom.bonds()) {
                if (bond.getOrder() == IBond.Order.SINGLE) continue;
                return false;
            }
            return true;
        }

        private void addHydrogens(IAtom atom, int hcount, IAtomContainer mol) {
            for (int i = 0; i < hcount; ++i) {
                IAtom tmpHydrogenAtom = (IAtom)atom.getBuilder().newInstance(IAtom.class, new Object[]{"H"});
                tmpHydrogenAtom.setAtomTypeName("H");
                tmpHydrogenAtom.setImplicitHydrogenCount(Integer.valueOf(0));
                mol.addAtom(tmpHydrogenAtom);
                mol.addBond((IBond)atom.getBuilder().newInstance(IBond.class, new Object[]{atom, tmpHydrogenAtom, IBond.Order.SINGLE}));
            }
        }

        private void addRAtoms(IAtom atom, int rcount, IAtomContainer mol) {
            for (int i = 0; i < rcount; ++i) {
                IPseudoAtom tmpRAtom = (IPseudoAtom)atom.getBuilder().newInstance(IPseudoAtom.class, new Object[]{"R"});
                tmpRAtom.setAttachPointNum(1);
                tmpRAtom.setImplicitHydrogenCount(Integer.valueOf(0));
                mol.addAtom((IAtom)tmpRAtom);
                mol.addBond((IBond)atom.getBuilder().newInstance(IBond.class, new Object[]{atom, tmpRAtom, IBond.Order.SINGLE}));
            }
        }

        private static boolean isPseudoAtom(IAtom atom) {
            Integer tmpAtomicNr = atom.getAtomicNumber();
            if (Objects.isNull(tmpAtomicNr)) {
                return true;
            }
            String tmpSymbol = atom.getSymbol();
            return tmpAtomicNr == 0 || tmpSymbol.equals("R") || tmpSymbol.equals("*") || atom instanceof IPseudoAtom;
        }

        private static boolean isHeteroatom(IAtom atom) {
            Integer tmpAtomicNr = atom.getAtomicNumber();
            if (Objects.isNull(tmpAtomicNr)) {
                return false;
            }
            int tmpAtomicNumberInt = tmpAtomicNr;
            return tmpAtomicNumberInt != 1 && tmpAtomicNumberInt != 6 && !State.isPseudoAtom(atom);
        }

        private static boolean isAllowedElement(IAtom atom) {
            Integer tmpAtomicNumber = atom.getAtomicNumber();
            if (Objects.isNull(tmpAtomicNumber)) {
                return false;
            }
            int tmpAtomicNumberInt = tmpAtomicNumber;
            return !Elements.isMetal((int)tmpAtomicNumberInt) && !Elements.isMetalloid((int)tmpAtomicNumberInt) && !State.isPseudoAtom(atom);
        }

        private void markAtoms(IAtomContainer mol) {
            this.hCounts = new int[mol.getAtomCount()];
            for (IAtom atom : mol.atoms()) {
                if (atom.getImplicitHydrogenCount() == null) {
                    this.hCounts[atom.getIndex()] = 0;
                    continue;
                }
                this.hCounts[atom.getIndex()] = atom.getImplicitHydrogenCount();
            }
            this.markedAtomsCache = new HashSet((int)((float)mol.getAtomCount() / 0.75f + 2.0f), 0.75f);
            this.aromaticHeteroAtomIndicesToIsInGroupBoolMapCache = new HashMap((int)((float)mol.getAtomCount() / 0.75f + 2.0f), 0.75f);
            for (IAtom atom : mol.atoms()) {
                int idx = atom.getIndex();
                if (this.markedAtomsCache.contains(idx)) continue;
                if (atom.isAromatic()) {
                    if (!State.isHeteroatom(atom)) continue;
                    this.aromaticHeteroAtomIndicesToIsInGroupBoolMapCache.put(idx, false);
                    continue;
                }
                int tmpAtomicNr = atom.getAtomicNumber();
                if (tmpAtomicNr == 6) {
                    boolean tmpIsMarked = false;
                    int tmpConnectedONSatomsCounter = 0;
                    block2: for (IBond bond : atom.bonds()) {
                        IAtom nbor = bond.getOther(atom);
                        if (!(nbor.getAtomicNumber() == 1 || bond.getOrder() != IBond.Order.DOUBLE && bond.getOrder() != IBond.Order.TRIPLE || bond.isAromatic())) {
                            this.markedAtomsCache.add(nbor.getIndex());
                            tmpIsMarked = true;
                            if (nbor.getAtomicNumber() != 8 || bond.getOrder() != IBond.Order.DOUBLE || atom.getBondCount() != 3) break;
                            atom.setProperty((Object)FunctionalGroupsFinder.CARBONYL_C_MARKER, (Object)true);
                            break;
                        }
                        if (nbor.getAtomicNumber() != 7 && nbor.getAtomicNumber() != 8 && nbor.getAtomicNumber() != 16 || bond.getOrder() != IBond.Order.SINGLE) continue;
                        if (!nbor.isAromatic()) {
                            this.markedAtomsCache.add(nbor.getIndex());
                            if (State.isSaturated(nbor) && ++tmpConnectedONSatomsCounter > 1 && atom.getBondCount() + this.hCounts[atom.getIndex()] == 4) {
                                tmpIsMarked = true;
                                break;
                            }
                        }
                        for (IBond bond2 : nbor.bonds()) {
                            IAtom nbor2;
                            if (bond2 == bond || (nbor2 = bond2.getOther(nbor)).getBond(atom) == null) continue;
                            this.markedAtomsCache.add(nbor.getIndex());
                            this.markedAtomsCache.add(nbor2.getIndex());
                            tmpIsMarked = true;
                            continue block2;
                        }
                    }
                    if (!tmpIsMarked) continue;
                    this.markedAtomsCache.add(idx);
                    continue;
                }
                if (tmpAtomicNr == 1) {
                    for (IBond bond : atom.bonds()) {
                        IAtom nbor = bond.getOther(atom);
                        int n = nbor.getIndex();
                        this.hCounts[n] = this.hCounts[n] + 1;
                    }
                    continue;
                }
                if (!State.isHeteroatom(atom)) continue;
                this.markedAtomsCache.add(idx);
            }
        }

        private List<IAtomContainer> partitionIntoGroups(IAtomContainer mol, int[] fgroups, int aFunctionalGroupCount) {
            ArrayList<IAtomContainer> parts = new ArrayList<IAtomContainer>(aFunctionalGroupCount);
            for (int i = 0; i < aFunctionalGroupCount; ++i) {
                parts.add((IAtomContainer)mol.getBuilder().newInstance(IAtomContainer.class, new Object[0]));
            }
            for (IAtom atom : mol.atoms()) {
                int fGroupIdx = fgroups[atom.getIndex()];
                if (fGroupIdx == -1) continue;
                IAtomContainer part = (IAtomContainer)parts.get(fGroupIdx);
                IAtom cpyAtom = part.newAtom(atom.getAtomicNumber().intValue(), this.hCounts[atom.getIndex()]);
                cpyAtom.setIsAromatic(atom.isAromatic());
                cpyAtom.setValency(atom.getValency());
                cpyAtom.setAtomTypeName(atom.getAtomTypeName());
                cpyAtom.setFormalCharge(atom.getFormalCharge());
                this.amap.put(atom, cpyAtom);
            }
            for (IBond tmpBond : mol.bonds()) {
                IAtom beg = this.amap.get(tmpBond.getBegin());
                IAtom end = this.amap.get(tmpBond.getEnd());
                if (beg == null || end == null || beg.getContainer() != end.getContainer()) continue;
                beg.getContainer().newBond(beg, end, tmpBond.getOrder());
            }
            for (ISingleElectron se : mol.singleElectrons()) {
                IAtom atom = this.amap.get(se.getAtom());
                if (Objects.isNull(atom)) continue;
                atom.getContainer().addSingleElectron(atom.getIndex());
            }
            for (ILonePair lp : mol.lonePairs()) {
                IAtom atom = this.amap.get(lp.getAtom());
                if (Objects.isNull(atom)) continue;
                atom.getContainer().addLonePair(atom.getIndex());
            }
            return parts;
        }

        private int markGroups(int[] fgroups, IAtomContainer mol) {
            this.markedAtomToConnectedEnvCMapCache = new HashMap((int)((float)mol.getAtomCount() / 0.75f + 2.0f), 0.75f);
            int funcGrpIdx = -1;
            ArrayDeque<IAtom> queue = new ArrayDeque<IAtom>();
            while (!this.markedAtomsCache.isEmpty()) {
                ++funcGrpIdx;
                queue.add(mol.getAtom(this.markedAtomsCache.iterator().next().intValue()));
                while (!queue.isEmpty()) {
                    IAtom atom = (IAtom)queue.poll();
                    this.markedAtomsCache.remove(atom.getIndex());
                    fgroups[atom.getIndex()] = funcGrpIdx;
                    ArrayList<EnvironmentalC> environmentalCarbons = new ArrayList<EnvironmentalC>();
                    for (IBond bond : atom.bonds()) {
                        IAtom nbor = bond.getOther(atom);
                        if (fgroups[nbor.getIndex()] >= 0) continue;
                        if (this.markedAtomsCache.contains(nbor.getIndex())) {
                            queue.add(nbor);
                            continue;
                        }
                        if (State.isHeteroatom(nbor) && nbor.isAromatic()) {
                            fgroups[nbor.getIndex()] = funcGrpIdx;
                            this.aromaticHeteroAtomIndicesToIsInGroupBoolMapCache.put(nbor.getIndex(), true);
                        }
                        if (nbor.getAtomicNumber() != 6) continue;
                        EnvironmentalCType carbonType = nbor.isAromatic() ? EnvironmentalCType.C_AROMATIC : EnvironmentalCType.C_ALIPHATIC;
                        environmentalCarbons.add(new EnvironmentalC(carbonType, bond, bond.getBegin().equals(nbor) ? 0 : 1));
                    }
                    this.markedAtomToConnectedEnvCMapCache.put(atom, environmentalCarbons);
                }
            }
            for (int atomIdx : this.aromaticHeteroAtomIndicesToIsInGroupBoolMapCache.keySet()) {
                if (this.aromaticHeteroAtomIndicesToIsInGroupBoolMapCache.get(atomIdx).booleanValue()) continue;
                fgroups[atomIdx] = ++funcGrpIdx;
            }
            return funcGrpIdx + 1;
        }

        private void expandGeneralizedEnvironments(List<IAtomContainer> parts) {
            HashMap<IAtom, IAtom> invMap = new HashMap<IAtom, IAtom>();
            for (Map.Entry<IAtom, IAtom> e : this.amap.entrySet()) {
                invMap.put(e.getValue(), e.getKey());
            }
            for (IAtomContainer part : parts) {
                int acount = part.getAtomCount();
                if (part.getAtomCount() == 1) {
                    IAtom cpyAtom = part.getAtom(0);
                    IAtom orgAtom = (IAtom)invMap.get(cpyAtom);
                    List<EnvironmentalC> env = this.markedAtomToConnectedEnvCMapCache.get(orgAtom);
                    if (!Objects.isNull(env)) {
                        int numEnvCarbons = env.size();
                        if (cpyAtom.getAtomicNumber() == 8 && numEnvCarbons == 1 || cpyAtom.getAtomicNumber() == 7 && numEnvCarbons == 1) {
                            this.expandEnvironment(orgAtom, part);
                            int hcount = cpyAtom.getImplicitHydrogenCount();
                            if (hcount == 0) continue;
                            this.addHydrogens(cpyAtom, hcount, part);
                            cpyAtom.setImplicitHydrogenCount(Integer.valueOf(0));
                            continue;
                        }
                        if (cpyAtom.getAtomicNumber() == 7 && numEnvCarbons == 2 || cpyAtom.getAtomicNumber() == 16 && numEnvCarbons == 1) {
                            int hcount = cpyAtom.getImplicitHydrogenCount();
                            if (hcount != 0) {
                                this.addHydrogens(cpyAtom, hcount, part);
                                cpyAtom.setImplicitHydrogenCount(Integer.valueOf(0));
                            }
                            this.expandEnvironmentGeneralized(orgAtom, part);
                            continue;
                        }
                    } else if (State.isHeteroatom(cpyAtom)) {
                        int rcount = cpyAtom.getValency();
                        Integer hcount = cpyAtom.getImplicitHydrogenCount();
                        if (hcount != null) {
                            cpyAtom.setImplicitHydrogenCount(Integer.valueOf(0));
                        }
                        this.addRAtoms(cpyAtom, rcount, part);
                        continue;
                    }
                }
                ArrayList atomToProcess = new ArrayList(part.getAtomCount());
                part.atoms().forEach(atomToProcess::add);
                for (IAtom cpyAtom : atomToProcess) {
                    IAtom orgAtom = (IAtom)invMap.get(cpyAtom);
                    List<EnvironmentalC> envCarbons = this.markedAtomToConnectedEnvCMapCache.get(orgAtom);
                    if (envCarbons == null) {
                        if (this.hCounts[orgAtom.getIndex()] != 0) {
                            cpyAtom.setImplicitHydrogenCount(Integer.valueOf(0));
                        }
                        int rcount = orgAtom.getValency() - 1;
                        this.addRAtoms(cpyAtom, rcount, part);
                    }
                    if (orgAtom.getAtomicNumber() == 6) {
                        if (Objects.isNull(orgAtom.getProperty((Object)FunctionalGroupsFinder.CARBONYL_C_MARKER))) {
                            if (this.hCounts[orgAtom.getIndex()] == 0) continue;
                            cpyAtom.setImplicitHydrogenCount(Integer.valueOf(0));
                            continue;
                        }
                        this.expandEnvironmentGeneralized(orgAtom, part);
                        continue;
                    }
                    this.expandEnvironmentGeneralized(orgAtom, part);
                }
            }
        }

        private void expandFullEnvironments(List<IAtomContainer> parts) {
            HashMap<IAtom, IAtom> invMap = new HashMap<IAtom, IAtom>();
            for (Map.Entry<IAtom, IAtom> e : this.amap.entrySet()) {
                invMap.put(e.getValue(), e.getKey());
            }
            for (IAtomContainer part : parts) {
                int acount = part.getAtomCount();
                for (int i = 0; i < acount; ++i) {
                    IAtom cpyAtom = part.getAtom(i);
                    IAtom orgAtom = (IAtom)invMap.get(cpyAtom);
                    this.expandEnvironment(orgAtom, part);
                    int implHydCount = cpyAtom.getImplicitHydrogenCount();
                    if (implHydCount == 0) continue;
                    this.addHydrogens(cpyAtom, implHydCount, part);
                    cpyAtom.setImplicitHydrogenCount(Integer.valueOf(0));
                }
            }
        }

        private void expandEnvironment(IAtom orgAtom, IAtomContainer part) {
            List<EnvironmentalC> envCarbons = this.markedAtomToConnectedEnvCMapCache.get(orgAtom);
            IAtom cpyAtom = this.amap.get(orgAtom);
            if (Objects.isNull(envCarbons) || envCarbons.isEmpty()) {
                return;
            }
            int nAromCarbons = 0;
            int nAlipCarbons = 0;
            for (EnvironmentalC envCarbon : envCarbons) {
                IAtom tmpCAtom = part.newAtom(6);
                tmpCAtom.setAtomTypeName("C");
                tmpCAtom.setImplicitHydrogenCount(Integer.valueOf(0));
                if (envCarbon.getType() == EnvironmentalCType.C_AROMATIC) {
                    tmpCAtom.setIsAromatic(true);
                    ++nAromCarbons;
                } else {
                    ++nAlipCarbons;
                }
                IBond tmpBond = envCarbon.createBond(cpyAtom, tmpCAtom);
                part.addAtom(tmpCAtom);
                part.addBond(tmpBond);
            }
        }

        private void expandEnvironmentGeneralized(IAtom orgAtom, IAtomContainer cpyPart) {
            int rcount;
            List<EnvironmentalC> envCarbons = this.markedAtomToConnectedEnvCMapCache.get(orgAtom);
            IAtom cpyAtom = this.amap.get(orgAtom);
            if (Objects.isNull(envCarbons)) {
                return;
            }
            int tmpRAtomsForCCount = rcount = envCarbons.size();
            if (cpyAtom.getAtomicNumber() == 8 && cpyAtom.getImplicitHydrogenCount() == 1) {
                this.addHydrogens(cpyAtom, 1, cpyPart);
                cpyAtom.setImplicitHydrogenCount(Integer.valueOf(0));
            } else if (State.isHeteroatom(cpyAtom)) {
                rcount += cpyAtom.getImplicitHydrogenCount().intValue();
            }
            this.addRAtoms(cpyAtom, rcount, cpyPart);
            if (cpyAtom.getImplicitHydrogenCount() != 0) {
                cpyAtom.setImplicitHydrogenCount(Integer.valueOf(0));
            }
        }
    }

    private static class EnvironmentalC {
        private final EnvironmentalCType type;
        private final int bondIndex;
        private final IBond.Order bondOrder;
        private final IBond.Stereo bondStereo;
        private final boolean[] bondFlags;

        EnvironmentalC(EnvironmentalCType type, IBond bond, int idx) {
            this.type = type;
            this.bondIndex = idx;
            this.bondOrder = bond.getOrder();
            this.bondStereo = bond.getStereo();
            this.bondFlags = bond.getFlags();
        }

        EnvironmentalCType getType() {
            return this.type;
        }

        IBond createBond(IAtom aTargetAtom, IAtom anEnvCAtom) {
            IBond tmpBond = (IBond)aTargetAtom.getBuilder().newInstance(IBond.class, new Object[0]);
            if (this.bondIndex == 0) {
                tmpBond.setAtoms(new IAtom[]{anEnvCAtom, aTargetAtom});
            } else {
                tmpBond.setAtoms(new IAtom[]{aTargetAtom, anEnvCAtom});
            }
            tmpBond.setOrder(this.bondOrder);
            tmpBond.setStereo(this.bondStereo);
            tmpBond.setFlags(this.bondFlags);
            return tmpBond;
        }
    }

    private static enum EnvironmentalCType {
        C_AROMATIC,
        C_ALIPHATIC;

    }
}

