/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.formula.rules;

import java.util.ArrayList;
import java.util.List;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.formula.IsotopeContainer;
import org.openscience.cdk.formula.IsotopePattern;
import org.openscience.cdk.formula.IsotopePatternGenerator;
import org.openscience.cdk.formula.IsotopePatternManipulator;
import org.openscience.cdk.formula.IsotopePatternSimilarity;
import org.openscience.cdk.formula.rules.IRule;
import org.openscience.cdk.interfaces.IMolecularFormula;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class IsotopePatternRule
implements IRule {
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(IsotopePatternRule.class);
    private double toleranceMass = 0.001;
    private IsotopePattern pattern;
    IsotopePatternGenerator isotopeGe = new IsotopePatternGenerator(0.01);
    private IsotopePatternSimilarity is = new IsotopePatternSimilarity();

    public IsotopePatternRule() {
        this.is.seTolerance(this.toleranceMass);
    }

    @Override
    public void setParameters(Object[] params) throws CDKException {
        if (params.length != 2) {
            throw new CDKException("IsotopePatternRule expects two parameter");
        }
        if (!(params[0] instanceof List)) {
            throw new CDKException("The parameter one must be of type List<Double[]>");
        }
        if (!(params[1] instanceof Double)) {
            throw new CDKException("The parameter two must be of type Double");
        }
        this.pattern = new IsotopePattern();
        for (double[] listISO : (List)params[0]) {
            this.pattern.addIsotope(new IsotopeContainer(listISO[0], listISO[1]));
        }
        this.is.seTolerance((Double)params[1]);
    }

    @Override
    public Object[] getParameters() {
        Object[] params = new Object[2];
        if (this.pattern == null) {
            params[0] = null;
        } else {
            ArrayList<double[]> params0 = new ArrayList<double[]>();
            for (IsotopeContainer isotope : this.pattern.getIsotopes()) {
                params0.add(new double[]{isotope.getMass(), isotope.getIntensity()});
            }
            params[0] = params0;
        }
        params[1] = this.toleranceMass;
        return params;
    }

    @Override
    public double validate(IMolecularFormula formula) throws CDKException {
        logger.info((Object)"Start validation of ", new Object[]{formula});
        IsotopePatternGenerator isotopeGe = new IsotopePatternGenerator(0.1);
        IsotopePattern patternIsoPredicted = isotopeGe.getIsotopes(formula);
        IsotopePattern patternIsoNormalize = IsotopePatternManipulator.normalize(patternIsoPredicted);
        return this.is.compare(this.pattern, patternIsoNormalize);
    }
}

