/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.dict;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import nu.xom.Attribute;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.ParsingException;
import org.openscience.cdk.dict.Dictionary;
import org.openscience.cdk.dict.EntryReact;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class OWLReact
extends Dictionary {
    private static String rdfNS = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    private static String rdfsNS = "http://www.w3.org/2000/01/rdf-schema#";

    public static Dictionary unmarshal(Reader reader) {
        ILoggingTool logger = LoggingToolFactory.createLoggingTool(OWLReact.class);
        OWLReact dict = new OWLReact();
        try {
            Builder parser = new Builder();
            Document doc = parser.build(reader);
            Element root = doc.getRootElement();
            logger.debug((Object)"Found root element: ", new Object[]{root.getQualifiedName()});
            String ownNS = root.getBaseURI();
            dict.setNS(ownNS);
            logger.debug((Object)"Found ontology namespace: ", new Object[]{ownNS});
            Elements entries = root.getChildElements();
            logger.info((Object)"Found #elements in OWL dict:", new Object[]{entries.size()});
            for (int i = 0; i < entries.size(); ++i) {
                Element entry = entries.get(i);
                if (entry.getNamespaceURI().equals(ownNS)) {
                    EntryReact dbEntry = OWLReact.unmarshal(entry, ownNS);
                    dict.addEntry(dbEntry);
                    logger.debug((Object)"Added entry: ", new Object[]{dbEntry});
                    continue;
                }
                logger.debug((Object)"Found a non-fact: ", new Object[]{entry.getQualifiedName()});
            }
        }
        catch (ParsingException ex) {
            logger.error((Object)"Dictionary is not well-formed: ", new Object[]{ex.getMessage()});
            logger.debug((Object)("Error at line " + ex.getLineNumber()), new Object[]{", column " + ex.getColumnNumber()});
            dict = null;
        }
        catch (IOException ex) {
            logger.error((Object)"Due to an IOException, the parser could not check:", new Object[]{ex.getMessage()});
            logger.debug((Object)ex);
            dict = null;
        }
        return dict;
    }

    public static EntryReact unmarshal(Element entry, String ownNS) {
        Elements paramsList;
        Elements params;
        Elements representations;
        Element description;
        ILoggingTool logger = LoggingToolFactory.createLoggingTool(OWLReact.class);
        Attribute id = entry.getAttribute("ID", rdfNS);
        logger.debug((Object)"ID: ", new Object[]{id});
        EntryReact dbEntry = new EntryReact(id.getValue());
        Element label = entry.getFirstChildElement("label", rdfsNS);
        logger.debug((Object)"label: ", new Object[]{label});
        if (label != null) {
            dbEntry.setLabel(label.getValue());
        }
        dbEntry.setClassName(entry.getQualifiedName());
        logger.debug((Object)"class name: ", new Object[]{dbEntry.getClassName()});
        Element definition = entry.getFirstChildElement("definition", ownNS);
        if (definition != null) {
            dbEntry.setDefinition(definition.getValue());
            logger.debug((Object)"definition name: ", new Object[]{definition.getValue()});
        }
        if ((description = entry.getFirstChildElement("description", ownNS)) != null) {
            dbEntry.setDescription(description.getValue());
            logger.debug((Object)"description name: ", new Object[]{description.getValue()});
        }
        if ((representations = entry.getChildElements("representation", ownNS)) != null) {
            for (int i = 0; i < representations.size(); ++i) {
                String contentRepr = representations.get(i).getAttributeValue("content");
                dbEntry.setRepresentation(contentRepr);
            }
        }
        if ((params = entry.getChildElements("parameters", ownNS)) != null) {
            for (int i = 0; i < params.size(); ++i) {
                String typeParam = params.get(i).getAttributeValue("dataType");
                typeParam = typeParam.substring(typeParam.indexOf(58) + 1, typeParam.length());
                String nameParam = params.get(i).getAttributeValue("resource");
                String value = params.get(i).getValue();
                dbEntry.setParameters(nameParam, typeParam, value);
            }
        }
        if ((paramsList = entry.getChildElements("parameterList", ownNS)) != null) {
            for (int i = 0; i < paramsList.size(); ++i) {
                Elements params2 = paramsList.get(i).getChildElements("parameter2", ownNS);
                if (params2 == null) continue;
                for (int j = 0; j < params2.size(); ++j) {
                    String paramClass = params2.get(i).getAttribute(0).getValue();
                    paramClass = paramClass.substring(paramClass.indexOf(35) + 1);
                    logger.debug((Object)"parameter class: ", new Object[]{paramClass});
                    String needsToSet = "";
                    String value = "";
                    String dataType = "";
                    Elements paramSubt1 = params2.get(i).getChildElements("isSetParameter", ownNS);
                    if (paramSubt1 != null) {
                        for (int k = 0; k < 1; ++k) {
                            needsToSet = paramSubt1.get(k).getValue();
                        }
                    }
                    Elements paramSubt2 = params2.get(i).getChildElements("value", ownNS);
                    if (paramSubt1 != null) {
                        for (int k = 0; k < 1; ++k) {
                            value = paramSubt2.get(k).getValue();
                            dataType = paramSubt2.get(k).getAttributeValue("dataType");
                            dataType = dataType.substring(dataType.indexOf(58) + 1, dataType.length());
                        }
                    }
                    ArrayList<String> pp = new ArrayList<String>();
                    pp.add(paramClass);
                    pp.add(needsToSet);
                    pp.add(dataType);
                    pp.add(value);
                    dbEntry.addParameter(pp);
                }
            }
        }
        Elements mechanismDependence = entry.getChildElements("mechanismDependence", ownNS);
        String mechanism = "";
        if (mechanismDependence != null) {
            for (int i = 0; i < mechanismDependence.size(); ++i) {
                mechanism = mechanismDependence.get(i).getAttribute(0).getValue();
                mechanism = mechanism.substring(mechanism.indexOf(35) + 1);
                logger.debug((Object)"mechanism name: ", new Object[]{mechanism});
            }
        }
        dbEntry.setMechanism(mechanism);
        Elements exampleReact = entry.getChildElements("example-Reactions", ownNS);
        if (exampleReact != null) {
            for (int i = 0; i < exampleReact.size(); ++i) {
                Elements reaction = exampleReact.get(i).getChildElements("reaction", ownNS);
                if (reaction == null) continue;
                for (int j = 0; j < reaction.size(); ++j) {
                    dbEntry.addExampleReaction(reaction.get(0).toXML());
                }
            }
        }
        return dbEntry;
    }
}

