/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.debug;

import java.util.Map;
import org.openscience.cdk.AtomContainerSet;
import org.openscience.cdk.debug.DebugChemObjectBuilder;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IChemObjectChangeEvent;
import org.openscience.cdk.interfaces.IChemObjectListener;
import org.openscience.cdk.interfaces.ISubstance;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class DebugSubstance
extends AtomContainerSet
implements ISubstance {
    private static final long serialVersionUID = 7729610512495602788L;
    ILoggingTool logger = LoggingToolFactory.createLoggingTool(DebugSubstance.class);

    public void addListener(IChemObjectListener col) {
        this.logger.debug((Object)"Adding listener: ", new Object[]{col});
        super.addListener(col);
    }

    public int getListenerCount() {
        this.logger.debug((Object)"Getting listener count: ", new Object[]{super.getListenerCount()});
        return super.getListenerCount();
    }

    public void removeListener(IChemObjectListener col) {
        this.logger.debug((Object)"Removing listener: ", new Object[]{col});
        super.removeListener(col);
    }

    public void notifyChanged() {
        this.logger.debug((Object)"Notifying changed");
        super.notifyChanged();
    }

    public void notifyChanged(IChemObjectChangeEvent evt) {
        this.logger.debug((Object)"Notifying changed event: ", new Object[]{evt});
        super.notifyChanged(evt);
    }

    public void setProperty(Object description, Object property) {
        this.logger.debug((Object)"Setting property: ", new Object[]{description + "=" + property});
        super.setProperty(description, property);
    }

    public void removeProperty(Object description) {
        this.logger.debug((Object)"Removing property: ", new Object[]{description});
        super.removeProperty(description);
    }

    public <T> T getProperty(Object description) {
        this.logger.debug((Object)"Getting property: ", new Object[]{description + "=" + super.getProperty(description)});
        return (T)super.getProperty(description);
    }

    public Map<Object, Object> getProperties() {
        this.logger.debug((Object)"Getting properties");
        return super.getProperties();
    }

    public String getID() {
        this.logger.debug((Object)"Getting ID: ", new Object[]{super.getID()});
        return super.getID();
    }

    public void setID(String identifier) {
        this.logger.debug((Object)"Setting ID: ", new Object[]{identifier});
        super.setID(identifier);
    }

    public void setFlag(int flagType, boolean flagValue) {
        this.logger.debug((Object)"Setting flag: ", new Object[]{flagType + "=" + flagValue});
        super.setFlag(flagType, flagValue);
    }

    public boolean getFlag(int flagType) {
        this.logger.debug((Object)"Setting flag: ", new Object[]{flagType + "=" + super.getFlag(flagType)});
        return super.getFlag(flagType);
    }

    public void addProperties(Map<Object, Object> properties) {
        this.logger.debug((Object)"Setting properties: ", new Object[]{properties});
        super.addProperties(properties);
    }

    public void setFlags(boolean[] flagsNew) {
        this.logger.debug((Object)"Setting flags:", new Object[]{flagsNew.length});
        super.setFlags(flagsNew);
    }

    public boolean[] getFlags() {
        this.logger.debug((Object)"Getting flags:", new Object[]{super.getFlags().length});
        return super.getFlags();
    }

    public Object clone() throws CloneNotSupportedException {
        Object clone = null;
        try {
            clone = super.clone();
        }
        catch (Exception exception) {
            this.logger.error((Object)("Could not clone DebugAtom: " + exception.getMessage()), new Object[]{exception});
            this.logger.debug((Object)exception);
        }
        return clone;
    }

    public IChemObjectBuilder getBuilder() {
        return DebugChemObjectBuilder.getInstance();
    }

    public void addAtomContainer(IAtomContainer atomContainer) {
        this.logger.debug((Object)"Adding atom container: ", new Object[]{atomContainer});
        super.addAtomContainer(atomContainer);
    }

    public void removeAtomContainer(IAtomContainer atomContainer) {
        this.logger.debug((Object)"Removing atom container: ", new Object[]{atomContainer});
        super.removeAtomContainer(atomContainer);
    }

    public void removeAllAtomContainers() {
        this.logger.debug((Object)"Removing all atom containers");
        super.removeAllAtomContainers();
    }

    public void removeAtomContainer(int pos) {
        this.logger.debug((Object)"Removing atom container at pos: ", new Object[]{pos});
        super.removeAtomContainer(pos);
    }

    public void replaceAtomContainer(int position, IAtomContainer container) {
        this.logger.debug((Object)"Replacing atom container at pos: ", new Object[]{position});
        super.replaceAtomContainer(position, container);
    }

    public boolean setMultiplier(IAtomContainer container, Double multiplier) {
        this.logger.debug((Object)"Setting multiplier for atomcontainer: ", new Object[]{container, "" + multiplier});
        return super.setMultiplier(container, multiplier);
    }

    public void setMultiplier(int position, Double multiplier) {
        this.logger.debug((Object)"Setting multiplier for atomcontainer at pos: ", new Object[]{"" + position, "" + multiplier});
        super.setMultiplier(position, multiplier);
    }

    public Double[] getMultipliers() {
        this.logger.debug((Object)"Getting multipliers array: ", new Object[]{super.getMultipliers().length});
        return super.getMultipliers();
    }

    public boolean setMultipliers(Double[] newMultipliers) {
        this.logger.debug((Object)"Setting multipliers array: ", new Object[]{newMultipliers.length});
        return super.setMultipliers(newMultipliers);
    }

    public void addAtomContainer(IAtomContainer atomContainer, double multiplier) {
        this.logger.debug((Object)"Adding atom container with multiplier: ", new Object[]{"" + multiplier, atomContainer});
        super.addAtomContainer(atomContainer, multiplier);
    }

    public void add(IAtomContainerSet atomContainerSet) {
        this.logger.debug((Object)"Adding set of atom containers: ", new Object[]{atomContainerSet});
        super.add(atomContainerSet);
    }

    public Iterable<IAtomContainer> atomContainers() {
        this.logger.debug((Object)"Getting AtomContainer iterator");
        return super.atomContainers();
    }

    public IAtomContainer getAtomContainer(int number) {
        this.logger.debug((Object)"Getting atom container at: ", new Object[]{number});
        return super.getAtomContainer(number);
    }

    public Double getMultiplier(int number) {
        this.logger.debug((Object)"Getting multiplier at: ", new Object[]{number});
        return super.getMultiplier(number);
    }

    public Double getMultiplier(IAtomContainer container) {
        this.logger.debug((Object)"Getting multiplier for atom container: ", new Object[]{container});
        return super.getMultiplier(container);
    }

    public int getAtomContainerCount() {
        this.logger.debug((Object)"Getting atom container count: ", new Object[]{super.getAtomContainerCount()});
        return super.getAtomContainerCount();
    }

    public boolean isEmpty() {
        this.logger.debug((Object)"Checking if the atom container set empty: ", new Object[]{this.atomContainerCount == 0});
        return this.atomContainerCount == 0;
    }
}

