/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.debug;

import java.util.Iterator;
import org.openscience.cdk.debug.DebugChemObjectBuilder;
import org.openscience.cdk.formula.MolecularFormulaSet;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IMolecularFormula;
import org.openscience.cdk.interfaces.IMolecularFormulaSet;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class DebugMolecularFormulaSet
extends MolecularFormulaSet
implements IMolecularFormulaSet {
    private ILoggingTool logger = LoggingToolFactory.createLoggingTool(DebugMolecularFormulaSet.class);

    public DebugMolecularFormulaSet() {
    }

    public DebugMolecularFormulaSet(IMolecularFormula formula) {
        super(formula);
    }

    public void add(IMolecularFormulaSet formulaSet) {
        this.logger.debug((Object)"Adding formula set: ", new Object[]{formulaSet});
        super.add(formulaSet);
    }

    public void addMolecularFormula(IMolecularFormula formula) {
        this.logger.debug((Object)"Adding formula: ", new Object[]{formula});
        super.addMolecularFormula(formula);
    }

    public boolean contains(IMolecularFormula formula) {
        this.logger.debug((Object)"Contains formula?: ", new Object[]{formula});
        return super.contains(formula);
    }

    public IMolecularFormula getMolecularFormula(int position) {
        this.logger.debug((Object)"Getting formula at: ", new Object[]{position});
        return super.getMolecularFormula(position);
    }

    public Iterator<IMolecularFormula> iterator() {
        this.logger.debug((Object)"Getting molecular formula iterator...");
        return super.iterator();
    }

    public Iterable<IMolecularFormula> molecularFormulas() {
        this.logger.debug((Object)"Getting molecular formula iterable...");
        return super.molecularFormulas();
    }

    public void removeAllMolecularFormulas() {
        this.logger.debug((Object)"Removing all formulas...");
        super.removeAllMolecularFormulas();
    }

    public void removeMolecularFormula(IMolecularFormula formula) {
        this.logger.debug((Object)"Removing this formula: ", new Object[]{formula});
        super.removeMolecularFormula(formula);
    }

    public void removeMolecularFormula(int position) {
        this.logger.debug((Object)"Removing the formula at position: ", new Object[]{position});
        super.removeMolecularFormula(position);
    }

    public int size() {
        this.logger.debug((Object)("Getting the size of this adduct: " + super.size()));
        return super.size();
    }

    public IChemObjectBuilder getBuilder() {
        return DebugChemObjectBuilder.getInstance();
    }
}

