/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.modeling.builder3d;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import javax.vecmath.Point3d;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.io.iterator.IteratingSDFReader;
import org.openscience.cdk.isomorphism.Mappings;
import org.openscience.cdk.isomorphism.Pattern;
import org.openscience.cdk.isomorphism.UniversalIsomorphismTester;
import org.openscience.cdk.isomorphism.matchers.IQueryAtomContainer;
import org.openscience.cdk.isomorphism.matchers.QueryAtomContainer;
import org.openscience.cdk.isomorphism.matchers.QueryAtomContainerCreator;
import org.openscience.cdk.silent.SilentChemObjectBuilder;
import org.openscience.cdk.tools.manipulator.RingSetManipulator;

public class TemplateHandler3D {
    private static final IChemObjectBuilder builder = SilentChemObjectBuilder.getInstance();
    public static final String TEMPLATE_PATH = "data/ringTemplateStructures.sdf.gz";
    private final List<IAtomContainer> templates = new ArrayList<IAtomContainer>();
    private final List<IQueryAtomContainer> queries = new ArrayList<IQueryAtomContainer>();
    private final List<Pattern> patterns = new ArrayList<Pattern>();
    private static TemplateHandler3D self = null;
    private UniversalIsomorphismTester universalIsomorphismTester = new UniversalIsomorphismTester();

    private TemplateHandler3D() {
    }

    public static TemplateHandler3D getInstance() throws CDKException {
        if (self == null) {
            self = new TemplateHandler3D();
        }
        return self;
    }

    private void addTemplateMol(IAtomContainer mol) {
        this.templates.add(mol);
        QueryAtomContainer query = QueryAtomContainerCreator.createAnyAtomAnyBondContainer((IAtomContainer)mol, (boolean)false);
        this.queries.add((IQueryAtomContainer)query);
        for (int i = 0; i < mol.getAtomCount(); ++i) {
            query.getAtom(i).setPoint3d(new Point3d(mol.getAtom(i).getPoint3d()));
        }
        this.patterns.add(Pattern.findSubstructure((IAtomContainer)query));
    }

    private void loadTemplates() throws CDKException {
        try (InputStream gin = this.getClass().getResourceAsStream(TEMPLATE_PATH);
             GZIPInputStream in = new GZIPInputStream(gin);
             IteratingSDFReader sdfr = new IteratingSDFReader((InputStream)in, builder);){
            while (sdfr.hasNext()) {
                IAtomContainer mol = sdfr.next();
                this.addTemplateMol(mol);
            }
        }
        catch (IOException e) {
            throw new CDKException("Could not load ring templates", (Throwable)e);
        }
    }

    public static BitSet getBitSetFromFile(StringTokenizer st) throws Exception {
        BitSet bitSet = new BitSet(1024);
        while (st.hasMoreTokens()) {
            bitSet.set(Integer.parseInt(st.nextToken()));
        }
        return bitSet;
    }

    public IRingSet getLargestRingSet(List<IRingSet> ringSystems) {
        IRingSet largestRingSet = null;
        int atomNumber = 0;
        IAtomContainer container = null;
        for (int i = 0; i < ringSystems.size(); ++i) {
            container = this.getAllInOneContainer(ringSystems.get(i));
            if (atomNumber >= container.getAtomCount()) continue;
            atomNumber = container.getAtomCount();
            largestRingSet = ringSystems.get(i);
        }
        return largestRingSet;
    }

    private IAtomContainer getAllInOneContainer(IRingSet ringSet) {
        IAtomContainer resultContainer = (IAtomContainer)ringSet.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        Iterator containers = RingSetManipulator.getAllAtomContainers((IRingSet)ringSet).iterator();
        while (containers.hasNext()) {
            resultContainer.add((IAtomContainer)containers.next());
        }
        return resultContainer;
    }

    @Deprecated
    public void mapTemplates(IAtomContainer ringSystems, double numberOfRingAtoms) throws CDKException, CloneNotSupportedException {
        this.mapTemplates(ringSystems, (int)numberOfRingAtoms);
    }

    private boolean isExactMatch(IAtomContainer query, Map<IChemObject, IChemObject> mapping) {
        IAtom dst;
        for (IAtom src : query.atoms()) {
            dst = (IAtom)mapping.get(src);
            if (Objects.equals(src.getSymbol(), dst.getSymbol())) continue;
            return false;
        }
        for (IAtom src : query.bonds()) {
            dst = (IBond)mapping.get(src);
            if (Objects.equals(src.getOrder(), dst.getOrder())) continue;
            return false;
        }
        return true;
    }

    public void mapTemplates(IAtomContainer mol, int numberOfRingAtoms) throws CDKException, CloneNotSupportedException {
        if (this.templates.isEmpty()) {
            this.loadTemplates();
        }
        IAtomContainer best = null;
        HashMap bestMap = null;
        IAtomContainer secondBest = null;
        HashMap secondBestMap = null;
        for (int i = 0; i < this.templates.size(); ++i) {
            IAtomContainer query = (IAtomContainer)this.queries.get(i);
            if (query.getAtomCount() != mol.getAtomCount()) continue;
            Mappings mappings = this.patterns.get(i).matchAll(mol);
            for (Map map : mappings.toAtomBondMap()) {
                if (this.isExactMatch(query, map)) {
                    this.assignCoords(query, map);
                    return;
                }
                if (query.getBondCount() == mol.getBondCount()) {
                    best = query;
                    bestMap = new HashMap(map);
                    continue;
                }
                secondBest = query;
                secondBestMap = new HashMap(map);
            }
        }
        if (best != null) {
            this.assignCoords(best, bestMap);
        } else if (secondBest != null) {
            this.assignCoords(secondBest, secondBestMap);
        }
        System.err.println("WARNING: Maybe RingTemplateError!");
    }

    private void assignCoords(IAtomContainer template, Map<IChemObject, IChemObject> map) {
        for (IAtom src : template.atoms()) {
            IAtom dst = (IAtom)map.get(src);
            dst.setPoint3d(new Point3d(src.getPoint3d()));
        }
    }

    public int getTemplateCount() {
        return this.templates.size();
    }

    public IAtomContainer getTemplateAt(int position) {
        return this.templates.get(position);
    }
}

