/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.yaml;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import org.openrewrite.internal.lang.NonNull;
import org.yaml.snakeyaml.events.Event;

class FormatPreservingReader
extends Reader {
    private final Reader delegate;
    private final boolean hasMultiBytesUnicode;
    private final int[] indexes;
    private ArrayList<Character> buffer = new ArrayList();
    private int bufferIndex = 0;

    FormatPreservingReader(String source) {
        this.delegate = new StringReader(source);
        boolean hasUnicodes = false;
        int[] pos = new int[source.length() + 1];
        int cursor = 0;
        int i = 1;
        pos[0] = 0;
        while (cursor < source.length()) {
            int newCursor = source.offsetByCodePoints(cursor, 1);
            if (newCursor > cursor + 1) {
                hasUnicodes = true;
            }
            pos[i++] = newCursor;
            cursor = newCursor;
        }
        this.hasMultiBytesUnicode = hasUnicodes;
        this.indexes = this.hasMultiBytesUnicode ? pos : new int[]{};
    }

    String prefix(int lastEnd, int startIndex) {
        if (this.hasMultiBytesUnicode) {
            lastEnd = this.indexes[lastEnd];
            startIndex = this.indexes[startIndex];
        }
        assert (lastEnd <= startIndex);
        int prefixLen = startIndex - lastEnd;
        if (prefixLen > 0) {
            char[] prefix = new char[prefixLen];
            for (int i = 0; i < prefixLen; ++i) {
                prefix[i] = this.buffer.get(lastEnd - this.bufferIndex + i).charValue();
            }
            if (lastEnd > this.bufferIndex) {
                this.buffer = new ArrayList<Character>(this.buffer.subList(lastEnd - this.bufferIndex, this.buffer.size()));
                this.bufferIndex = lastEnd;
            }
            return new String(prefix);
        }
        return "";
    }

    public String prefix(int lastEnd, Event event) {
        return this.prefix(lastEnd, event.getStartMark().getIndex());
    }

    public String readStringFromBuffer(int start, int end) {
        if (end < start) {
            return "";
        }
        if (this.hasMultiBytesUnicode) {
            start = this.indexes[start];
            end = this.indexes[end + 1] - 1;
        }
        int length = end - start + 1;
        char[] readBuff = new char[length];
        for (int i = 0; i < length; ++i) {
            int bufferOffset = start + i - this.bufferIndex;
            readBuff[i] = this.buffer.get(bufferOffset).charValue();
        }
        return new String(readBuff);
    }

    @Override
    public int read(@NonNull char[] cbuf, int off, int len) throws IOException {
        int read = this.delegate.read(cbuf, off, len);
        if (read > 0) {
            this.buffer.ensureCapacity(this.buffer.size() + read);
            for (int i = 0; i < read; ++i) {
                char e = cbuf[i];
                this.buffer.add(Character.valueOf(e));
            }
        }
        return read;
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    public int getBufferIndex() {
        return this.bufferIndex;
    }
}

