/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.yaml;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.yaml.JsonPathMatcher;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.tree.Yaml;

public final class ChangeKey
extends Recipe {
    @Option(displayName="Old key path", description="A [JsonPath](https://github.com/json-path/JsonPath) expression to locate a YAML entry.", example="$.subjects.kind")
    private final String oldKeyPath;
    @Option(displayName="New key", description="The new name for the key selected by the `oldKeyPath`.", example="kind")
    private final String newKey;

    public String getDisplayName() {
        return "Change key";
    }

    public String getInstanceNameSuffix() {
        return String.format("`%s` to `%s`", this.oldKeyPath, this.newKey);
    }

    public String getDescription() {
        return "Change a YAML mapping entry key while leaving the value intact.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final JsonPathMatcher matcher = new JsonPathMatcher(this.oldKeyPath);
        return new YamlIsoVisitor<ExecutionContext>(){

            @Override
            public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext ctx) {
                Yaml e = super.visitMappingEntry(entry, ctx);
                if (matcher.matches(this.getCursor()) && ((Yaml.Mapping.Entry)e).getKey() instanceof Yaml.Scalar) {
                    e = ((Yaml.Mapping.Entry)e).withKey(((Yaml.Scalar)((Yaml.Mapping.Entry)e).getKey()).withValue(ChangeKey.this.newKey));
                }
                return e;
            }
        };
    }

    public ChangeKey(String oldKeyPath, String newKey) {
        this.oldKeyPath = oldKeyPath;
        this.newKey = newKey;
    }

    public String getOldKeyPath() {
        return this.oldKeyPath;
    }

    public String getNewKey() {
        return this.newKey;
    }

    @NonNull
    public String toString() {
        return "ChangeKey(oldKeyPath=" + this.getOldKeyPath() + ", newKey=" + this.getNewKey() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeKey)) {
            return false;
        }
        ChangeKey other = (ChangeKey)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$oldKeyPath = this.getOldKeyPath();
        String other$oldKeyPath = other.getOldKeyPath();
        if (this$oldKeyPath == null ? other$oldKeyPath != null : !this$oldKeyPath.equals(other$oldKeyPath)) {
            return false;
        }
        String this$newKey = this.getNewKey();
        String other$newKey = other.getNewKey();
        return !(this$newKey == null ? other$newKey != null : !this$newKey.equals(other$newKey));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ChangeKey;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $oldKeyPath = this.getOldKeyPath();
        result = result * 59 + ($oldKeyPath == null ? 43 : $oldKeyPath.hashCode());
        String $newKey = this.getNewKey();
        result = result * 59 + ($newKey == null ? 43 : $newKey.hashCode());
        return result;
    }
}

