/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.yaml;

import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.yaml.AppendToSequenceVisitor;
import org.openrewrite.yaml.JsonPathMatcher;

public final class AppendToSequence
extends Recipe {
    @Option(displayName="sequence path", description="A [JsonPath](https://github.com/json-path/JsonPath) expression to locate a YAML sequence.", example="$.universe.planets")
    private final String sequencePath;
    @Option(displayName="New value", description="The new value to be appended to the sequence.", example="earth")
    private final String value;
    @Option(displayName="Optional: match existing sequence values", description="If specified, the item will only be appended if the existing sequence matches these values.", example="existingValue1", required=false)
    @Nullable
    private final List<String> existingSequenceValues;
    @Option(displayName="Optional: match existing sequence values in any order", description="If specified in combination with the above parameter, the item will only be appended if the existing sequence has the specified values in any order.", example="true", required=false)
    @Nullable
    private final Boolean matchExistingSequenceValuesInAnyOrder;

    public String getDisplayName() {
        return "Append to sequence";
    }

    public String getInstanceName() {
        return String.format("Append %s to sequence `%s`", this.value, this.sequencePath);
    }

    public String getDescription() {
        return "Append item to YAML sequence.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        JsonPathMatcher matcher = new JsonPathMatcher(this.sequencePath);
        return new AppendToSequenceVisitor(matcher, this.value, this.existingSequenceValues, Boolean.TRUE.equals(this.matchExistingSequenceValuesInAnyOrder));
    }

    public AppendToSequence(String sequencePath, String value, @Nullable List<String> existingSequenceValues, @Nullable Boolean matchExistingSequenceValuesInAnyOrder) {
        this.sequencePath = sequencePath;
        this.value = value;
        this.existingSequenceValues = existingSequenceValues;
        this.matchExistingSequenceValuesInAnyOrder = matchExistingSequenceValuesInAnyOrder;
    }

    public String getSequencePath() {
        return this.sequencePath;
    }

    public String getValue() {
        return this.value;
    }

    @Nullable
    public List<String> getExistingSequenceValues() {
        return this.existingSequenceValues;
    }

    @Nullable
    public Boolean getMatchExistingSequenceValuesInAnyOrder() {
        return this.matchExistingSequenceValuesInAnyOrder;
    }

    @NonNull
    public String toString() {
        return "AppendToSequence(sequencePath=" + this.getSequencePath() + ", value=" + this.getValue() + ", existingSequenceValues=" + this.getExistingSequenceValues() + ", matchExistingSequenceValuesInAnyOrder=" + this.getMatchExistingSequenceValuesInAnyOrder() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AppendToSequence)) {
            return false;
        }
        AppendToSequence other = (AppendToSequence)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$matchExistingSequenceValuesInAnyOrder = this.getMatchExistingSequenceValuesInAnyOrder();
        Boolean other$matchExistingSequenceValuesInAnyOrder = other.getMatchExistingSequenceValuesInAnyOrder();
        if (this$matchExistingSequenceValuesInAnyOrder == null ? other$matchExistingSequenceValuesInAnyOrder != null : !((Object)this$matchExistingSequenceValuesInAnyOrder).equals(other$matchExistingSequenceValuesInAnyOrder)) {
            return false;
        }
        String this$sequencePath = this.getSequencePath();
        String other$sequencePath = other.getSequencePath();
        if (this$sequencePath == null ? other$sequencePath != null : !this$sequencePath.equals(other$sequencePath)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        List<String> this$existingSequenceValues = this.getExistingSequenceValues();
        List<String> other$existingSequenceValues = other.getExistingSequenceValues();
        return !(this$existingSequenceValues == null ? other$existingSequenceValues != null : !((Object)this$existingSequenceValues).equals(other$existingSequenceValues));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AppendToSequence;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $matchExistingSequenceValuesInAnyOrder = this.getMatchExistingSequenceValuesInAnyOrder();
        result = result * 59 + ($matchExistingSequenceValuesInAnyOrder == null ? 43 : ((Object)$matchExistingSequenceValuesInAnyOrder).hashCode());
        String $sequencePath = this.getSequencePath();
        result = result * 59 + ($sequencePath == null ? 43 : $sequencePath.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        List<String> $existingSequenceValues = this.getExistingSequenceValues();
        result = result * 59 + ($existingSequenceValues == null ? 43 : ((Object)$existingSequenceValues).hashCode());
        return result;
    }
}

