/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.yaml.search;

import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.openrewrite.Tree;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.yaml.YamlVisitor;
import org.openrewrite.yaml.tree.Yaml;

public class FindIndentYamlVisitor<P>
extends YamlVisitor<P> {
    private final SortedMap<Integer, Long> indentFrequencies = new TreeMap<Integer, Long>();
    private final int enclosingIndent;

    public FindIndentYamlVisitor(int enclosingIndent) {
        this.enclosingIndent = enclosingIndent;
    }

    public Yaml preVisit(Yaml tree, P p) {
        String prefix = tree.getPrefix();
        AtomicBoolean takeWhile = new AtomicBoolean(true);
        if (prefix.chars().filter(c -> {
            takeWhile.set(takeWhile.get() && (c == 10 || c == 13));
            return takeWhile.get();
        }).count() > 0L) {
            char[] chars;
            int indent = 0;
            for (char c2 : chars = prefix.toCharArray()) {
                if (c2 == '\n' || c2 == '\r') {
                    indent = 0;
                    continue;
                }
                if (!Character.isWhitespace(c2)) continue;
                ++indent;
            }
            this.indentFrequencies.merge(indent - this.enclosingIndent, 1L, Long::sum);
            AtomicBoolean dropWhile = new AtomicBoolean(false);
            takeWhile.set(true);
            Map indentTypeCounts = prefix.chars().filter(c -> {
                dropWhile.set(dropWhile.get() || c != 10 && c != 13);
                return dropWhile.get();
            }).filter(c -> {
                takeWhile.set(takeWhile.get() && Character.isWhitespace(c));
                return takeWhile.get();
            }).mapToObj(c -> c == 32).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
            if (indentTypeCounts.getOrDefault(true, 0L) >= indentTypeCounts.getOrDefault(false, 0L)) {
                // empty if block
            }
        }
        return (Yaml)super.preVisit((Tree)tree, p);
    }

    public int getMostCommonIndent() {
        this.indentFrequencies.remove(0);
        return StringUtils.mostCommonIndent(this.indentFrequencies);
    }

    public long nonZeroIndents() {
        return this.indentFrequencies.tailMap(1).values().stream().mapToLong(f -> f).sum();
    }
}

