/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.yaml;

import org.openrewrite.ExecutionContext;
import org.openrewrite.HasSourcePath;
import org.openrewrite.Incubating;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Markers;
import org.openrewrite.yaml.JsonPathMatcher;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.YamlVisitor;
import org.openrewrite.yaml.tree.Yaml;

public final class ChangeValue
extends Recipe {
    @Option(displayName="Key path", description="A JsonPath expression to locate a YAML entry.", example="$.subjects.kind")
    private final String oldKeyPath;
    @Option(displayName="New value", description="The new value to set for the key identified by oldKeyPath.", example="Deployment")
    private final String value;
    @Option(displayName="Optional file matcher", description="Matching files will be modified. This is a glob expression.", required=false, example="**/application-*.yml")
    @Nullable
    @Incubating(since="7.8.0")
    private final String fileMatcher;

    public String getDisplayName() {
        return "Change value";
    }

    public String getDescription() {
        return "Change a YAML mapping entry value leaving the key intact.";
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        if (this.fileMatcher != null) {
            return new HasSourcePath(this.fileMatcher);
        }
        return null;
    }

    public YamlVisitor<ExecutionContext> getVisitor() {
        final JsonPathMatcher matcher = new JsonPathMatcher(this.oldKeyPath);
        return new YamlIsoVisitor<ExecutionContext>(){

            @Override
            public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext context) {
                Yaml e = super.visitMappingEntry(entry, context);
                if (!(!matcher.matches(this.getCursor()) || ((Yaml.Mapping.Entry)e).getValue() instanceof Yaml.Scalar && ((Yaml.Scalar)((Yaml.Mapping.Entry)e).getValue()).getValue().equals(ChangeValue.this.value))) {
                    Yaml.Anchor anchor = ((Yaml.Mapping.Entry)e).getValue() instanceof Yaml.Scalar ? ((Yaml.Scalar)((Yaml.Mapping.Entry)e).getValue()).getAnchor() : null;
                    String prefix = ((Yaml.Mapping.Entry)e).getValue() instanceof Yaml.Sequence ? ((Yaml.Sequence)((Yaml.Mapping.Entry)e).getValue()).getOpeningBracketPrefix() : ((Yaml.Mapping.Entry)e).getValue().getPrefix();
                    e = ((Yaml.Mapping.Entry)e).withValue(new Yaml.Scalar(Tree.randomId(), prefix, Markers.EMPTY, Yaml.Scalar.Style.PLAIN, anchor, ChangeValue.this.value));
                }
                return e;
            }
        };
    }

    public ChangeValue(String oldKeyPath, String value, @Nullable String fileMatcher) {
        this.oldKeyPath = oldKeyPath;
        this.value = value;
        this.fileMatcher = fileMatcher;
    }

    public String getOldKeyPath() {
        return this.oldKeyPath;
    }

    public String getValue() {
        return this.value;
    }

    @Nullable
    public String getFileMatcher() {
        return this.fileMatcher;
    }

    @NonNull
    public String toString() {
        return "ChangeValue(oldKeyPath=" + this.getOldKeyPath() + ", value=" + this.getValue() + ", fileMatcher=" + this.getFileMatcher() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeValue)) {
            return false;
        }
        ChangeValue other = (ChangeValue)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$oldKeyPath = this.getOldKeyPath();
        String other$oldKeyPath = other.getOldKeyPath();
        if (this$oldKeyPath == null ? other$oldKeyPath != null : !this$oldKeyPath.equals(other$oldKeyPath)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        String this$fileMatcher = this.getFileMatcher();
        String other$fileMatcher = other.getFileMatcher();
        return !(this$fileMatcher == null ? other$fileMatcher != null : !this$fileMatcher.equals(other$fileMatcher));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ChangeValue;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $oldKeyPath = this.getOldKeyPath();
        result = result * 59 + ($oldKeyPath == null ? 43 : $oldKeyPath.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        String $fileMatcher = this.getFileMatcher();
        result = result * 59 + ($fileMatcher == null ? 43 : $fileMatcher.hashCode());
        return result;
    }
}

