/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml.tree;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.intellij.lang.annotations.Language;
import org.openrewrite.Checksum;
import org.openrewrite.Cursor;
import org.openrewrite.FileAttributes;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Markers;
import org.openrewrite.xml.XmlParser;
import org.openrewrite.xml.XmlVisitor;
import org.openrewrite.xml.internal.WithPrefix;
import org.openrewrite.xml.internal.XmlPrinter;
import org.openrewrite.xml.tree.Content;
import org.openrewrite.xml.tree.Misc;

public interface Xml
extends Tree {
    default public <R extends Tree, P> R accept(TreeVisitor<R, P> v, P p) {
        return (R)this.acceptXml((XmlVisitor)v.adapt(XmlVisitor.class), p);
    }

    @Nullable
    default public <P> Xml acceptXml(XmlVisitor<P> v, P p) {
        return (Xml)v.defaultValue(this, p);
    }

    default public <P> boolean isAcceptable(TreeVisitor<?, P> v, P p) {
        return v.isAdaptableTo(XmlVisitor.class);
    }

    public String getPrefix();

    public Xml withPrefix(String var1);

    public Xml withPrefixUnsafe(String var1);

    public static final class Ident
    implements Xml {
        private final UUID id;
        private final String prefixUnsafe;
        private final Markers markers;
        private final String name;

        @Override
        public Ident withPrefix(String prefix) {
            return WithPrefix.onlyIfNotEqual(this, prefix);
        }

        @Override
        public String getPrefix() {
            return this.prefixUnsafe;
        }

        @Override
        public <P> Xml acceptXml(XmlVisitor<P> v, P p) {
            return v.visitIdent(this, p);
        }

        public String toString() {
            return "Ident{" + this.name + "}";
        }

        public Ident(UUID id, String prefixUnsafe, Markers markers, String name) {
            this.id = id;
            this.prefixUnsafe = prefixUnsafe;
            this.markers = markers;
            this.name = name;
        }

        public UUID getId() {
            return this.id;
        }

        public String getPrefixUnsafe() {
            return this.prefixUnsafe;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Ident)) {
                return false;
            }
            Ident other = (Ident)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        public Ident withId(UUID id) {
            return this.id == id ? this : new Ident(id, this.prefixUnsafe, this.markers, this.name);
        }

        @Override
        @NonNull
        public Ident withPrefixUnsafe(String prefixUnsafe) {
            return this.prefixUnsafe == prefixUnsafe ? this : new Ident(this.id, prefixUnsafe, this.markers, this.name);
        }

        @NonNull
        public Ident withMarkers(Markers markers) {
            return this.markers == markers ? this : new Ident(this.id, this.prefixUnsafe, markers, this.name);
        }

        @NonNull
        public Ident withName(String name) {
            return this.name == name ? this : new Ident(this.id, this.prefixUnsafe, this.markers, name);
        }
    }

    public static final class Element
    implements Xml {
        private final UUID id;
        private final String prefixUnsafe;
        private final Markers markers;
        private final List<Ident> subset;
        private final String beforeTagDelimiterPrefix;

        @Override
        public Element withPrefix(String prefix) {
            return WithPrefix.onlyIfNotEqual(this, prefix);
        }

        @Override
        public String getPrefix() {
            return this.prefixUnsafe;
        }

        @Override
        public <P> Xml acceptXml(XmlVisitor<P> v, P p) {
            return v.visitElement(this, p);
        }

        public Element(UUID id, String prefixUnsafe, Markers markers, List<Ident> subset, String beforeTagDelimiterPrefix) {
            this.id = id;
            this.prefixUnsafe = prefixUnsafe;
            this.markers = markers;
            this.subset = subset;
            this.beforeTagDelimiterPrefix = beforeTagDelimiterPrefix;
        }

        public UUID getId() {
            return this.id;
        }

        public String getPrefixUnsafe() {
            return this.prefixUnsafe;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Ident> getSubset() {
            return this.subset;
        }

        public String getBeforeTagDelimiterPrefix() {
            return this.beforeTagDelimiterPrefix;
        }

        @NonNull
        public String toString() {
            return "Xml.Element(id=" + this.getId() + ", prefixUnsafe=" + this.getPrefixUnsafe() + ", markers=" + this.getMarkers() + ", subset=" + this.getSubset() + ", beforeTagDelimiterPrefix=" + this.getBeforeTagDelimiterPrefix() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Element)) {
                return false;
            }
            Element other = (Element)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        public Element withId(UUID id) {
            return this.id == id ? this : new Element(id, this.prefixUnsafe, this.markers, this.subset, this.beforeTagDelimiterPrefix);
        }

        @Override
        @NonNull
        public Element withPrefixUnsafe(String prefixUnsafe) {
            return this.prefixUnsafe == prefixUnsafe ? this : new Element(this.id, prefixUnsafe, this.markers, this.subset, this.beforeTagDelimiterPrefix);
        }

        @NonNull
        public Element withMarkers(Markers markers) {
            return this.markers == markers ? this : new Element(this.id, this.prefixUnsafe, markers, this.subset, this.beforeTagDelimiterPrefix);
        }

        @NonNull
        public Element withSubset(List<Ident> subset) {
            return this.subset == subset ? this : new Element(this.id, this.prefixUnsafe, this.markers, subset, this.beforeTagDelimiterPrefix);
        }

        @NonNull
        public Element withBeforeTagDelimiterPrefix(String beforeTagDelimiterPrefix) {
            return this.beforeTagDelimiterPrefix == beforeTagDelimiterPrefix ? this : new Element(this.id, this.prefixUnsafe, this.markers, this.subset, beforeTagDelimiterPrefix);
        }
    }

    public static final class DocTypeDecl
    implements Xml,
    Misc {
        private final UUID id;
        private final String prefixUnsafe;
        private final Markers markers;
        private final Ident name;
        private final Ident externalId;
        private final List<Ident> internalSubset;
        @Nullable
        private final ExternalSubsets externalSubsets;
        private final String beforeTagDelimiterPrefix;

        @Override
        public DocTypeDecl withPrefix(String prefix) {
            return WithPrefix.onlyIfNotEqual(this, prefix);
        }

        @Override
        public String getPrefix() {
            return this.prefixUnsafe;
        }

        @Override
        public <P> Xml acceptXml(XmlVisitor<P> v, P p) {
            return v.visitDocTypeDecl(this, p);
        }

        public DocTypeDecl(UUID id, String prefixUnsafe, Markers markers, Ident name, Ident externalId, List<Ident> internalSubset, @Nullable ExternalSubsets externalSubsets, String beforeTagDelimiterPrefix) {
            this.id = id;
            this.prefixUnsafe = prefixUnsafe;
            this.markers = markers;
            this.name = name;
            this.externalId = externalId;
            this.internalSubset = internalSubset;
            this.externalSubsets = externalSubsets;
            this.beforeTagDelimiterPrefix = beforeTagDelimiterPrefix;
        }

        public UUID getId() {
            return this.id;
        }

        public String getPrefixUnsafe() {
            return this.prefixUnsafe;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Ident getName() {
            return this.name;
        }

        public Ident getExternalId() {
            return this.externalId;
        }

        public List<Ident> getInternalSubset() {
            return this.internalSubset;
        }

        @Nullable
        public ExternalSubsets getExternalSubsets() {
            return this.externalSubsets;
        }

        public String getBeforeTagDelimiterPrefix() {
            return this.beforeTagDelimiterPrefix;
        }

        @NonNull
        public String toString() {
            return "Xml.DocTypeDecl(id=" + this.getId() + ", prefixUnsafe=" + this.getPrefixUnsafe() + ", markers=" + this.getMarkers() + ", name=" + this.getName() + ", externalId=" + this.getExternalId() + ", internalSubset=" + this.getInternalSubset() + ", externalSubsets=" + this.getExternalSubsets() + ", beforeTagDelimiterPrefix=" + this.getBeforeTagDelimiterPrefix() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DocTypeDecl)) {
                return false;
            }
            DocTypeDecl other = (DocTypeDecl)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        public DocTypeDecl withId(UUID id) {
            return this.id == id ? this : new DocTypeDecl(id, this.prefixUnsafe, this.markers, this.name, this.externalId, this.internalSubset, this.externalSubsets, this.beforeTagDelimiterPrefix);
        }

        @Override
        @NonNull
        public DocTypeDecl withPrefixUnsafe(String prefixUnsafe) {
            return this.prefixUnsafe == prefixUnsafe ? this : new DocTypeDecl(this.id, prefixUnsafe, this.markers, this.name, this.externalId, this.internalSubset, this.externalSubsets, this.beforeTagDelimiterPrefix);
        }

        @NonNull
        public DocTypeDecl withMarkers(Markers markers) {
            return this.markers == markers ? this : new DocTypeDecl(this.id, this.prefixUnsafe, markers, this.name, this.externalId, this.internalSubset, this.externalSubsets, this.beforeTagDelimiterPrefix);
        }

        @NonNull
        public DocTypeDecl withName(Ident name) {
            return this.name == name ? this : new DocTypeDecl(this.id, this.prefixUnsafe, this.markers, name, this.externalId, this.internalSubset, this.externalSubsets, this.beforeTagDelimiterPrefix);
        }

        @NonNull
        public DocTypeDecl withExternalId(Ident externalId) {
            return this.externalId == externalId ? this : new DocTypeDecl(this.id, this.prefixUnsafe, this.markers, this.name, externalId, this.internalSubset, this.externalSubsets, this.beforeTagDelimiterPrefix);
        }

        @NonNull
        public DocTypeDecl withInternalSubset(List<Ident> internalSubset) {
            return this.internalSubset == internalSubset ? this : new DocTypeDecl(this.id, this.prefixUnsafe, this.markers, this.name, this.externalId, internalSubset, this.externalSubsets, this.beforeTagDelimiterPrefix);
        }

        @NonNull
        public DocTypeDecl withExternalSubsets(@Nullable ExternalSubsets externalSubsets) {
            return this.externalSubsets == externalSubsets ? this : new DocTypeDecl(this.id, this.prefixUnsafe, this.markers, this.name, this.externalId, this.internalSubset, externalSubsets, this.beforeTagDelimiterPrefix);
        }

        @NonNull
        public DocTypeDecl withBeforeTagDelimiterPrefix(String beforeTagDelimiterPrefix) {
            return this.beforeTagDelimiterPrefix == beforeTagDelimiterPrefix ? this : new DocTypeDecl(this.id, this.prefixUnsafe, this.markers, this.name, this.externalId, this.internalSubset, this.externalSubsets, beforeTagDelimiterPrefix);
        }

        public static final class ExternalSubsets
        implements Xml {
            private final UUID id;
            private final String prefixUnsafe;
            private final Markers markers;
            private final List<Element> elements;

            @Override
            public ExternalSubsets withPrefix(String prefix) {
                return WithPrefix.onlyIfNotEqual(this, prefix);
            }

            @Override
            public String getPrefix() {
                return this.prefixUnsafe;
            }

            public ExternalSubsets(UUID id, String prefixUnsafe, Markers markers, List<Element> elements) {
                this.id = id;
                this.prefixUnsafe = prefixUnsafe;
                this.markers = markers;
                this.elements = elements;
            }

            public UUID getId() {
                return this.id;
            }

            public String getPrefixUnsafe() {
                return this.prefixUnsafe;
            }

            public Markers getMarkers() {
                return this.markers;
            }

            public List<Element> getElements() {
                return this.elements;
            }

            @NonNull
            public String toString() {
                return "Xml.DocTypeDecl.ExternalSubsets(id=" + this.getId() + ", prefixUnsafe=" + this.getPrefixUnsafe() + ", markers=" + this.getMarkers() + ", elements=" + this.getElements() + ")";
            }

            public boolean equals(@Nullable Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ExternalSubsets)) {
                    return false;
                }
                ExternalSubsets other = (ExternalSubsets)o;
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @NonNull
            public ExternalSubsets withId(UUID id) {
                return this.id == id ? this : new ExternalSubsets(id, this.prefixUnsafe, this.markers, this.elements);
            }

            @Override
            @NonNull
            public ExternalSubsets withPrefixUnsafe(String prefixUnsafe) {
                return this.prefixUnsafe == prefixUnsafe ? this : new ExternalSubsets(this.id, prefixUnsafe, this.markers, this.elements);
            }

            @NonNull
            public ExternalSubsets withMarkers(Markers markers) {
                return this.markers == markers ? this : new ExternalSubsets(this.id, this.prefixUnsafe, markers, this.elements);
            }

            @NonNull
            public ExternalSubsets withElements(List<Element> elements) {
                return this.elements == elements ? this : new ExternalSubsets(this.id, this.prefixUnsafe, this.markers, elements);
            }
        }
    }

    public static final class Comment
    implements Xml,
    Content,
    Misc {
        private final UUID id;
        private final String prefixUnsafe;
        private final Markers markers;
        private final String text;

        @Override
        public Comment withPrefix(String prefix) {
            return WithPrefix.onlyIfNotEqual(this, prefix);
        }

        @Override
        public String getPrefix() {
            return this.prefixUnsafe;
        }

        @Override
        public <P> Xml acceptXml(XmlVisitor<P> v, P p) {
            return v.visitComment(this, p);
        }

        public Comment(UUID id, String prefixUnsafe, Markers markers, String text) {
            this.id = id;
            this.prefixUnsafe = prefixUnsafe;
            this.markers = markers;
            this.text = text;
        }

        public UUID getId() {
            return this.id;
        }

        public String getPrefixUnsafe() {
            return this.prefixUnsafe;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public String getText() {
            return this.text;
        }

        @NonNull
        public String toString() {
            return "Xml.Comment(id=" + this.getId() + ", prefixUnsafe=" + this.getPrefixUnsafe() + ", markers=" + this.getMarkers() + ", text=" + this.getText() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Comment)) {
                return false;
            }
            Comment other = (Comment)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        public Comment withId(UUID id) {
            return this.id == id ? this : new Comment(id, this.prefixUnsafe, this.markers, this.text);
        }

        @Override
        @NonNull
        public Comment withPrefixUnsafe(String prefixUnsafe) {
            return this.prefixUnsafe == prefixUnsafe ? this : new Comment(this.id, prefixUnsafe, this.markers, this.text);
        }

        @NonNull
        public Comment withMarkers(Markers markers) {
            return this.markers == markers ? this : new Comment(this.id, this.prefixUnsafe, markers, this.text);
        }

        @NonNull
        public Comment withText(String text) {
            return this.text == text ? this : new Comment(this.id, this.prefixUnsafe, this.markers, text);
        }
    }

    public static final class CharData
    implements Xml,
    Content {
        private final UUID id;
        private final String prefixUnsafe;
        private final Markers markers;
        private final boolean cdata;
        private final String text;
        private final String afterText;

        @Override
        public CharData withPrefix(String prefix) {
            return WithPrefix.onlyIfNotEqual(this, prefix);
        }

        @Override
        public String getPrefix() {
            return this.prefixUnsafe;
        }

        @Override
        public <P> Xml acceptXml(XmlVisitor<P> v, P p) {
            return v.visitCharData(this, p);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("text = \"").append(this.text).append("\"");
            if (this.afterText != null && !this.afterText.isEmpty()) {
                sb.append(" afterText = \"").append(this.afterText).append("\"");
            }
            return sb.toString();
        }

        public CharData(UUID id, String prefixUnsafe, Markers markers, boolean cdata, String text, String afterText) {
            this.id = id;
            this.prefixUnsafe = prefixUnsafe;
            this.markers = markers;
            this.cdata = cdata;
            this.text = text;
            this.afterText = afterText;
        }

        public UUID getId() {
            return this.id;
        }

        public String getPrefixUnsafe() {
            return this.prefixUnsafe;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public boolean isCdata() {
            return this.cdata;
        }

        public String getText() {
            return this.text;
        }

        public String getAfterText() {
            return this.afterText;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CharData)) {
                return false;
            }
            CharData other = (CharData)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        public CharData withId(UUID id) {
            return this.id == id ? this : new CharData(id, this.prefixUnsafe, this.markers, this.cdata, this.text, this.afterText);
        }

        @Override
        @NonNull
        public CharData withPrefixUnsafe(String prefixUnsafe) {
            return this.prefixUnsafe == prefixUnsafe ? this : new CharData(this.id, prefixUnsafe, this.markers, this.cdata, this.text, this.afterText);
        }

        @NonNull
        public CharData withMarkers(Markers markers) {
            return this.markers == markers ? this : new CharData(this.id, this.prefixUnsafe, markers, this.cdata, this.text, this.afterText);
        }

        @NonNull
        public CharData withCdata(boolean cdata) {
            return this.cdata == cdata ? this : new CharData(this.id, this.prefixUnsafe, this.markers, cdata, this.text, this.afterText);
        }

        @NonNull
        public CharData withText(String text) {
            return this.text == text ? this : new CharData(this.id, this.prefixUnsafe, this.markers, this.cdata, text, this.afterText);
        }

        @NonNull
        public CharData withAfterText(String afterText) {
            return this.afterText == afterText ? this : new CharData(this.id, this.prefixUnsafe, this.markers, this.cdata, this.text, afterText);
        }
    }

    public static final class Attribute
    implements Xml {
        private final UUID id;
        private final String prefixUnsafe;
        private final Markers markers;
        private final Ident key;
        private final String beforeEquals;
        private final Value value;

        @Override
        public Attribute withPrefix(String prefix) {
            return WithPrefix.onlyIfNotEqual(this, prefix);
        }

        @Override
        public String getPrefix() {
            return this.prefixUnsafe;
        }

        @Override
        public <P> Xml acceptXml(XmlVisitor<P> v, P p) {
            return v.visitAttribute(this, p);
        }

        public String getKeyAsString() {
            return this.key.getName();
        }

        public String getValueAsString() {
            return this.value.getValue();
        }

        public String toString() {
            return this.getKeyAsString() + "=" + this.getValueAsString();
        }

        public Attribute(UUID id, String prefixUnsafe, Markers markers, Ident key, String beforeEquals, Value value) {
            this.id = id;
            this.prefixUnsafe = prefixUnsafe;
            this.markers = markers;
            this.key = key;
            this.beforeEquals = beforeEquals;
            this.value = value;
        }

        public UUID getId() {
            return this.id;
        }

        public String getPrefixUnsafe() {
            return this.prefixUnsafe;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Ident getKey() {
            return this.key;
        }

        public String getBeforeEquals() {
            return this.beforeEquals;
        }

        public Value getValue() {
            return this.value;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Attribute)) {
                return false;
            }
            Attribute other = (Attribute)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        public Attribute withId(UUID id) {
            return this.id == id ? this : new Attribute(id, this.prefixUnsafe, this.markers, this.key, this.beforeEquals, this.value);
        }

        @Override
        @NonNull
        public Attribute withPrefixUnsafe(String prefixUnsafe) {
            return this.prefixUnsafe == prefixUnsafe ? this : new Attribute(this.id, prefixUnsafe, this.markers, this.key, this.beforeEquals, this.value);
        }

        @NonNull
        public Attribute withMarkers(Markers markers) {
            return this.markers == markers ? this : new Attribute(this.id, this.prefixUnsafe, markers, this.key, this.beforeEquals, this.value);
        }

        @NonNull
        public Attribute withKey(Ident key) {
            return this.key == key ? this : new Attribute(this.id, this.prefixUnsafe, this.markers, key, this.beforeEquals, this.value);
        }

        @NonNull
        public Attribute withBeforeEquals(String beforeEquals) {
            return this.beforeEquals == beforeEquals ? this : new Attribute(this.id, this.prefixUnsafe, this.markers, this.key, beforeEquals, this.value);
        }

        @NonNull
        public Attribute withValue(Value value) {
            return this.value == value ? this : new Attribute(this.id, this.prefixUnsafe, this.markers, this.key, this.beforeEquals, value);
        }

        public static final class Value
        implements Xml {
            private final UUID id;
            private final String prefixUnsafe;
            private final Markers markers;
            private final Quote quote;
            private final String value;

            @Override
            public Value withPrefix(String prefix) {
                return WithPrefix.onlyIfNotEqual(this, prefix);
            }

            @Override
            public String getPrefix() {
                return this.prefixUnsafe;
            }

            public Value(UUID id, String prefixUnsafe, Markers markers, Quote quote, String value) {
                this.id = id;
                this.prefixUnsafe = prefixUnsafe;
                this.markers = markers;
                this.quote = quote;
                this.value = value;
            }

            public UUID getId() {
                return this.id;
            }

            public String getPrefixUnsafe() {
                return this.prefixUnsafe;
            }

            public Markers getMarkers() {
                return this.markers;
            }

            public Quote getQuote() {
                return this.quote;
            }

            public String getValue() {
                return this.value;
            }

            @NonNull
            public String toString() {
                return "Xml.Attribute.Value(id=" + this.getId() + ", prefixUnsafe=" + this.getPrefixUnsafe() + ", markers=" + this.getMarkers() + ", quote=" + (Object)((Object)this.getQuote()) + ", value=" + this.getValue() + ")";
            }

            public boolean equals(@Nullable Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Value)) {
                    return false;
                }
                Value other = (Value)o;
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @NonNull
            public Value withId(UUID id) {
                return this.id == id ? this : new Value(id, this.prefixUnsafe, this.markers, this.quote, this.value);
            }

            @Override
            @NonNull
            public Value withPrefixUnsafe(String prefixUnsafe) {
                return this.prefixUnsafe == prefixUnsafe ? this : new Value(this.id, prefixUnsafe, this.markers, this.quote, this.value);
            }

            @NonNull
            public Value withMarkers(Markers markers) {
                return this.markers == markers ? this : new Value(this.id, this.prefixUnsafe, markers, this.quote, this.value);
            }

            @NonNull
            public Value withQuote(Quote quote) {
                return this.quote == quote ? this : new Value(this.id, this.prefixUnsafe, this.markers, quote, this.value);
            }

            @NonNull
            public Value withValue(String value) {
                return this.value == value ? this : new Value(this.id, this.prefixUnsafe, this.markers, this.quote, value);
            }

            public static enum Quote {
                Double,
                Single;

            }
        }
    }

    public static final class Tag
    implements Xml,
    Content {
        private final UUID id;
        private final String prefixUnsafe;
        private final Markers markers;
        private final String name;
        private final List<Attribute> attributes;
        @Nullable
        private final List<? extends Content> content;
        @Nullable
        private final Closing closing;
        private final String beforeTagDelimiterPrefix;

        @Override
        public Tag withPrefix(String prefix) {
            return WithPrefix.onlyIfNotEqual(this, prefix);
        }

        @Override
        public String getPrefix() {
            return this.prefixUnsafe;
        }

        public static Tag build(@Language(value="xml") String tagSource) {
            return new XmlParser().parse(tagSource).findFirst().map(Document.class::cast).orElseThrow(() -> new IllegalArgumentException("Could not parse as XML")).getRoot();
        }

        public Tag withName(String name) {
            return new Tag(this.id, this.prefixUnsafe, this.markers, name, this.attributes, this.content, this.closing == null ? null : this.closing.withName(name), this.beforeTagDelimiterPrefix);
        }

        public Tag withValue(String value) {
            CharData charData = this.content != null && this.content.get(0) instanceof CharData ? ((CharData)this.content.get(0)).withText(value) : new CharData(Tree.randomId(), "", Markers.EMPTY, false, value, "");
            return this.withContent(Collections.singletonList(charData));
        }

        public Optional<Tag> getChild(String name) {
            return this.content == null ? Optional.empty() : this.content.stream().filter(t -> t instanceof Tag).map(Tag.class::cast).filter(t -> t.getName().equals(name)).findAny();
        }

        public List<Tag> getChildren(String name) {
            return this.content == null ? Collections.emptyList() : this.content.stream().filter(t -> t instanceof Tag).map(Tag.class::cast).filter(t -> t.getName().equals(name)).collect(Collectors.toList());
        }

        public List<Tag> getChildren() {
            return this.content == null ? Collections.emptyList() : this.content.stream().filter(t -> t instanceof Tag).map(Tag.class::cast).collect(Collectors.toList());
        }

        public Tag withChildValue(String childName, String text) {
            return this.getChild(childName).map(tag -> this.withContent(this.content == null ? null : this.content.stream().map(content -> content == tag ? ((Tag)content).withValue(text) : content).collect(Collectors.toList()))).orElse(this);
        }

        public Optional<String> getValue() {
            if (this.content == null) {
                return Optional.empty();
            }
            if (this.content.size() != 1) {
                return Optional.empty();
            }
            if (this.content.get(0) instanceof CharData) {
                return Optional.ofNullable(((CharData)this.content.get(0)).getText());
            }
            return Optional.empty();
        }

        public Optional<String> getChildValue(String name) {
            return this.getChild(name).flatMap(Tag::getValue);
        }

        public Optional<Tag> getSibling(String name, Cursor cursor) {
            if (cursor.getParent() == null) {
                return Optional.empty();
            }
            Tag parent = (Tag)cursor.getParent().getValue();
            return parent.getChild(name);
        }

        public Tag withContent(@Nullable List<? extends Content> content) {
            if (this.content == content) {
                return this;
            }
            Tag tag = new Tag(this.id, this.prefixUnsafe, this.markers, this.name, this.attributes, content, this.closing, this.beforeTagDelimiterPrefix);
            if (this.closing == null && content != null && !content.isEmpty()) {
                String indentedClosingTagPrefix = this.prefixUnsafe.substring(Math.max(0, this.prefixUnsafe.lastIndexOf(10)));
                if (content.get(0) instanceof CharData) {
                    return tag.withClosing(new Closing(Tree.randomId(), content.get(0).getPrefix().contains("\n") ? indentedClosingTagPrefix : "", Markers.EMPTY, this.name, ""));
                }
                return tag.withClosing(new Closing(Tree.randomId(), indentedClosingTagPrefix, Markers.EMPTY, this.name, ""));
            }
            return tag;
        }

        @Override
        public <P> Xml acceptXml(XmlVisitor<P> v, P p) {
            return v.visitTag(this, p);
        }

        public String toString() {
            return "<" + this.name + this.attributes.stream().map(a -> " " + a.getKey().getName() + "=\"" + a.getValueAsString() + "\"").collect(Collectors.joining("")) + ">";
        }

        public Tag(UUID id, String prefixUnsafe, Markers markers, String name, List<Attribute> attributes, @Nullable List<? extends Content> content, @Nullable Closing closing, String beforeTagDelimiterPrefix) {
            this.id = id;
            this.prefixUnsafe = prefixUnsafe;
            this.markers = markers;
            this.name = name;
            this.attributes = attributes;
            this.content = content;
            this.closing = closing;
            this.beforeTagDelimiterPrefix = beforeTagDelimiterPrefix;
        }

        public UUID getId() {
            return this.id;
        }

        public String getPrefixUnsafe() {
            return this.prefixUnsafe;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public String getName() {
            return this.name;
        }

        public List<Attribute> getAttributes() {
            return this.attributes;
        }

        @Nullable
        public List<? extends Content> getContent() {
            return this.content;
        }

        @Nullable
        public Closing getClosing() {
            return this.closing;
        }

        public String getBeforeTagDelimiterPrefix() {
            return this.beforeTagDelimiterPrefix;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Tag)) {
                return false;
            }
            Tag other = (Tag)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        public Tag withId(UUID id) {
            return this.id == id ? this : new Tag(id, this.prefixUnsafe, this.markers, this.name, this.attributes, this.content, this.closing, this.beforeTagDelimiterPrefix);
        }

        @Override
        @NonNull
        public Tag withPrefixUnsafe(String prefixUnsafe) {
            return this.prefixUnsafe == prefixUnsafe ? this : new Tag(this.id, prefixUnsafe, this.markers, this.name, this.attributes, this.content, this.closing, this.beforeTagDelimiterPrefix);
        }

        @NonNull
        public Tag withMarkers(Markers markers) {
            return this.markers == markers ? this : new Tag(this.id, this.prefixUnsafe, markers, this.name, this.attributes, this.content, this.closing, this.beforeTagDelimiterPrefix);
        }

        @NonNull
        public Tag withAttributes(List<Attribute> attributes) {
            return this.attributes == attributes ? this : new Tag(this.id, this.prefixUnsafe, this.markers, this.name, attributes, this.content, this.closing, this.beforeTagDelimiterPrefix);
        }

        @NonNull
        public Tag withClosing(@Nullable Closing closing) {
            return this.closing == closing ? this : new Tag(this.id, this.prefixUnsafe, this.markers, this.name, this.attributes, this.content, closing, this.beforeTagDelimiterPrefix);
        }

        @NonNull
        public Tag withBeforeTagDelimiterPrefix(String beforeTagDelimiterPrefix) {
            return this.beforeTagDelimiterPrefix == beforeTagDelimiterPrefix ? this : new Tag(this.id, this.prefixUnsafe, this.markers, this.name, this.attributes, this.content, this.closing, beforeTagDelimiterPrefix);
        }

        public static final class Closing
        implements Xml {
            private final UUID id;
            private final String prefixUnsafe;
            private final Markers markers;
            private final String name;
            private final String beforeTagDelimiterPrefix;

            @Override
            public Closing withPrefix(String prefix) {
                return WithPrefix.onlyIfNotEqual(this, prefix);
            }

            @Override
            public String getPrefix() {
                return this.prefixUnsafe;
            }

            public String toString() {
                return "</" + this.name + ">";
            }

            public Closing(UUID id, String prefixUnsafe, Markers markers, String name, String beforeTagDelimiterPrefix) {
                this.id = id;
                this.prefixUnsafe = prefixUnsafe;
                this.markers = markers;
                this.name = name;
                this.beforeTagDelimiterPrefix = beforeTagDelimiterPrefix;
            }

            public UUID getId() {
                return this.id;
            }

            public String getPrefixUnsafe() {
                return this.prefixUnsafe;
            }

            public Markers getMarkers() {
                return this.markers;
            }

            public String getName() {
                return this.name;
            }

            public String getBeforeTagDelimiterPrefix() {
                return this.beforeTagDelimiterPrefix;
            }

            public boolean equals(@Nullable Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Closing)) {
                    return false;
                }
                Closing other = (Closing)o;
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @NonNull
            public Closing withId(UUID id) {
                return this.id == id ? this : new Closing(id, this.prefixUnsafe, this.markers, this.name, this.beforeTagDelimiterPrefix);
            }

            @Override
            @NonNull
            public Closing withPrefixUnsafe(String prefixUnsafe) {
                return this.prefixUnsafe == prefixUnsafe ? this : new Closing(this.id, prefixUnsafe, this.markers, this.name, this.beforeTagDelimiterPrefix);
            }

            @NonNull
            public Closing withMarkers(Markers markers) {
                return this.markers == markers ? this : new Closing(this.id, this.prefixUnsafe, markers, this.name, this.beforeTagDelimiterPrefix);
            }

            @NonNull
            public Closing withName(String name) {
                return this.name == name ? this : new Closing(this.id, this.prefixUnsafe, this.markers, name, this.beforeTagDelimiterPrefix);
            }

            @NonNull
            public Closing withBeforeTagDelimiterPrefix(String beforeTagDelimiterPrefix) {
                return this.beforeTagDelimiterPrefix == beforeTagDelimiterPrefix ? this : new Closing(this.id, this.prefixUnsafe, this.markers, this.name, beforeTagDelimiterPrefix);
            }
        }
    }

    public static final class ProcessingInstruction
    implements Xml,
    Content,
    Misc {
        private final UUID id;
        private final String prefixUnsafe;
        private final Markers markers;
        private final String name;
        private final CharData processingInstructions;
        private final String beforeTagDelimiterPrefix;

        @Override
        public ProcessingInstruction withPrefix(String prefix) {
            return WithPrefix.onlyIfNotEqual(this, prefix);
        }

        @Override
        public String getPrefix() {
            return this.prefixUnsafe;
        }

        @Override
        public <P> Xml acceptXml(XmlVisitor<P> v, P p) {
            return v.visitProcessingInstruction(this, p);
        }

        public ProcessingInstruction(UUID id, String prefixUnsafe, Markers markers, String name, CharData processingInstructions, String beforeTagDelimiterPrefix) {
            this.id = id;
            this.prefixUnsafe = prefixUnsafe;
            this.markers = markers;
            this.name = name;
            this.processingInstructions = processingInstructions;
            this.beforeTagDelimiterPrefix = beforeTagDelimiterPrefix;
        }

        public UUID getId() {
            return this.id;
        }

        public String getPrefixUnsafe() {
            return this.prefixUnsafe;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public String getName() {
            return this.name;
        }

        public CharData getProcessingInstructions() {
            return this.processingInstructions;
        }

        public String getBeforeTagDelimiterPrefix() {
            return this.beforeTagDelimiterPrefix;
        }

        @NonNull
        public String toString() {
            return "Xml.ProcessingInstruction(id=" + this.getId() + ", prefixUnsafe=" + this.getPrefixUnsafe() + ", markers=" + this.getMarkers() + ", name=" + this.getName() + ", processingInstructions=" + this.getProcessingInstructions() + ", beforeTagDelimiterPrefix=" + this.getBeforeTagDelimiterPrefix() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ProcessingInstruction)) {
                return false;
            }
            ProcessingInstruction other = (ProcessingInstruction)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        public ProcessingInstruction withId(UUID id) {
            return this.id == id ? this : new ProcessingInstruction(id, this.prefixUnsafe, this.markers, this.name, this.processingInstructions, this.beforeTagDelimiterPrefix);
        }

        @Override
        @NonNull
        public ProcessingInstruction withPrefixUnsafe(String prefixUnsafe) {
            return this.prefixUnsafe == prefixUnsafe ? this : new ProcessingInstruction(this.id, prefixUnsafe, this.markers, this.name, this.processingInstructions, this.beforeTagDelimiterPrefix);
        }

        @NonNull
        public ProcessingInstruction withMarkers(Markers markers) {
            return this.markers == markers ? this : new ProcessingInstruction(this.id, this.prefixUnsafe, markers, this.name, this.processingInstructions, this.beforeTagDelimiterPrefix);
        }

        @NonNull
        public ProcessingInstruction withName(String name) {
            return this.name == name ? this : new ProcessingInstruction(this.id, this.prefixUnsafe, this.markers, name, this.processingInstructions, this.beforeTagDelimiterPrefix);
        }

        @NonNull
        public ProcessingInstruction withProcessingInstructions(CharData processingInstructions) {
            return this.processingInstructions == processingInstructions ? this : new ProcessingInstruction(this.id, this.prefixUnsafe, this.markers, this.name, processingInstructions, this.beforeTagDelimiterPrefix);
        }

        @NonNull
        public ProcessingInstruction withBeforeTagDelimiterPrefix(String beforeTagDelimiterPrefix) {
            return this.beforeTagDelimiterPrefix == beforeTagDelimiterPrefix ? this : new ProcessingInstruction(this.id, this.prefixUnsafe, this.markers, this.name, this.processingInstructions, beforeTagDelimiterPrefix);
        }
    }

    public static final class XmlDecl
    implements Xml,
    Misc {
        private final UUID id;
        private final String prefixUnsafe;
        private final Markers markers;
        private final String name;
        private final List<Attribute> attributes;
        private final String beforeTagDelimiterPrefix;

        @Override
        public XmlDecl withPrefix(String prefix) {
            return WithPrefix.onlyIfNotEqual(this, prefix);
        }

        @Override
        public String getPrefix() {
            return this.prefixUnsafe;
        }

        @Override
        public <P> Xml acceptXml(XmlVisitor<P> v, P p) {
            return v.visitXmlDecl(this, p);
        }

        public XmlDecl(UUID id, String prefixUnsafe, Markers markers, String name, List<Attribute> attributes, String beforeTagDelimiterPrefix) {
            this.id = id;
            this.prefixUnsafe = prefixUnsafe;
            this.markers = markers;
            this.name = name;
            this.attributes = attributes;
            this.beforeTagDelimiterPrefix = beforeTagDelimiterPrefix;
        }

        public UUID getId() {
            return this.id;
        }

        public String getPrefixUnsafe() {
            return this.prefixUnsafe;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public String getName() {
            return this.name;
        }

        public List<Attribute> getAttributes() {
            return this.attributes;
        }

        public String getBeforeTagDelimiterPrefix() {
            return this.beforeTagDelimiterPrefix;
        }

        @NonNull
        public String toString() {
            return "Xml.XmlDecl(id=" + this.getId() + ", prefixUnsafe=" + this.getPrefixUnsafe() + ", markers=" + this.getMarkers() + ", name=" + this.getName() + ", attributes=" + this.getAttributes() + ", beforeTagDelimiterPrefix=" + this.getBeforeTagDelimiterPrefix() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof XmlDecl)) {
                return false;
            }
            XmlDecl other = (XmlDecl)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        public XmlDecl withId(UUID id) {
            return this.id == id ? this : new XmlDecl(id, this.prefixUnsafe, this.markers, this.name, this.attributes, this.beforeTagDelimiterPrefix);
        }

        @Override
        @NonNull
        public XmlDecl withPrefixUnsafe(String prefixUnsafe) {
            return this.prefixUnsafe == prefixUnsafe ? this : new XmlDecl(this.id, prefixUnsafe, this.markers, this.name, this.attributes, this.beforeTagDelimiterPrefix);
        }

        @NonNull
        public XmlDecl withMarkers(Markers markers) {
            return this.markers == markers ? this : new XmlDecl(this.id, this.prefixUnsafe, markers, this.name, this.attributes, this.beforeTagDelimiterPrefix);
        }

        @NonNull
        public XmlDecl withName(String name) {
            return this.name == name ? this : new XmlDecl(this.id, this.prefixUnsafe, this.markers, name, this.attributes, this.beforeTagDelimiterPrefix);
        }

        @NonNull
        public XmlDecl withAttributes(List<Attribute> attributes) {
            return this.attributes == attributes ? this : new XmlDecl(this.id, this.prefixUnsafe, this.markers, this.name, attributes, this.beforeTagDelimiterPrefix);
        }

        @NonNull
        public XmlDecl withBeforeTagDelimiterPrefix(String beforeTagDelimiterPrefix) {
            return this.beforeTagDelimiterPrefix == beforeTagDelimiterPrefix ? this : new XmlDecl(this.id, this.prefixUnsafe, this.markers, this.name, this.attributes, beforeTagDelimiterPrefix);
        }
    }

    public static final class Prolog
    implements Xml {
        private final UUID id;
        private final String prefixUnsafe;
        private final Markers markers;
        @Nullable
        private final XmlDecl xmlDecl;
        private final List<Misc> misc;

        @Override
        public Prolog withPrefix(String prefix) {
            return WithPrefix.onlyIfNotEqual(this, prefix);
        }

        @Override
        public String getPrefix() {
            return this.prefixUnsafe;
        }

        @Override
        public <P> Xml acceptXml(XmlVisitor<P> v, P p) {
            return v.visitProlog(this, p);
        }

        public Prolog(UUID id, String prefixUnsafe, Markers markers, @Nullable XmlDecl xmlDecl, List<Misc> misc) {
            this.id = id;
            this.prefixUnsafe = prefixUnsafe;
            this.markers = markers;
            this.xmlDecl = xmlDecl;
            this.misc = misc;
        }

        public UUID getId() {
            return this.id;
        }

        public String getPrefixUnsafe() {
            return this.prefixUnsafe;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @Nullable
        public XmlDecl getXmlDecl() {
            return this.xmlDecl;
        }

        public List<Misc> getMisc() {
            return this.misc;
        }

        @NonNull
        public String toString() {
            return "Xml.Prolog(id=" + this.getId() + ", prefixUnsafe=" + this.getPrefixUnsafe() + ", markers=" + this.getMarkers() + ", xmlDecl=" + this.getXmlDecl() + ", misc=" + this.getMisc() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Prolog)) {
                return false;
            }
            Prolog other = (Prolog)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        public Prolog withId(UUID id) {
            return this.id == id ? this : new Prolog(id, this.prefixUnsafe, this.markers, this.xmlDecl, this.misc);
        }

        @Override
        @NonNull
        public Prolog withPrefixUnsafe(String prefixUnsafe) {
            return this.prefixUnsafe == prefixUnsafe ? this : new Prolog(this.id, prefixUnsafe, this.markers, this.xmlDecl, this.misc);
        }

        @NonNull
        public Prolog withMarkers(Markers markers) {
            return this.markers == markers ? this : new Prolog(this.id, this.prefixUnsafe, markers, this.xmlDecl, this.misc);
        }

        @NonNull
        public Prolog withXmlDecl(@Nullable XmlDecl xmlDecl) {
            return this.xmlDecl == xmlDecl ? this : new Prolog(this.id, this.prefixUnsafe, this.markers, xmlDecl, this.misc);
        }

        @NonNull
        public Prolog withMisc(List<Misc> misc) {
            return this.misc == misc ? this : new Prolog(this.id, this.prefixUnsafe, this.markers, this.xmlDecl, misc);
        }
    }

    public static class Document
    implements Xml,
    SourceFile {
        private final UUID id;
        private final Path sourcePath;
        private final String prefixUnsafe;
        private final Markers markers;
        @Nullable
        private final String charsetName;
        private final boolean charsetBomMarked;
        @Nullable
        private final Checksum checksum;
        @Nullable
        private final FileAttributes fileAttributes;
        private final Prolog prolog;
        private final Tag root;
        private final String eof;

        @Override
        public Document withPrefix(String prefix) {
            return WithPrefix.onlyIfNotEqual(this, prefix);
        }

        @Override
        public String getPrefix() {
            return this.prefixUnsafe;
        }

        public Charset getCharset() {
            return this.charsetName == null ? StandardCharsets.UTF_8 : Charset.forName(this.charsetName);
        }

        public SourceFile withCharset(Charset charset) {
            return this.withCharsetName(charset.name());
        }

        public Document withEof(String eof) {
            if (this.eof.equals(eof)) {
                return this;
            }
            return new Document(this.id, this.sourcePath, this.prefixUnsafe, this.markers, this.charsetName, this.charsetBomMarked, this.checksum, this.fileAttributes, this.prolog, this.root, eof);
        }

        @Override
        public <P> Xml acceptXml(XmlVisitor<P> v, P p) {
            return v.visitDocument(this, p);
        }

        public <P> TreeVisitor<?, PrintOutputCapture<P>> printer(Cursor cursor) {
            return new XmlPrinter();
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Document)) {
                return false;
            }
            Document other = (Document)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Document;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Document(UUID id, Path sourcePath, String prefixUnsafe, Markers markers, @Nullable String charsetName, boolean charsetBomMarked, @Nullable Checksum checksum, @Nullable FileAttributes fileAttributes, Prolog prolog, Tag root, String eof) {
            this.id = id;
            this.sourcePath = sourcePath;
            this.prefixUnsafe = prefixUnsafe;
            this.markers = markers;
            this.charsetName = charsetName;
            this.charsetBomMarked = charsetBomMarked;
            this.checksum = checksum;
            this.fileAttributes = fileAttributes;
            this.prolog = prolog;
            this.root = root;
            this.eof = eof;
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public Document withId(UUID id) {
            return this.id == id ? this : new Document(id, this.sourcePath, this.prefixUnsafe, this.markers, this.charsetName, this.charsetBomMarked, this.checksum, this.fileAttributes, this.prolog, this.root, this.eof);
        }

        public Path getSourcePath() {
            return this.sourcePath;
        }

        @NonNull
        public Document withSourcePath(Path sourcePath) {
            return this.sourcePath == sourcePath ? this : new Document(this.id, sourcePath, this.prefixUnsafe, this.markers, this.charsetName, this.charsetBomMarked, this.checksum, this.fileAttributes, this.prolog, this.root, this.eof);
        }

        @Override
        @NonNull
        public Document withPrefixUnsafe(String prefixUnsafe) {
            return this.prefixUnsafe == prefixUnsafe ? this : new Document(this.id, this.sourcePath, prefixUnsafe, this.markers, this.charsetName, this.charsetBomMarked, this.checksum, this.fileAttributes, this.prolog, this.root, this.eof);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        public Document withMarkers(Markers markers) {
            return this.markers == markers ? this : new Document(this.id, this.sourcePath, this.prefixUnsafe, markers, this.charsetName, this.charsetBomMarked, this.checksum, this.fileAttributes, this.prolog, this.root, this.eof);
        }

        @NonNull
        private Document withCharsetName(@Nullable String charsetName) {
            return this.charsetName == charsetName ? this : new Document(this.id, this.sourcePath, this.prefixUnsafe, this.markers, charsetName, this.charsetBomMarked, this.checksum, this.fileAttributes, this.prolog, this.root, this.eof);
        }

        @NonNull
        public Document withCharsetBomMarked(boolean charsetBomMarked) {
            return this.charsetBomMarked == charsetBomMarked ? this : new Document(this.id, this.sourcePath, this.prefixUnsafe, this.markers, this.charsetName, charsetBomMarked, this.checksum, this.fileAttributes, this.prolog, this.root, this.eof);
        }

        public boolean isCharsetBomMarked() {
            return this.charsetBomMarked;
        }

        @NonNull
        public Document withChecksum(@Nullable Checksum checksum) {
            return this.checksum == checksum ? this : new Document(this.id, this.sourcePath, this.prefixUnsafe, this.markers, this.charsetName, this.charsetBomMarked, checksum, this.fileAttributes, this.prolog, this.root, this.eof);
        }

        @Nullable
        public Checksum getChecksum() {
            return this.checksum;
        }

        @NonNull
        public Document withFileAttributes(@Nullable FileAttributes fileAttributes) {
            return this.fileAttributes == fileAttributes ? this : new Document(this.id, this.sourcePath, this.prefixUnsafe, this.markers, this.charsetName, this.charsetBomMarked, this.checksum, fileAttributes, this.prolog, this.root, this.eof);
        }

        @Nullable
        public FileAttributes getFileAttributes() {
            return this.fileAttributes;
        }

        public Prolog getProlog() {
            return this.prolog;
        }

        @NonNull
        public Document withProlog(Prolog prolog) {
            return this.prolog == prolog ? this : new Document(this.id, this.sourcePath, this.prefixUnsafe, this.markers, this.charsetName, this.charsetBomMarked, this.checksum, this.fileAttributes, prolog, this.root, this.eof);
        }

        public Tag getRoot() {
            return this.root;
        }

        @NonNull
        public Document withRoot(Tag root) {
            return this.root == root ? this : new Document(this.id, this.sourcePath, this.prefixUnsafe, this.markers, this.charsetName, this.charsetBomMarked, this.checksum, this.fileAttributes, this.prolog, root, this.eof);
        }

        public String getEof() {
            return this.eof;
        }
    }
}

