/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.openrewrite.Incubating;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.xml.XmlVisitor;
import org.openrewrite.xml.tree.Xml;

@Incubating(since="7.17.0")
public class SemanticallyEqual {
    private SemanticallyEqual() {
    }

    public static boolean areEqual(Xml first, Xml second) {
        SemanticallyEqualVisitor sme = new SemanticallyEqualVisitor();
        sme.visit(first, second);
        return sme.areEqual;
    }

    private static boolean isNullOrEmpty(@Nullable List<?> a) {
        return a == null || a.isEmpty();
    }

    private static boolean bothNullOrEmpty(@Nullable List<?> a, @Nullable List<?> b) {
        return SemanticallyEqual.isNullOrEmpty(a) && SemanticallyEqual.isNullOrEmpty(b);
    }

    private static boolean eitherNullOrEmpty(@Nullable List<?> a, @Nullable List<?> b) {
        return SemanticallyEqual.isNullOrEmpty(a) || SemanticallyEqual.isNullOrEmpty(b);
    }

    private static class SemanticallyEqualVisitor
    extends XmlVisitor<Xml> {
        boolean areEqual = true;

        private SemanticallyEqualVisitor() {
        }

        @Override
        public Xml visitDocument(Xml.Document document, Xml other) {
            if (document == other) {
                return null;
            }
            if (!(other instanceof Xml.Document)) {
                this.areEqual = false;
                return null;
            }
            Xml.Document otherDocument = (Xml.Document)other;
            this.visitTag(document.getRoot(), otherDocument.getRoot());
            return null;
        }

        @Override
        public Xml visitTag(Xml.Tag tag, Xml other) {
            if (tag == other) {
                return null;
            }
            if (!(other instanceof Xml.Tag)) {
                this.areEqual = false;
                return null;
            }
            Xml.Tag otherTag = (Xml.Tag)other;
            if (tag.getAttributes().size() != otherTag.getAttributes().size()) {
                this.areEqual = false;
                return null;
            }
            List theseAttributes = tag.getAttributes().stream().sorted(Comparator.comparing(Xml.Attribute::getKeyAsString)).collect(Collectors.toList());
            List thoseAttributes = otherTag.getAttributes().stream().sorted(Comparator.comparing(Xml.Attribute::getKeyAsString)).collect(Collectors.toList());
            for (int i = 0; i < theseAttributes.size(); ++i) {
                this.visitAttribute((Xml.Attribute)theseAttributes.get(i), (Xml)thoseAttributes.get(i));
                if (this.areEqual) continue;
                return null;
            }
            if (SemanticallyEqual.bothNullOrEmpty(tag.getContent(), otherTag.getContent())) {
                return null;
            }
            if (SemanticallyEqual.eitherNullOrEmpty(tag.getContent(), otherTag.getContent())) {
                this.areEqual = false;
                return null;
            }
            List theseContents = tag.getContent().stream().filter(it -> it != null && !(it instanceof Xml.Comment)).collect(Collectors.toList());
            List thoseContents = otherTag.getContent().stream().filter(it -> it != null && !(it instanceof Xml.Comment)).collect(Collectors.toList());
            if (theseContents.size() != thoseContents.size()) {
                this.areEqual = false;
                return null;
            }
            for (int i = 0; i < theseContents.size(); ++i) {
                this.visit((Tree)theseContents.get(i), (Xml)thoseContents.get(i));
                if (this.areEqual) continue;
                return null;
            }
            return null;
        }

        @Override
        public Xml visitAttribute(Xml.Attribute attribute, Xml other) {
            if (attribute == other) {
                return null;
            }
            if (!(other instanceof Xml.Attribute)) {
                this.areEqual = false;
                return null;
            }
            Xml.Attribute otherAttribute = (Xml.Attribute)other;
            if (!attribute.getKeyAsString().equals(otherAttribute.getKeyAsString())) {
                this.areEqual = false;
                return null;
            }
            if (!attribute.getValueAsString().equals(otherAttribute.getValueAsString())) {
                this.areEqual = false;
                return null;
            }
            return null;
        }

        @Override
        public Xml visitCharData(Xml.CharData charData, Xml other) {
            if (charData == other) {
                return null;
            }
            if (!(other instanceof Xml.CharData)) {
                this.areEqual = false;
                return null;
            }
            Xml.CharData otherChar = (Xml.CharData)other;
            if (!charData.getText().trim().equals(otherChar.getText().trim())) {
                this.areEqual = false;
                return null;
            }
            return null;
        }
    }
}

