/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.toml;

import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.toml.TomlIsoVisitor;
import org.openrewrite.toml.TomlPathMatcher;
import org.openrewrite.toml.tree.Toml;

public final class DeleteKey
extends Recipe {
    @Option(displayName="Key path", description="A TOML path expression to locate a key.", example="package.keywords")
    private final String keyPath;

    public String getDisplayName() {
        return "Delete TOML key";
    }

    public String getDescription() {
        return "Delete a TOML key-value pair.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final TomlPathMatcher matcher = new TomlPathMatcher(this.keyPath);
        return new TomlIsoVisitor<ExecutionContext>(){

            @Override
            public @Nullable Toml.KeyValue visitKeyValue(Toml.KeyValue keyValue, ExecutionContext ctx) {
                Toml kv = super.visitKeyValue(keyValue, ctx);
                return matcher.matches(this.getCursor()) ? null : kv;
            }
        };
    }

    @Generated
    public DeleteKey(String keyPath) {
        this.keyPath = keyPath;
    }

    @Generated
    public String getKeyPath() {
        return this.keyPath;
    }

    @NonNull
    @Generated
    public String toString() {
        return "DeleteKey(keyPath=" + this.getKeyPath() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeleteKey)) {
            return false;
        }
        DeleteKey other = (DeleteKey)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$keyPath = this.getKeyPath();
        String other$keyPath = other.getKeyPath();
        return !(this$keyPath == null ? other$keyPath != null : !this$keyPath.equals(other$keyPath));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof DeleteKey;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $keyPath = this.getKeyPath();
        result = result * 59 + ($keyPath == null ? 43 : $keyPath.hashCode());
        return result;
    }
}

