/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.template.processor;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.openrewrite.java.template.internal.StringUtils;

public abstract class Precondition {
    private static final Comparator<String> BY_USES_TYPE_METHOD_FIRST = Comparator.comparing(s -> {
        if (s.startsWith("new UsesType")) {
            return 0;
        }
        if (s.startsWith("new UsesMethod")) {
            return 1;
        }
        return 2;
    }).thenComparing(Comparator.naturalOrder());

    abstract boolean fitsInto(Precondition var1);

    public Precondition prune() {
        return this;
    }

    private static String joinPreconditions(Collection<Precondition> rules, String op) {
        if (rules.isEmpty()) {
            return "";
        }
        if (rules.size() == 1) {
            return rules.iterator().next().toString();
        }
        String preconditions = rules.stream().map(Object::toString).sorted(BY_USES_TYPE_METHOD_FIRST).collect(Collectors.joining(",\n"));
        return "Preconditions." + op + "(\n" + StringUtils.indent(preconditions, 8) + "\n)";
    }

    public static final class And
    extends Precondition {
        private final Set<Precondition> preconditions;

        public And(Precondition ... preconditions) {
            this.preconditions = new HashSet<Precondition>(Arrays.asList(preconditions));
        }

        @Override
        boolean fitsInto(Precondition p) {
            if (p instanceof And) {
                if (this.preconditions.size() > ((And)p).preconditions.size()) {
                    return false;
                }
                return this.preconditions.stream().allMatch(it -> it.fitsInto(p));
            }
            return false;
        }

        public String toString() {
            return Precondition.joinPreconditions(this.preconditions, "and");
        }

        @Generated
        public Set<Precondition> getPreconditions() {
            return this.preconditions;
        }

        @Generated
        public And(Set<Precondition> preconditions) {
            this.preconditions = preconditions;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof And)) {
                return false;
            }
            And other = (And)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Set<Precondition> this$preconditions = this.getPreconditions();
            Set<Precondition> other$preconditions = other.getPreconditions();
            return !(this$preconditions == null ? other$preconditions != null : !((Object)this$preconditions).equals(other$preconditions));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof And;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Set<Precondition> $preconditions = this.getPreconditions();
            result = result * 59 + ($preconditions == null ? 43 : ((Object)$preconditions).hashCode());
            return result;
        }
    }

    public static final class Or
    extends Precondition {
        private final Set<Precondition> preconditions;

        public Or(Precondition ... preconditions) {
            this.preconditions = new HashSet<Precondition>(Arrays.asList(preconditions));
        }

        @Override
        boolean fitsInto(Precondition p) {
            if (p instanceof Or) {
                return this.equals(p);
            }
            return false;
        }

        @Override
        public Precondition prune() {
            Precondition pruned = this.takeElementIfItFitsInAllOtherElements();
            return pruned == null ? this.extractCommonElements() : pruned;
        }

        private Precondition takeElementIfItFitsInAllOtherElements() {
            for (Precondition p : this.preconditions) {
                int matches = 0;
                for (Precondition p2 : this.preconditions) {
                    if (p == p2 || p.fitsInto(p2)) {
                        ++matches;
                    }
                    if (matches != this.preconditions.size()) continue;
                    return p;
                }
            }
            return null;
        }

        private Precondition extractCommonElements() {
            boolean first = true;
            HashSet<Precondition> commons = new HashSet<Precondition>();
            for (Precondition p : this.preconditions) {
                if (!(p instanceof And)) {
                    return this;
                }
                if (first) {
                    commons.addAll(((And)p).preconditions);
                    first = false;
                    continue;
                }
                commons.retainAll(((And)p).preconditions);
            }
            if (!commons.isEmpty()) {
                this.preconditions.forEach(it -> ((And)it).preconditions.removeAll(commons));
                commons.add(new Or(this.preconditions));
                return new And(commons);
            }
            return this;
        }

        public String toString() {
            return Precondition.joinPreconditions(this.preconditions, "or");
        }

        @Generated
        public Set<Precondition> getPreconditions() {
            return this.preconditions;
        }

        @Generated
        public Or(Set<Precondition> preconditions) {
            this.preconditions = preconditions;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Or)) {
                return false;
            }
            Or other = (Or)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Set<Precondition> this$preconditions = this.getPreconditions();
            Set<Precondition> other$preconditions = other.getPreconditions();
            return !(this$preconditions == null ? other$preconditions != null : !((Object)this$preconditions).equals(other$preconditions));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Or;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Set<Precondition> $preconditions = this.getPreconditions();
            result = result * 59 + ($preconditions == null ? 43 : ((Object)$preconditions).hashCode());
            return result;
        }
    }

    public static final class Rule
    extends Precondition {
        private final String rule;

        @Override
        boolean fitsInto(Precondition p) {
            if (p instanceof Rule) {
                return this.equals(p);
            }
            if (p instanceof Or) {
                return ((Or)p).preconditions.stream().anyMatch(this::fitsInto);
            }
            if (p instanceof And) {
                return ((And)p).preconditions.stream().anyMatch(this::fitsInto);
            }
            return false;
        }

        public String toString() {
            return this.rule;
        }

        @Generated
        public Rule(String rule) {
            this.rule = rule;
        }

        @Generated
        public String getRule() {
            return this.rule;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Rule)) {
                return false;
            }
            Rule other = (Rule)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$rule = this.getRule();
            String other$rule = other.getRule();
            return !(this$rule == null ? other$rule != null : !this$rule.equals(other$rule));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Rule;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $rule = this.getRule();
            result = result * 59 + ($rule == null ? 43 : $rule.hashCode());
            return result;
        }
    }
}

