/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.yaml.remote;

import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.UUID;
import java.util.function.Function;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Checksum;
import org.openrewrite.Cursor;
import org.openrewrite.FileAttributes;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.remote.Receiver;
import org.openrewrite.remote.ReceiverContext;
import org.openrewrite.remote.ReceiverFactory;
import org.openrewrite.yaml.YamlVisitor;
import org.openrewrite.yaml.tree.Yaml;

public final class YamlReceiver
implements Receiver<Yaml> {
    @Override
    public Yaml receive(@Nullable Yaml before, ReceiverContext ctx) {
        ReceiverContext forked = this.fork(ctx);
        return (Yaml)forked.getVisitor().visit((Tree)before, (Object)forked);
    }

    @Override
    public ReceiverContext fork(ReceiverContext ctx) {
        return ctx.fork((TreeVisitor<?, ReceiverContext>)new Visitor(), new Factory());
    }

    @Generated
    public YamlReceiver() {
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof YamlReceiver;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Generated
    public String toString() {
        return "YamlReceiver()";
    }

    private static class Visitor
    extends YamlVisitor<ReceiverContext> {
        private Visitor() {
        }

        public @Nullable Yaml visit(@Nullable Tree tree, ReceiverContext ctx) {
            Cursor cursor = new Cursor(this.getCursor(), (Object)tree);
            this.setCursor(cursor);
            tree = (Tree)ctx.receiveNode((Yaml)tree, ctx::receiveTree);
            this.setCursor(cursor.getParent());
            return (Yaml)tree;
        }

        public Yaml.Documents visitDocuments(Yaml.Documents documents, ReceiverContext ctx) {
            documents = documents.withId(ctx.receiveNonNullValue(documents.getId(), UUID.class));
            documents = documents.withMarkers(ctx.receiveNonNullNode(documents.getMarkers(), ctx::receiveMarkers));
            documents = documents.withSourcePath(ctx.receiveNonNullValue(documents.getSourcePath(), Path.class));
            String charsetName = ctx.receiveValue((documents = documents.withFileAttributes(ctx.receiveValue(documents.getFileAttributes(), FileAttributes.class))).getCharset().name(), String.class);
            if (charsetName != null) {
                documents = (Yaml.Documents)documents.withCharset(Charset.forName(charsetName));
            }
            documents = documents.withCharsetBomMarked(ctx.receiveNonNullValue(documents.isCharsetBomMarked(), Boolean.TYPE).booleanValue());
            documents = documents.withChecksum(ctx.receiveValue(documents.getChecksum(), Checksum.class));
            documents = documents.withDocuments(ctx.receiveNonNullNodes(documents.getDocuments(), ctx::receiveTree));
            return documents;
        }

        public Yaml.Document visitDocument(Yaml.Document document, ReceiverContext ctx) {
            document = document.withId(ctx.receiveNonNullValue(document.getId(), UUID.class));
            document = document.withPrefix(ctx.receiveNonNullValue(document.getPrefix(), String.class));
            document = document.withMarkers(ctx.receiveNonNullNode(document.getMarkers(), ctx::receiveMarkers));
            document = document.withExplicit(ctx.receiveNonNullValue(document.isExplicit(), Boolean.TYPE).booleanValue());
            document = document.withBlock(ctx.receiveNonNullNode(document.getBlock(), ctx::receiveTree));
            document = document.withEnd(ctx.receiveNonNullNode(document.getEnd(), ctx::receiveTree));
            return document;
        }

        public Yaml.Document.End visitDocumentEnd(Yaml.Document.End end, ReceiverContext ctx) {
            end = end.withId(ctx.receiveNonNullValue(end.getId(), UUID.class));
            end = end.withPrefix(ctx.receiveNonNullValue(end.getPrefix(), String.class));
            end = end.withMarkers(ctx.receiveNonNullNode(end.getMarkers(), ctx::receiveMarkers));
            end = end.withExplicit(ctx.receiveNonNullValue(end.isExplicit(), Boolean.TYPE).booleanValue());
            return end;
        }

        public Yaml.Scalar visitScalar(Yaml.Scalar scalar, ReceiverContext ctx) {
            scalar = scalar.withId(ctx.receiveNonNullValue(scalar.getId(), UUID.class));
            scalar = scalar.withPrefix(ctx.receiveNonNullValue(scalar.getPrefix(), String.class));
            scalar = scalar.withMarkers(ctx.receiveNonNullNode(scalar.getMarkers(), ctx::receiveMarkers));
            scalar = scalar.withStyle(ctx.receiveNonNullValue(scalar.getStyle(), Yaml.Scalar.Style.class));
            scalar = scalar.withAnchor(ctx.receiveNode(scalar.getAnchor(), ctx::receiveTree));
            scalar = scalar.withTag(ctx.receiveNode(scalar.getTag(), ctx::receiveTree));
            scalar = scalar.withValue(ctx.receiveNonNullValue(scalar.getValue(), String.class));
            return scalar;
        }

        public Yaml.Mapping visitMapping(Yaml.Mapping mapping, ReceiverContext ctx) {
            mapping = mapping.withId(ctx.receiveNonNullValue(mapping.getId(), UUID.class));
            mapping = mapping.withMarkers(ctx.receiveNonNullNode(mapping.getMarkers(), ctx::receiveMarkers));
            mapping = mapping.withOpeningBracePrefix(ctx.receiveValue(mapping.getOpeningBracePrefix(), String.class));
            mapping = mapping.withEntries(ctx.receiveNonNullNodes(mapping.getEntries(), ctx::receiveTree));
            mapping = mapping.withClosingBracePrefix(ctx.receiveValue(mapping.getClosingBracePrefix(), String.class));
            mapping = mapping.withAnchor(ctx.receiveNode(mapping.getAnchor(), ctx::receiveTree));
            mapping = mapping.withTag(ctx.receiveNode(mapping.getTag(), ctx::receiveTree));
            return mapping;
        }

        public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, ReceiverContext ctx) {
            entry = entry.withId(ctx.receiveNonNullValue(entry.getId(), UUID.class));
            entry = entry.withPrefix(ctx.receiveNonNullValue(entry.getPrefix(), String.class));
            entry = entry.withMarkers(ctx.receiveNonNullNode(entry.getMarkers(), ctx::receiveMarkers));
            entry = entry.withKey(ctx.receiveNonNullNode(entry.getKey(), ctx::receiveTree));
            entry = entry.withBeforeMappingValueIndicator(ctx.receiveNonNullValue(entry.getBeforeMappingValueIndicator(), String.class));
            entry = entry.withValue(ctx.receiveNonNullNode(entry.getValue(), ctx::receiveTree));
            return entry;
        }

        public Yaml.Sequence visitSequence(Yaml.Sequence sequence, ReceiverContext ctx) {
            sequence = sequence.withId(ctx.receiveNonNullValue(sequence.getId(), UUID.class));
            sequence = sequence.withMarkers(ctx.receiveNonNullNode(sequence.getMarkers(), ctx::receiveMarkers));
            sequence = sequence.withOpeningBracketPrefix(ctx.receiveValue(sequence.getOpeningBracketPrefix(), String.class));
            sequence = sequence.withEntries(ctx.receiveNonNullNodes(sequence.getEntries(), ctx::receiveTree));
            sequence = sequence.withClosingBracketPrefix(ctx.receiveValue(sequence.getClosingBracketPrefix(), String.class));
            sequence = sequence.withAnchor(ctx.receiveNode(sequence.getAnchor(), ctx::receiveTree));
            sequence = sequence.withTag(ctx.receiveNode(sequence.getTag(), ctx::receiveTree));
            return sequence;
        }

        public Yaml.Sequence.Entry visitSequenceEntry(Yaml.Sequence.Entry entry, ReceiverContext ctx) {
            entry = entry.withId(ctx.receiveNonNullValue(entry.getId(), UUID.class));
            entry = entry.withPrefix(ctx.receiveNonNullValue(entry.getPrefix(), String.class));
            entry = entry.withMarkers(ctx.receiveNonNullNode(entry.getMarkers(), ctx::receiveMarkers));
            entry = entry.withBlock(ctx.receiveNonNullNode(entry.getBlock(), ctx::receiveTree));
            entry = entry.withDash(ctx.receiveNonNullValue(entry.isDash(), Boolean.TYPE).booleanValue());
            entry = entry.withTrailingCommaPrefix(ctx.receiveValue(entry.getTrailingCommaPrefix(), String.class));
            return entry;
        }

        public Yaml.Alias visitAlias(Yaml.Alias alias, ReceiverContext ctx) {
            alias = alias.withId(ctx.receiveNonNullValue(alias.getId(), UUID.class));
            alias = alias.withPrefix(ctx.receiveNonNullValue(alias.getPrefix(), String.class));
            alias = alias.withMarkers(ctx.receiveNonNullNode(alias.getMarkers(), ctx::receiveMarkers));
            alias = alias.withAnchor(ctx.receiveNonNullNode(alias.getAnchor(), ctx::receiveTree));
            return alias;
        }

        public Yaml.Anchor visitAnchor(Yaml.Anchor anchor, ReceiverContext ctx) {
            anchor = anchor.withId(ctx.receiveNonNullValue(anchor.getId(), UUID.class));
            anchor = anchor.withPrefix(ctx.receiveNonNullValue(anchor.getPrefix(), String.class));
            anchor = anchor.withPostfix(ctx.receiveNonNullValue(anchor.getPostfix(), String.class));
            anchor = anchor.withMarkers(ctx.receiveNonNullNode(anchor.getMarkers(), ctx::receiveMarkers));
            anchor = anchor.withKey(ctx.receiveNonNullValue(anchor.getKey(), String.class));
            return anchor;
        }

        public Yaml.Tag visitTag(Yaml.Tag tag, ReceiverContext ctx) {
            tag = tag.withId(ctx.receiveNonNullValue(tag.getId(), UUID.class));
            tag = tag.withPrefix(ctx.receiveNonNullValue(tag.getPrefix(), String.class));
            tag = tag.withMarkers(ctx.receiveNonNullNode(tag.getMarkers(), ctx::receiveMarkers));
            tag = tag.withName(ctx.receiveNonNullValue(tag.getName(), String.class));
            tag = tag.withSuffix(ctx.receiveNonNullValue(tag.getSuffix(), String.class));
            tag = tag.withKind(ctx.receiveNonNullValue(tag.getKind(), Yaml.Tag.Kind.class));
            return tag;
        }
    }

    private static class Factory
    implements ReceiverFactory {
        private final ClassValue<Function<ReceiverContext, Object>> factories = new ClassValue<Function<ReceiverContext, Object>>(){

            @Override
            protected Function<ReceiverContext, Object> computeValue(Class type) {
                if (type == Yaml.Documents.class) {
                    return x$0 -> Factory.createYamlDocuments(x$0);
                }
                if (type == Yaml.Document.class) {
                    return x$0 -> Factory.createYamlDocument(x$0);
                }
                if (type == Yaml.Document.End.class) {
                    return x$0 -> Factory.createYamlDocumentEnd(x$0);
                }
                if (type == Yaml.Scalar.class) {
                    return x$0 -> Factory.createYamlScalar(x$0);
                }
                if (type == Yaml.Mapping.class) {
                    return x$0 -> Factory.createYamlMapping(x$0);
                }
                if (type == Yaml.Mapping.Entry.class) {
                    return x$0 -> Factory.createYamlMappingEntry(x$0);
                }
                if (type == Yaml.Sequence.class) {
                    return x$0 -> Factory.createYamlSequence(x$0);
                }
                if (type == Yaml.Sequence.Entry.class) {
                    return x$0 -> Factory.createYamlSequenceEntry(x$0);
                }
                if (type == Yaml.Alias.class) {
                    return x$0 -> Factory.createYamlAlias(x$0);
                }
                if (type == Yaml.Anchor.class) {
                    return x$0 -> Factory.createYamlAnchor(x$0);
                }
                if (type == Yaml.Tag.class) {
                    return x$0 -> Factory.createYamlTag(x$0);
                }
                throw new IllegalArgumentException("Unknown type: " + type);
            }
        };

        private Factory() {
        }

        @Override
        public <T> T create(Class<T> type, ReceiverContext ctx) {
            return (T)this.factories.get(type).apply(ctx);
        }

        private static Yaml.Documents createYamlDocuments(ReceiverContext ctx) {
            return new Yaml.Documents(ctx.receiveNonNullValue(null, UUID.class), ctx.receiveNonNullNode(null, ctx::receiveMarkers), ctx.receiveNonNullValue(null, Path.class), ctx.receiveValue(null, FileAttributes.class), ctx.receiveValue(null, String.class), ctx.receiveNonNullValue(null, Boolean.TYPE).booleanValue(), ctx.receiveValue(null, Checksum.class), ctx.receiveNonNullNodes(null, ctx::receiveTree));
        }

        private static Yaml.Document createYamlDocument(ReceiverContext ctx) {
            return new Yaml.Document(ctx.receiveNonNullValue(null, UUID.class), ctx.receiveNonNullValue(null, String.class), ctx.receiveNonNullNode(null, ctx::receiveMarkers), ctx.receiveNonNullValue(null, Boolean.TYPE).booleanValue(), ctx.receiveNonNullNode(null, ctx::receiveTree), ctx.receiveNonNullNode(null, ctx::receiveTree));
        }

        private static Yaml.Document.End createYamlDocumentEnd(ReceiverContext ctx) {
            return new Yaml.Document.End(ctx.receiveNonNullValue(null, UUID.class), ctx.receiveNonNullValue(null, String.class), ctx.receiveNonNullNode(null, ctx::receiveMarkers), ctx.receiveNonNullValue(null, Boolean.TYPE).booleanValue());
        }

        private static Yaml.Scalar createYamlScalar(ReceiverContext ctx) {
            return new Yaml.Scalar(ctx.receiveNonNullValue(null, UUID.class), ctx.receiveNonNullValue(null, String.class), ctx.receiveNonNullNode(null, ctx::receiveMarkers), ctx.receiveNonNullValue(null, Yaml.Scalar.Style.class), ctx.receiveNode(null, ctx::receiveTree), ctx.receiveNode(null, ctx::receiveTree), ctx.receiveNonNullValue(null, String.class));
        }

        private static Yaml.Mapping createYamlMapping(ReceiverContext ctx) {
            return new Yaml.Mapping(ctx.receiveNonNullValue(null, UUID.class), ctx.receiveNonNullNode(null, ctx::receiveMarkers), ctx.receiveValue(null, String.class), ctx.receiveNonNullNodes(null, ctx::receiveTree), ctx.receiveValue(null, String.class), ctx.receiveNode(null, ctx::receiveTree), ctx.receiveNode(null, ctx::receiveTree));
        }

        private static Yaml.Mapping.Entry createYamlMappingEntry(ReceiverContext ctx) {
            return new Yaml.Mapping.Entry(ctx.receiveNonNullValue(null, UUID.class), ctx.receiveNonNullValue(null, String.class), ctx.receiveNonNullNode(null, ctx::receiveMarkers), ctx.receiveNonNullNode(null, ctx::receiveTree), ctx.receiveNonNullValue(null, String.class), ctx.receiveNonNullNode(null, ctx::receiveTree));
        }

        private static Yaml.Sequence createYamlSequence(ReceiverContext ctx) {
            return new Yaml.Sequence(ctx.receiveNonNullValue(null, UUID.class), ctx.receiveNonNullNode(null, ctx::receiveMarkers), ctx.receiveValue(null, String.class), ctx.receiveNonNullNodes(null, ctx::receiveTree), ctx.receiveValue(null, String.class), ctx.receiveNode(null, ctx::receiveTree), ctx.receiveNode(null, ctx::receiveTree));
        }

        private static Yaml.Sequence.Entry createYamlSequenceEntry(ReceiverContext ctx) {
            return new Yaml.Sequence.Entry(ctx.receiveNonNullValue(null, UUID.class), ctx.receiveNonNullValue(null, String.class), ctx.receiveNonNullNode(null, ctx::receiveMarkers), ctx.receiveNonNullNode(null, ctx::receiveTree), ctx.receiveNonNullValue(null, Boolean.TYPE).booleanValue(), ctx.receiveValue(null, String.class));
        }

        private static Yaml.Alias createYamlAlias(ReceiverContext ctx) {
            return new Yaml.Alias(ctx.receiveNonNullValue(null, UUID.class), ctx.receiveNonNullValue(null, String.class), ctx.receiveNonNullNode(null, ctx::receiveMarkers), ctx.receiveNonNullNode(null, ctx::receiveTree));
        }

        private static Yaml.Anchor createYamlAnchor(ReceiverContext ctx) {
            return new Yaml.Anchor(ctx.receiveNonNullValue(null, UUID.class), ctx.receiveNonNullValue(null, String.class), ctx.receiveNonNullValue(null, String.class), ctx.receiveNonNullNode(null, ctx::receiveMarkers), ctx.receiveNonNullValue(null, String.class));
        }

        private static Yaml.Tag createYamlTag(ReceiverContext ctx) {
            return new Yaml.Tag(ctx.receiveNonNullValue(null, UUID.class), ctx.receiveNonNullValue(null, String.class), ctx.receiveNonNullNode(null, ctx::receiveMarkers), ctx.receiveNonNullValue(null, String.class), ctx.receiveNonNullValue(null, String.class), ctx.receiveNonNullValue(null, Yaml.Tag.Kind.class));
        }
    }
}

